/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.operation.CEBuildAndDeployOperation;
import com.avaya.eclipse.plugin.operation.CECommandExecOperation;
import com.avaya.eclipse.plugin.operation.CEDeleteServiceOperation;
import com.avaya.eclipse.plugin.operation.CEDeploymentOperation;
import com.avaya.eclipse.plugin.operation.CEDisableWatchServiceLogOperation;
import com.avaya.eclipse.plugin.operation.CEListServicesVerboseOperation;
import com.avaya.eclipse.plugin.operation.CEWatchServiceLogOperation;
import com.avaya.ssh.SSHConnection;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class CEOperation {
    protected IProject project;
    public static final String CE_SVAR_COPY_PATH = "/tmp/";
    protected MessageConsoleStream out = null;
    protected PrintWriter writer;
    private StringBuffer tempLogBuffer = new StringBuffer();
    private char lastChar;

    public abstract IStatus execute(IProgressMonitor var1) throws Exception;

    public static CEOperation getOperation(String actionType, String serviceName) {
        if ("CLEAN_BUILD_DEPLOY_SMGR".equals(actionType)) {
            CEBuildAndDeployOperation co = new CEBuildAndDeployOperation();
            co.setThroughSMGR(true);
            return co;
        }
        if ("CLEAN_BUILD_DEPLOY".equals(actionType)) {
            return new CEBuildAndDeployOperation();
        }
        if ("delete service".equals(actionType)) {
            return new CEDeleteServiceOperation();
        }
        if ("info logging".equals(actionType)) {
            return new CECommandExecOperation(null, "ce dlogoff INFO");
        }
        if ("full logging".equals(actionType)) {
            return new CECommandExecOperation(null, "ce dlogon");
        }
        if ("list services verbose".equals(actionType)) {
            return new CEListServicesVerboseOperation();
        }
        if ("watch log".equals(actionType)) {
            return new CEWatchServiceLogOperation(false);
        }
        if ("watch service log".equals(actionType)) {
            return new CEWatchServiceLogOperation(true);
        }
        if ("DEPLOY".equals(actionType)) {
            CEDeploymentOperation ceDeploymentOperation = new CEDeploymentOperation();
            ceDeploymentOperation.setReDeployOperation(true);
            return ceDeploymentOperation;
        }
        if ("disable watch log".equals(actionType)) {
            return new CEDisableWatchServiceLogOperation(false);
        }
        if ("disable watch service log".equals(actionType)) {
            return new CEDisableWatchServiceLogOperation(true);
        }
        if ("info snapin logging".equals(actionType)) {
            return new CECommandExecOperation(null, "ce dlogoff " + serviceName.substring(0, serviceName.lastIndexOf(45)));
        }
        if ("full snapin logging".equals(actionType)) {
            return new CECommandExecOperation(null, "ce dlogon " + serviceName.substring(0, serviceName.lastIndexOf(45)));
        }
        return null;
    }

    public MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = null;
        if (plugin != null) {
            conMan = plugin.getConsoleManager();
            IConsole[] existing = conMan.getConsoles();
            for (int i = 0; i < existing.length; ++i) {
                if (!name.equals(existing[i].getName())) continue;
                ((MessageConsole)existing[i]).activate();
                return (MessageConsole)existing[i];
            }
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        if (conMan != null) {
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        myConsole.activate();
        return myConsole;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void setMessageConsoleStream() {
        try {
            MessageConsole myConsole = null;
            myConsole = this.project != null ? this.findConsole(this.project.getProject().getName()) : this.findConsole("Avaya Breeze Console");
            this.out = myConsole.newMessageStream();
            this.writer = new PrintWriter((OutputStream)this.out, true);
        }
        catch (Exception e) {
            this.writer = new PrintWriter(System.out, true);
        }
    }

    protected void setMessageConsoleStream(String extraName) {
        try {
            MessageConsole myConsole = this.findConsole(this.project.getProject().getName() + "-" + extraName);
            this.out = myConsole.newMessageStream();
            this.writer = new PrintWriter((OutputStream)this.out, true);
        }
        catch (Exception e) {
            this.writer = new PrintWriter(System.out, true);
        }
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void logConsole(char c) {
        if (c == '\r' && this.lastChar == '\n' || c == '\n' && this.lastChar == '\r') {
            this.lastChar = c;
            return;
        }
        this.lastChar = c;
        if (c == '\n' || c == '\r') {
            String message = SSHConnection.context.get() + " " + this.tempLogBuffer.toString();
            if (message != null && message.contains("COMMAND#")) {
                message = message.replace("COMMAND#", "");
            }
            this.writer.println(message);
            this.tempLogBuffer = new StringBuffer();
        } else {
            this.tempLogBuffer.append(c);
        }
    }

    public void logConsole(String message) {
        if (this.out != null) {
            new PrintWriter((OutputStream)this.out, true).println(message);
        } else {
            this.writer.println(this.tempLogBuffer.toString());
        }
    }

    public void update(char c) {
        this.logConsole(c);
    }

    public static void openDialog(final String header, final String reason) {
        if (!PluginUtilities.getInstance().isDemoMode()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (reason == null || reason.isEmpty()) {
                        MessageDialog.openError(null, (String)header, (String)"An error occurred while trying to perform the operation. Please check the node selection, reachability and credentials configured for servers.");
                    } else {
                        MessageDialog.openError(null, (String)header, (String)reason);
                    }
                }
            });
        }
        throw new RuntimeException(reason);
    }

    public static void openErrorDialog(final String header, final String reason) {
        if (!PluginUtilities.getInstance().isDemoMode()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (reason == null || reason.isEmpty()) {
                        MessageDialog.openError(null, (String)header, (String)"An error occurred while trying to perform the operation. Please check the node selection, reachability and credentials configured for servers.");
                    } else {
                        MessageDialog.openError(null, (String)header, (String)reason);
                    }
                }
            });
        }
    }

    public void logConsole(String message, String tag) {
        this.logConsole(tag + " " + message);
    }
}

