/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ssh;

import com.avaya.eclipse.plugin.Activator;
import com.sshtools.ssh.components.SshCipher;
import java.io.IOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES128CBCCipher
extends SshCipher {
    private Cipher cipher = null;
    private static final int KEYSIZE = 16;

    public AES128CBCCipher(String algorithm) {
        super(algorithm);
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public void init(int mode, byte[] iv, byte[] keydata) throws IOException {
        try {
            byte[] actualKey = new byte[16];
            System.arraycopy(keydata, 0, actualKey, 0, actualKey.length);
            SecretKeySpec keySpec = new SecretKeySpec(actualKey, "AES");
            this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec ivSpec = new IvParameterSpec(iv, 0, this.cipher.getBlockSize());
            this.cipher.init(mode == 0 ? 1 : 2, (Key)keySpec, ivSpec);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error initializing cipher ", e);
            throw new IOException("Error initializing cipher : " + e.getMessage());
        }
    }

    public void transform(byte[] src, int start, byte[] dest, int offset, int len) throws IOException {
        try {
            this.cipher.update(src, start, len, dest, offset);
        }
        catch (ShortBufferException e) {
            Activator.log(4, 0, "Error transforming the cipher ", e);
            throw new IOException("Error transforming the cipher : " + e.getMessage());
        }
    }
}

