/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.common.logging.client.Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class DMBasedTimer {
    private static Logger log = AsmLogger.getLogger(DMBasedTimer.class);
    protected boolean isDaemon = false;
    protected String name = DMBasedTimer.class.getSimpleName();
    protected Map<String, Timer> timerMap = new HashMap<String, Timer>();

    public DMBasedTimer(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    public DMBasedTimer(String name) {
        this.name = name;
    }

    public DMBasedTimer(String name, boolean isDaemon) {
        this.isDaemon = isDaemon;
        this.name = name;
    }

    public DMBasedTimer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timer getTimer() {
        String clId = DMUtilities.getCurrentThreadIdentity(null);
        Map<String, Timer> map = this.timerMap;
        synchronized (map) {
            if (this.timerMap.get(clId) == null) {
                this.timerMap.put(clId, new CLTimer(clId, this.name, this.isDaemon));
            }
            return this.timerMap.get(clId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TimerTask> cancel() {
        String clId = DMUtilities.getCurrentThreadIdentity(null);
        Set<TimerTask> cancelledTasks = new HashSet<TimerTask>();
        Map<String, Timer> map = this.timerMap;
        synchronized (map) {
            CLTimer clTimer = (CLTimer)this.timerMap.remove(clId);
            if (clTimer != null) {
                log.info((Object)("cancel: Cancelling DMBasedTimer for CL: " + clId));
                clTimer.cancel();
                cancelledTasks = clTimer.tasks;
            } else {
                log.info((Object)("cancel: No DMBasedTimer to cancel for CL: " + clId));
            }
        }
        return cancelledTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Map<String, Timer> map = this.timerMap;
        synchronized (map) {
            for (Timer t : this.timerMap.values()) {
                t.cancel();
            }
            this.timerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int i = 0;
        Map<String, Timer> map = this.timerMap;
        synchronized (map) {
            for (Timer t : this.timerMap.values()) {
                i += t.purge();
            }
            this.timerMap.clear();
        }
        return i;
    }

    public void schedule(TimerTask task, long delay) {
        this.getTimer().schedule(task, delay);
    }

    public void schedule(TimerTask task, Date time) {
        this.getTimer().schedule(task, time);
    }

    public void schedule(TimerTask task, long delay, long period) {
        this.getTimer().schedule(task, delay, period);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        this.getTimer().schedule(task, firstTime, period);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        this.getTimer().scheduleAtFixedRate(task, delay, period);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        this.getTimer().scheduleAtFixedRate(task, firstTime, period);
    }

    public int hashCode() {
        return this.getTimer().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getTimer().equals(obj);
    }

    public String toString() {
        return "DMBasedTimer[isDaemon=" + this.isDaemon + ", name=" + this.name + ", timerMap=" + this.timerMap + "]";
    }

    protected class CLTimer
    extends Timer {
        protected Set<TimerTask> tasks;

        public CLTimer(String clId, String name, Boolean isDaemon) {
            super(clId + "_" + name, isDaemon);
            this.tasks = new WeakHashSet<TimerTask>();
        }

        @Override
        public void schedule(TimerTask task, long delay) {
            super.schedule(task, delay);
            this.tasks.add(task);
        }

        @Override
        public void schedule(TimerTask task, Date time) {
            super.schedule(task, time);
            this.tasks.add(task);
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
            super.schedule(task, delay, period);
            this.tasks.add(task);
        }

        @Override
        public void schedule(TimerTask task, Date firstTime, long period) {
            super.schedule(task, firstTime, period);
            this.tasks.add(task);
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
            super.scheduleAtFixedRate(task, delay, period);
            this.tasks.add(task);
        }

        @Override
        public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
            super.scheduleAtFixedRate(task, firstTime, period);
            this.tasks.add(task);
        }
    }
}

