/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.cassandra.driver.policy;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PreferredHostPolicy
implements ChainableLoadBalancingPolicy {
    ArrayList<InetSocketAddress> preferredHosts = new ArrayList();
    LoadBalancingPolicy childPolicy;

    public PreferredHostPolicy(LoadBalancingPolicy childPolicy, Collection<InetSocketAddress> preference) {
        this.childPolicy = childPolicy;
        this.preferredHosts.addAll(preference);
    }

    public void close() {
        this.childPolicy.close();
    }

    public HostDistance distance(Host host) {
        return this.childPolicy.distance(host);
    }

    public void init(Cluster cluster, Collection<Host> hosts) {
        this.childPolicy.init(cluster, hosts);
    }

    public Iterator<Host> newQueryPlan(String keyspace, Statement statement) {
        final Iterator childIterator = this.childPolicy.newQueryPlan(keyspace, statement);
        return new AbstractIterator<Host>(){
            private List<Host> alreadySeen = null;
            private int curPrefIdx = 0;

            protected Host computeNext() {
                Host host;
                InetSocketAddress curAddr = null;
                while (this.curPrefIdx < PreferredHostPolicy.this.preferredHosts.size()) {
                    curAddr = PreferredHostPolicy.this.preferredHosts.get(this.curPrefIdx);
                    boolean found = false;
                    if (this.alreadySeen != null) {
                        Iterator<Host> it = this.alreadySeen.iterator();
                        while (it.hasNext()) {
                            Host host2 = it.next();
                            InetAddress broadcastAddress = null;
                            if (host2 != null) {
                                broadcastAddress = host2.getBroadcastAddress();
                            }
                            if (broadcastAddress == null || !broadcastAddress.equals(curAddr.getAddress())) continue;
                            it.remove();
                            if (host2.isUp()) {
                                ++this.curPrefIdx;
                                return host2;
                            }
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        while (childIterator.hasNext()) {
                            host = (Host)childIterator.next();
                            InetAddress broadcastAddress = null;
                            if (host != null) {
                                broadcastAddress = host.getBroadcastAddress();
                            }
                            if (broadcastAddress != null && broadcastAddress.equals(curAddr.getAddress())) {
                                if (!host.isUp()) break;
                                ++this.curPrefIdx;
                                return host;
                            }
                            if (this.alreadySeen == null) {
                                this.alreadySeen = new ArrayList<Host>();
                            }
                            this.alreadySeen.add(host);
                        }
                    }
                    ++this.curPrefIdx;
                }
                if (this.alreadySeen != null) {
                    if (!this.alreadySeen.isEmpty()) {
                        Iterator<Host> it = this.alreadySeen.iterator();
                        host = it.next();
                        it.remove();
                        return host;
                    }
                    this.alreadySeen = null;
                }
                if (childIterator.hasNext()) {
                    Host host3 = (Host)childIterator.next();
                    return host3;
                }
                return (Host)this.endOfData();
            }
        };
    }

    public void onAdd(Host host) {
        this.childPolicy.onAdd(host);
    }

    public void onDown(Host host) {
        this.childPolicy.onDown(host);
    }

    public void onRemove(Host host) {
        this.childPolicy.onRemove(host);
    }

    public void onUp(Host host) {
        this.childPolicy.onUp(host);
    }

    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }
}

