/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.AppParamsAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.ustore.AppParamsDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.AppParams;
import com.avaya.ustore.objectapi.NetworkTopologyInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppParamsDM
implements AppParamsAPI {
    private final Logger log = AsmLogger.getLogger(AppParamsDM.class);
    CassandraDAOFactory<AppParamsDAO> appParamsDAOFactory = new CassandraDAOFactory();

    @Override
    public AppParams getAppParamsByName(String appName, CassandraConnectionInfo cConnInfo) throws DMException {
        String fcn_name = "getAppParamsByName";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAppParamsByName: enter, appName=" + appName));
        }
        AppParamsDAO appParamsDAO = this.getAppParamsDAO(cConnInfo);
        AppParams appParams = appParamsDAO.getAppParamsByAppName(appName);
        if (isFiner) {
            this.log.finer((Object)("getAppParamsByName: leave, appParams=" + appParams));
        }
        return appParams;
    }

    public AppParamsDAO getAppParamsDAO(CassandraConnectionInfo cConnInfo) throws DMException {
        String fcn_name = "getAppParamsDAO";
        AppParamsDAO dao = this.appParamsDAOFactory.getDAOInstance(cConnInfo, AppParamsDAO.class);
        if (dao == null) {
            String msg = "getAppParamsDAO: getDAOInstance failed, cConnInfo=" + cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }

    @Override
    public Map<String, Set<NetworkTopologyInfo>> getAllNetworkTopologyKS(CassandraConnectionInfo cConnInfo) throws DMException {
        String fcn_name = "getAllNetworkTopologyKS";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)"getAllNetworkTopologyKS: enter");
        }
        AppParamsDAO appParamsDAO = this.getAppParamsDAO(cConnInfo);
        HashMap<String, Set<NetworkTopologyInfo>> parms = new HashMap<String, Set<NetworkTopologyInfo>>();
        List<String> appNames = appParamsDAO.getAllNames();
        for (String appName : appNames) {
            if (isFinest) {
                this.log.finest((Object)("getAllNetworkTopologyKS: retrieving NetworkTopologyInfo for appName=" + appName));
            }
            Set<NetworkTopologyInfo> ntiSet = appParamsDAO.getAllNetworkTopologyByAppName(appName);
            parms.put(appName, ntiSet);
            if (ntiSet == null || !isFinest) continue;
            this.log.finest((Object)("getAllNetworkTopologyKS: appName=" + appName + ", ntiSet=" + Arrays.toString(ntiSet.toArray())));
        }
        if (isFiner) {
            this.log.finer((Object)("getAllNetworkTopologyKS: leave, parms.size=" + parms.size()));
        }
        return parms;
    }
}

