/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.CallHistoryAPI_70;
import com.avaya.asm.datamgr.dao.CallHistoryDAO_70;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.KeyInfo;
import java.util.List;
import java.util.UUID;

public class CallHistoryDM_70
implements CallHistoryAPI_70 {
    private final Logger log = AsmLogger.getLogger(CallHistoryDM_70.class);

    @Override
    public void addCallHistory(KeyInfo keyInfo, Integer maxLogs, List<CallLog> callLogs) throws DMException {
        long endTime;
        String fcn_name = "addCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter with keyInfo=" + keyInfo + ", maxLog=" + maxLogs + ", callLogs.size()=" + callLogs.size()));
        }
        if (keyInfo == null) {
            this.log.warn((Object)"addCallHistory: keyInfo was null ");
            return;
        }
        List<UUID> deleteUuids = null;
        int numToDelete = 0;
        CallHistoryDAO_70 dao = CallHistoryDAO_70.getInstance();
        if (maxLogs != null) {
            if (maxLogs <= 0) {
                throw new IllegalArgumentException("maxLogs is <= 0: " + maxLogs);
            }
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            List<UUID> allUuids = dao.getCallLogIds(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getSetId(), keyInfo.getNumSMs());
            if (isFinest) {
                endTime = System.currentTimeMillis();
                this.log.finest((Object)("addCallHistory: dao.getCallLogIds took " + (endTime - startTime) + "ms, allUuids.size=" + allUuids.size()));
            }
            if (allUuids.size() > 0) {
                numToDelete = allUuids.size() + callLogs.size() - maxLogs;
                if (numToDelete > 0) {
                    deleteUuids = allUuids.subList(0, numToDelete);
                }
            } else if (isFinest) {
                this.log.finest((Object)("addCallHistory: The Cassandra DB is empty so no existing call logs will be deleted from it for: " + keyInfo));
            }
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
            this.log.finest((Object)("addCallHistory: We will now update the call logs for: " + keyInfo));
        }
        dao.updateCallLogs(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getUserId(), keyInfo.getSetId(), deleteUuids, callLogs, keyInfo.getNumSMs());
        if (isFinest) {
            endTime = System.currentTimeMillis();
            this.log.finest((Object)("addCallHistory: dao.updateCallLogs took " + (endTime - startTime) + "ms, deleteUuids.size=" + (deleteUuids != null ? deleteUuids.size() : -1)));
        }
        if (isFiner) {
            this.log.finer((Object)"addCallHistory: leave");
        }
    }

    @Override
    public void deleteCallHistoryById(KeyInfo keyInfo, List<UUID> callLogUuids) throws DMException {
        CallHistoryDAO_70 dao = CallHistoryDAO_70.getInstance();
        dao.deleteCallLogs(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getUserId(), keyInfo.getSetId(), callLogUuids, keyInfo.getNumSMs());
    }

    @Override
    public void deleteCallHistoryByLimit(KeyInfo keyInfo, int maxLogs) throws DMException {
        String fcn_name = "deleteCallHistoryByLimit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryByLimit: enter with keyInfo=" + keyInfo + ", maxLogs=" + maxLogs));
        }
        if (keyInfo == null) {
            this.log.warn((Object)"deleteCallHistoryByLimit: keyInfo was null ");
            return;
        }
        CallHistoryDAO_70 dao = CallHistoryDAO_70.getInstance();
        if (maxLogs == 0) {
            dao.deleteAllCallLogs(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getSetId(), keyInfo.getNumSMs());
        } else {
            List<UUID> deleteUuids = null;
            List<UUID> allUuids = dao.getCallLogIds(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getSetId(), keyInfo.getNumSMs());
            int numToDelete = allUuids.size() - maxLogs;
            if (numToDelete > 0) {
                deleteUuids = allUuids.subList(0, numToDelete);
                dao.deleteCallLogs(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getUserId(), keyInfo.getSetId(), deleteUuids, keyInfo.getNumSMs());
            }
        }
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryByLimit: leave");
        }
    }

    @Override
    public List<CallLog> getCallHistory(KeyInfo keyInfo, Integer maxLogs) throws DMException {
        String fcn_name = "getCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: enter with keyInfo =" + keyInfo + ", maxLogs=" + maxLogs));
        }
        if (keyInfo == null) {
            this.log.warn((Object)"getCallHistory: keyInfo was null ");
            return null;
        }
        CallHistoryDAO_70 dao = CallHistoryDAO_70.getInstance();
        List<CallLog> allCallLogs = dao.getCallHistory(keyInfo.getAsmId(), keyInfo.getCommId(), keyInfo.getBsmId(), keyInfo.getSetId(), maxLogs, keyInfo.getNumSMs());
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: leave, callLogs.size()=" + allCallLogs.size()));
        }
        return allCallLogs;
    }

    public static void setConnInfo(String host, int port, String dbUsername, String dbPassword) {
        CallHistoryDAO_70.setConnInfo(host, port, dbUsername, dbPassword);
    }
}

