/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.CassandraSystemAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.CassandraNodeData;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.ustore.CassandraSystemDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import java.util.Collection;

public class CassandraSystemDM
implements CassandraSystemAPI {
    private final Logger log = AsmLogger.getLogger(this.getClass());
    private CassandraDAOFactory<CassandraSystemDAO> casSysDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;

    public CassandraSystemDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    @Override
    public void getAllColumnFamilies(Collection<ColumnFamilyMetaData> columnFamilies) throws DMException {
        String fcn_name = "getAppParamsByName";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAppParamsByName: enter, columnFamilies.size=" + columnFamilies.size()));
        }
        CassandraSystemDAO casSysDAO = this.getCassandraSystemDAO();
        casSysDAO.getAllColumnFamilies(columnFamilies);
        if (isFiner) {
            this.log.finer((Object)("getAppParamsByName: leave, columnFamilies.size=" + columnFamilies.size()));
        }
    }

    @Override
    public void getLocalCassandraNodeData(CassandraNodeData nodeData) throws DMException {
        String fcn_name = "getLocalCassandraNodeData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getLocalCassandraNodeData: enter");
        }
        CassandraSystemDAO casSysDAO = this.getCassandraSystemDAO();
        casSysDAO.getLocalCassandraNodeData(nodeData);
        if (isFiner) {
            this.log.finer((Object)("getLocalCassandraNodeData: leave, nodeData=" + nodeData));
        }
    }

    @Override
    public void getAllRemoteCassandraNodeData(Collection<CassandraNodeData> nodeDataRecs) throws DMException {
        String fcn_name = "getLocalCassandraNodeData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getLocalCassandraNodeData: enter");
        }
        CassandraSystemDAO casSysDAO = this.getCassandraSystemDAO();
        casSysDAO.getAllRemoteCassandraNodeData(nodeDataRecs);
        if (isFiner) {
            this.log.finer((Object)("getLocalCassandraNodeData: leave, nodeDataRecs.size()=" + nodeDataRecs.size()));
        }
    }

    private CassandraSystemDAO getCassandraSystemDAO() throws DMException {
        String fcn_name = "getAppParamsDAO";
        CassandraSystemDAO dao = this.casSysDAOFactory.getDAOInstance(this.cConnInfo, CassandraSystemDAO.class);
        if (dao == null) {
            String msg = "getAppParamsDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }
}

