/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.UpdatedContactsAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.ustore.UpdatedContactsHistoryDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.UpdatedUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class UpdatedContactsDM
implements UpdatedContactsAPI {
    private final Logger log = AsmLogger.getLogger(UpdatedContactsDM.class);
    private UpdatedContactsHistoryDAO updatedContactsHistoryDAO = null;
    private static final int HISTORY_IN_DAYS = 5;
    private static final int NUM_ROWS = 7;
    private static final long DAY_IN_MILLIS = 86400000L;
    private CassandraDAOFactory<UpdatedContactsHistoryDAO> contactDAOFactory = new CassandraDAOFactory();

    public UpdatedContactsDM(CassandraConnectionInfo cConnInfo) {
        this.updatedContactsHistoryDAO = this.contactDAOFactory.getDAOInstance(cConnInfo, UpdatedContactsHistoryDAO.class);
    }

    @Override
    public List<UpdatedUser> getUsersWithUpdatedContacts(long beginningAtTimeMillis) throws DMException {
        int oldestDay;
        String fcn_name = "getUsersWithUpdatedContacts";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getUsersWithUpdatedContacts: enter with beginningAtTimeMillis = " + beginningAtTimeMillis));
        }
        long currentTimeInMillis = new Date().getTime();
        int newestDay = this.getDayFromGivenTime(currentTimeInMillis);
        if (isFinest) {
            this.log.finest((Object)("getUsersWithUpdatedContacts: newestDay = " + newestDay));
        }
        int n = oldestDay = this.isGivenTimeHistoric(beginningAtTimeMillis, currentTimeInMillis) ? this.getOldestDayFromCurrentTime(currentTimeInMillis) : this.getDayFromGivenTime(beginningAtTimeMillis);
        if (isFinest) {
            this.log.finest((Object)("getUsersWithUpdatedContacts: oldestDay = " + oldestDay));
        }
        Collection<UpdatedUser> updatedusers = this.getUsersBetweenDays(oldestDay, newestDay, currentTimeInMillis);
        if (isFiner) {
            this.log.finer((Object)("getUsersWithUpdatedContacts: leave,  updatedusers=" + updatedusers));
        }
        return new ArrayList<UpdatedUser>(updatedusers);
    }

    @Override
    public void insertUpdatedContact(long csuserId) throws DMException {
        this.insertUpdatedContact(csuserId, new Date().getTime());
    }

    @Override
    public void insertUpdatedContact(long csuserId, long updateTimeMillis) throws DMException {
        String fcn_name = "insertUpdatedContact";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("insertUpdatedContact: enter csuerId = " + csuserId + ", updateTime=" + updateTimeMillis));
        }
        int day = this.getDayFromGivenTime(updateTimeMillis);
        this.updatedContactsHistoryDAO.addUser(day, csuserId, updateTimeMillis);
        if (isFiner) {
            this.log.finer((Object)"insertUpdatedContact: leave ");
        }
    }

    @Override
    public void cleanupOldRecords() throws DMException {
        String fcn_name = "cleanupOldRecords";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"cleanupOldRecords: enter ");
        }
        int oldestDay = this.getOldestDayFromCurrentTime(new Date().getTime());
        this.updatedContactsHistoryDAO.deleteUsers(oldestDay);
        if (isFiner) {
            this.log.finer((Object)("cleanupOldRecords: leave ,cleaned up records of day = " + oldestDay));
        }
    }

    @Override
    public void setUserInfoDataOkFlag(long csuserId, boolean dataok) throws DMException {
        String fcn_name = "setUserInfoDataOkFlag";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setUserInfoDataOkFlag: enter csuserId=" + csuserId + ", dataok=" + dataok));
        }
        this.updatedContactsHistoryDAO.setUserInfoDataOkFlag(csuserId, dataok);
        if (isFiner) {
            this.log.finer((Object)"setUserInfoDataOkFlag: leave ");
        }
    }

    @Override
    public boolean getUserInfoDataOkFlag(long csuserId) throws DMException {
        String fcn_name = "getUserInfoDataOkFlag";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getUserInfoDataOkFlag: enter csuserId=" + csuserId));
        }
        boolean dataok = this.updatedContactsHistoryDAO.getUserInfoDataOkFlag(csuserId);
        if (isFiner) {
            this.log.finer((Object)("getUserInfoDataOkFlag: leave, dataok=" + dataok));
        }
        return dataok;
    }

    @Override
    public Long getUserInfoTimestamp(long csuserId) throws DMException {
        String fcn_name = "getUserInfoTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getUserInfoTimestamp: enter csuserId=" + csuserId));
        }
        Long lastTimeContactListUpdated = this.updatedContactsHistoryDAO.getUserInfoTimestamp(csuserId);
        if (isFiner) {
            this.log.finer((Object)("getUserInfoTimestamp: leave, lastTimeContactListUpdated = " + lastTimeContactListUpdated));
        }
        return lastTimeContactListUpdated;
    }

    public Collection<UpdatedUser> getUsersBetweenDays(int oldestDay, int newestDay, long currentTimeInMillis) throws DMException {
        String fcn_name = "getUsersBetweenDays";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getUsersBetweenDays: enter oldestDay = " + oldestDay + ", newestDay=" + newestDay + ", currentTimeInMillis = " + currentTimeInMillis));
        }
        HashSet<UpdatedUser> updatedusers = new HashSet<UpdatedUser>();
        int currentDay = newestDay;
        while (currentDay != oldestDay) {
            this.updateUsersCollection(updatedusers, currentDay, currentTimeInMillis);
            if (--currentDay != -1) continue;
            currentDay = 6;
        }
        if (currentDay == oldestDay) {
            this.updateUsersCollection(updatedusers, currentDay, currentTimeInMillis);
        }
        if (isFiner) {
            this.log.finer((Object)("getUsersBetweenDays: leave,  updatedusers=" + updatedusers));
        }
        return updatedusers;
    }

    @Override
    public void truncateUserInfo() throws DMException {
        String fcn_name = "truncateUserInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"truncateUserInfo: enter");
        }
        this.updatedContactsHistoryDAO.truncateUserInfo();
        if (isFiner) {
            this.log.finer((Object)"truncateUserInfo: leave");
        }
    }

    @Override
    public void truncateUpdatedContacts() throws DMException {
        String fcn_name = "truncateUpdatedContacts";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"truncateUpdatedContacts: enter");
        }
        this.updatedContactsHistoryDAO.truncateUpdatedContacts();
        if (isFiner) {
            this.log.finer((Object)"truncateUpdatedContacts: leave");
        }
    }

    @Override
    public boolean isUserInfoEmpty() throws DMException {
        String fcn_name = "isUpdatedContactsEmpty";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"isUpdatedContactsEmpty: enter");
        }
        boolean rc = false;
        rc = this.updatedContactsHistoryDAO.isEmptyUserInfo();
        if (isFiner) {
            this.log.finer((Object)("isUpdatedContactsEmpty: leave, rc=" + rc));
        }
        return rc;
    }

    @Override
    public boolean isUpdatedContactsEmpty() throws DMException {
        String fcn_name = "isUpdatedContactsEmpty";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"isUpdatedContactsEmpty: enter");
        }
        boolean rc = false;
        rc = this.updatedContactsHistoryDAO.isEmptyUpdatedContacts();
        if (isFiner) {
            this.log.finer((Object)("isUpdatedContactsEmpty: leave, rc=" + rc));
        }
        return rc;
    }

    private void updateUsersCollection(Collection<UpdatedUser> updatedUsers, int currentDay, long currentTimeInMillis) throws DMException {
        String fcn_name = "updateUsersCollection";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("updateUsersCollection: enter , currentDay = " + currentDay + ",  Total updatedUsers = " + updatedUsers.size()));
        }
        List<UpdatedUser> updatesUsersDbList = this.updatedContactsHistoryDAO.getUsers(currentDay);
        for (UpdatedUser user : updatesUsersDbList) {
            long updateTimeMillis = user.getUpdateTimeMillis();
            if (this.isGivenTimeHistoric(updateTimeMillis, currentTimeInMillis)) continue;
            updatedUsers.add(user);
        }
        if (isFiner) {
            this.log.finer((Object)("updateUsersCollection: leave , currentDay = " + currentDay + ",  Total updatedUsers = " + updatedUsers.size()));
        }
    }

    private int getDayFromGivenTime(long timeInMillis) {
        String fcn_name = "getDayFromGivenTime";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDayFromGivenTime: enter , timeInMillis=" + timeInMillis));
        }
        int daysSinceEpoch = (int)(timeInMillis / 86400000L);
        int day = daysSinceEpoch % 7;
        if (isFiner) {
            this.log.finer((Object)("getDayFromGivenTime: leave day=" + day));
        }
        return day;
    }

    private int getOldestDayFromCurrentTime(long currentTimeInMillis) {
        int newestDay;
        int oldestDay;
        String fcn_name = "getOldestDayFromCurrentTime";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getOldestDayFromCurrentTime: enter ");
        }
        if ((oldestDay = (newestDay = this.getDayFromGivenTime(currentTimeInMillis)) + 1) == 7) {
            oldestDay = 0;
        }
        if (isFiner) {
            this.log.finer((Object)("getOldestDayFromCurrentTime: leave oldest day=" + oldestDay));
        }
        return oldestDay;
    }

    private boolean isGivenTimeHistoric(long beginningAtTimeMillis, long currentTimeMillis) {
        int days;
        boolean isHistoric;
        String fcn_name = "isGivenTimeHistoric";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("isGivenTimeHistoric: enter ,  beginningAtTimeMillis = " + beginningAtTimeMillis));
        }
        boolean bl = isHistoric = (days = (int)((currentTimeMillis - beginningAtTimeMillis) / 86400000L)) > 7;
        if (isFiner) {
            this.log.finer((Object)("isGivenTimeHistoric: leave isHistoric = " + isHistoric));
        }
        return isHistoric;
    }
}

