/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmAddressMappingGroupParm;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmAddressMappingGroupDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(AsmAddressMappingGroupDAO.class);
    protected Map<Long, AsmAddressMappingGroupParm> asmAddressMappingGroupMap = new HashMap<Long, AsmAddressMappingGroupParm>();
    public static final String queryAsmAddressMappingGroup = "SELECT id, name FROM asm_address_mapping_group";
    public static final String getAsmAddressMappingGroupById = "SELECT id, name FROM asm_address_mapping_group WHERE id = ?";
    private static final ResultSetMapper asmAddressMappingGroupsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmAddressMappingGroupParm> map = new HashMap<Long, AsmAddressMappingGroupParm>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                String groupName = rs.getString("name");
                AsmAddressMappingGroupParm asmAddressMappingGroupParms = new AsmAddressMappingGroupParm(id, groupName);
                map.put(id, asmAddressMappingGroupParms);
            }
            return map;
        }
    };
    private static final ResultSetMapper asmAddressMappingGroupMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                Long id = rs.getLong("id");
                String groupName = rs.getString("name");
                return new AsmAddressMappingGroupParm(id, groupName);
            }
            return null;
        }
    };

    public AsmAddressMappingGroupDAO() {
        super(true);
    }

    public static ResultSetMapper getAsmAddressMappingGroupsMapper() {
        return asmAddressMappingGroupsMapper;
    }

    public static ResultSetMapper getAsmAddressMappingGroupMapper() {
        return asmAddressMappingGroupMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        HashMap asmAddressMappingGroupMapTMP;
        String fcn_name = AsmAddressMappingGroupDAO.class.getSimpleName() + ".init: ";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)(fcn_name + "Enter"));
        }
        Object[] params = new Object[]{};
        try {
            asmAddressMappingGroupMapTMP = (HashMap)this.dataSource.executeQuery(queryAsmAddressMappingGroup, params, AsmAddressMappingGroupDAO.getAsmAddressMappingGroupsMapper());
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error " + fcn_name), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.asmAddressMappingGroupMap = asmAddressMappingGroupMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                if (isFine) {
                    log.fine((Object)(fcn_name + " completed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = AsmAddressMappingGroupDAO.class.getSimpleName() + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        Long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        AsmAddressMappingGroupParm oldAsmAddressMappingGroupParm = null;
        AsmAddressMappingGroupParm newAsmAddressMappingGroupParm = null;
        boolean lockHeld = false;
        try {
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                newAsmAddressMappingGroupParm = (AsmAddressMappingGroupParm)this.dataSource.executeQuery(getAsmAddressMappingGroupById, params, AsmAddressMappingGroupDAO.getAsmAddressMappingGroupMapper());
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldAsmAddressMappingGroupParm = this.asmAddressMappingGroupMap.remove(id);
            if (operation == DAOReplicationEvent.OperationType.DELETE && oldAsmAddressMappingGroupParm == null) {
                log.warn((Object)(fcn_name + "AsmAddressMappingGroupParm was null for " + (Object)((Object)tableEvent.getOperation()) + " operation; we are probably out of sync"));
            }
            if (operation != DAOReplicationEvent.OperationType.DELETE && newAsmAddressMappingGroupParm != null) {
                if (isFiner) {
                    log.finer((Object)(fcn_name + "Retrieved " + newAsmAddressMappingGroupParm.toString()));
                }
                this.asmAddressMappingGroupMap.put(id, newAsmAddressMappingGroupParm);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing, e = "), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + ". Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + "update successful"));
            }
        }
        if (oldAsmAddressMappingGroupParm != null && newAsmAddressMappingGroupParm == null) {
            if (isFinest) {
                log.finest((Object)(fcn_name + " calling updateListeners: oldAsmAddressMappingGroupParm = " + oldAsmAddressMappingGroupParm + " and newAsmAddressMappingGroupParm is null."));
            }
            this.updateListeners(oldAsmAddressMappingGroupParm, newAsmAddressMappingGroupParm);
        }
        if (isFine) {
            log.fine((Object)(fcn_name + " Successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_address_mapping_group");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmAddressMappingGroupParm getAsmAddressMappingGroupMapById(Long id) {
        String fcn_name = AsmAddressMappingGroupDAO.class.getSimpleName() + ".getAsmAddressMappingGroupMapById: " + id;
        try {
            this.lock.acquireReadLock();
            for (AsmAddressMappingGroupParm asmAMGP : this.asmAddressMappingGroupMap.values()) {
                if (asmAMGP.getId().longValue() != id.longValue()) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Found Address Mapping Group Settings: " + this.asmAddressMappingGroupMap.get(asmAMGP.getId())));
                }
                AsmAddressMappingGroupParm asmAddressMappingGroupParm = this.asmAddressMappingGroupMap.get(asmAMGP.getId());
                return asmAddressMappingGroupParm;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    @Override
    protected Object getMainCollection() {
        return this.asmAddressMappingGroupMap;
    }
}

