/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.ConfFactory;
import com.avaya.asm.datamgr.objectapi.MediaAttributes;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConfFactoryDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(ConfFactoryDAO.class);
    protected Map<Long, String> confWellKnownUriIdMap = new HashMap<Long, String>();
    protected Map<String, Long> confWellKnownUriMap = new HashMap<String, Long>();
    protected Map<Long, ConfFactory> confFactoryMap = new HashMap<Long, ConfFactory>();
    protected Map<Long, Map<Integer, ConfFactory>> confFactorySetMap = new HashMap<Long, Map<Integer, ConfFactory>>();
    protected final List<String> dependentTables = new ArrayList<String>();
    protected static final String getConfWellKnownUris = "SELECT id, uri FROM asm_conf_well_known_uri";
    protected static final String getConfWellKnownUri = "SELECT id, uri FROM asm_conf_well_known_uri WHERE id=?";
    protected static final String getConfFactories = "SELECT id, uri, sip_entity_id, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp, asm_conf_factory_set_id, priority_order FROM asm_conf_factory";
    protected static final String getConfFactory = "SELECT id, uri, sip_entity_id, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp, asm_conf_factory_set_id, priority_order FROM asm_conf_factory WHERE id=?";
    protected static final ResultSetMapper confWellKnownUrisMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, rs.getString("uri"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper confWellKnownUriMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getString("uri");
            }
            return null;
        }
    };
    protected static final ResultSetMapper confFactoriesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, ConfFactory> map = new HashMap<Long, ConfFactory>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, new ConfFactory(id, rs.getString("uri"), rs.getLong("sip_entity_id"), new MediaAttributes(true, MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_audio")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_video")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_text")), MediaAttributes.MatchType.valueOf(rs.getString("match_type")), MediaAttributes.IfNoSdp.valueOf(rs.getString("if_no_sdp"))), rs.getLong("asm_conf_factory_set_id"), rs.getInt("priority_order")));
            }
            return map;
        }
    };
    protected static final ResultSetMapper confFactoryMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return new ConfFactory(rs.getLong("id"), rs.getString("uri"), rs.getLong("sip_entity_id"), new MediaAttributes(true, MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_audio")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_video")), MediaAttributes.MediaAccepts.valueOf(rs.getString("accepts_text")), MediaAttributes.MatchType.valueOf(rs.getString("match_type")), MediaAttributes.IfNoSdp.valueOf(rs.getString("if_no_sdp"))), rs.getLong("asm_conf_factory_set_id"), rs.getInt("priority_order"));
            }
            return null;
        }
    };

    public ConfFactoryDAO() {
        this.dependentTables.add("asm_conf_well_known_uri");
        this.dependentTables.add("asm_conf_factory");
    }

    public ResultSetMapper getConfWellKnownUrisMapper() {
        return confWellKnownUrisMapper;
    }

    public ResultSetMapper getConfWellKnownUriMapper() {
        return confWellKnownUriMapper;
    }

    public ResultSetMapper getConfFactoriesMapper() {
        return confFactoriesMapper;
    }

    public ResultSetMapper getConfFactoryMapper() {
        return confFactoryMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap<Long, Map<Integer, ConfFactory>> confFactorySetMapTMP;
        Map<Long, ConfFactory> confFactoryMapTMP;
        HashMap<String, Long> confWellKnownUriMapTMP;
        Map confWellKnownUriIdMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + ConfFactoryDAO.class.getSimpleName()));
        }
        try {
            confWellKnownUriIdMapTMP = (Map)this.dataSource.executeQuery(getConfWellKnownUris, new Object[0], this.getConfWellKnownUrisMapper());
            confWellKnownUriMapTMP = new HashMap<String, Long>();
            for (Map.Entry entry : confWellKnownUriIdMapTMP.entrySet()) {
                confWellKnownUriMapTMP.put(((String)entry.getValue()).toLowerCase(), (Long)entry.getKey());
            }
            confFactoryMapTMP = this.queryConfFactories();
            confFactorySetMapTMP = new HashMap<Long, Map<Integer, ConfFactory>>();
            for (ConfFactory cf : confFactoryMapTMP.values()) {
                Long setId = cf.getSetId();
                Integer prio = cf.getPriorityOrder();
                if (!confFactorySetMapTMP.containsKey(setId)) {
                    confFactorySetMapTMP.put(setId, new TreeMap());
                }
                ((Map)confFactorySetMapTMP.get(setId)).put(prio, cf);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.confWellKnownUriIdMap = confWellKnownUriIdMapTMP;
                this.confWellKnownUriMap = confWellKnownUriMapTMP;
                this.confFactoryMap = confFactoryMapTMP;
                this.confFactorySetMap = confFactorySetMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    protected Map<Long, ConfFactory> queryConfFactories() throws DMException {
        Map confFactoryMapTMP = (Map)this.dataSource.executeQuery(getConfFactories, new Object[0], this.getConfFactoriesMapper());
        return confFactoryMapTMP;
    }

    protected ConfFactory queryConfFactory(Long id) throws DMException {
        Object[] params = new Object[]{id};
        ConfFactory new_cf = (ConfFactory)this.dataSource.executeQuery(getConfFactory, params, this.getConfFactoryMapper());
        return new_cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        block32: {
            DAOReplicationEvent.OperationType operation = event.getOperation();
            boolean locked = false;
            String tableName = event.getTableName();
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            Long id = event.getKey();
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)(ConfFactoryDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
            }
            this.lock.acquireWriteLock();
            locked = true;
            try {
                ConfFactory new_cf;
                block33: {
                    if ("asm_conf_well_known_uri".equals(tableName)) {
                        String old_uri = this.confWellKnownUriIdMap.remove(id);
                        if (old_uri != null) {
                            this.confWellKnownUriMap.remove(old_uri.toLowerCase());
                        } else if (operation == DAOReplicationEvent.OperationType.DELETE) {
                            this.log.warn((Object)("confWellKnownUriIdMap was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
                        }
                        if (operation != DAOReplicationEvent.OperationType.INSERT && operation != DAOReplicationEvent.OperationType.UPDATE) break block32;
                        try {
                            Object[] params = new Object[]{id};
                            String new_uri = (String)this.dataSource.executeQuery(getConfWellKnownUri, params, this.getConfWellKnownUriMapper());
                            if (new_uri == null) {
                                throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                            }
                            if (this.log.isFinerEnabled()) {
                                this.log.finer((Object)("Retrieved new conf well known uri " + new_uri));
                            }
                            this.confWellKnownUriIdMap.put(id, new_uri);
                            this.confWellKnownUriMap.put(new_uri.toLowerCase(), id);
                            break block32;
                        }
                        catch (DMException e) {
                            if (locked) {
                                this.lock.releaseWriteLock();
                                locked = false;
                            }
                            this.log.error((Object)("Error updating " + ConfFactoryDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                            this.reinit();
                            if (!this.okay()) {
                                this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                            }
                            if (locked) {
                                this.lock.releaseWriteLock();
                                locked = false;
                            }
                            return;
                        }
                    }
                    if (!"asm_conf_factory".equals(tableName)) break block32;
                    ConfFactory old_cf = this.confFactoryMap.remove(id);
                    if (old_cf != null) {
                        Long setId = old_cf.getSetId();
                        this.confFactorySetMap.get(setId).remove(old_cf.getPriorityOrder());
                        if (this.confFactorySetMap.get(setId).isEmpty()) {
                            this.confFactorySetMap.remove(setId);
                        }
                    } else if (operation == DAOReplicationEvent.OperationType.DELETE) {
                        this.handleNullOldCf(operation);
                    }
                    if (operation != DAOReplicationEvent.OperationType.INSERT && operation != DAOReplicationEvent.OperationType.UPDATE) break block32;
                    try {
                        new_cf = this.queryConfFactory(id);
                        if (new_cf != null) break block33;
                        this.handleNullQuery(operation);
                        return;
                    }
                    catch (DMException e) {
                        if (locked) {
                            this.lock.releaseWriteLock();
                            locked = false;
                        }
                        this.log.error((Object)("Error updating " + ConfFactoryDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                        this.reinit();
                        if (!this.okay()) {
                            this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                        }
                        if (locked) {
                            this.lock.releaseWriteLock();
                            locked = false;
                        }
                        return;
                    }
                }
                if (this.log.isFinerEnabled()) {
                    this.log.finer((Object)("Retrieved new ConfFactory " + new_cf));
                }
                this.confFactoryMap.put(id, new_cf);
                Long setId = new_cf.getSetId();
                Integer prio = new_cf.getPriorityOrder();
                if (!this.confFactorySetMap.containsKey(setId)) {
                    this.confFactorySetMap.put(setId, new TreeMap());
                }
                this.confFactorySetMap.get(setId).put(prio, new_cf);
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(ConfFactoryDAO.class.getSimpleName() + " update successful"));
        }
    }

    protected void handleNullOldCf(DAOReplicationEvent.OperationType operation) {
        this.log.warn((Object)("confFactoryMap was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
    }

    protected void handleNullQuery(DAOReplicationEvent.OperationType operation) throws DMException {
        throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
    }

    @Override
    public List<String> getDependentTables() {
        return this.dependentTables;
    }

    @SMConsole(description="Get all provisioned ConfWellKnownURIs by URI.")
    public Map<String, Long> getAllConfWellKnownUris() {
        this.lock.acquireReadLock();
        try {
            Map<String, Long> map = this.confWellKnownUriMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned ConfWellKnownURIs by ID.")
    public Map<Long, String> getAllConfWellKnownIds() {
        this.lock.acquireReadLock();
        try {
            Map<Long, String> map = this.confWellKnownUriIdMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Long getConfWellKnownUriId(String uri) {
        this.lock.acquireReadLock();
        try {
            Long l = this.confWellKnownUriMap.get(uri.toLowerCase());
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public String getConfWellKnownUri(Long id) {
        this.lock.acquireReadLock();
        try {
            String string = this.confWellKnownUriIdMap.get(id);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfFactory getConfFactory(Long confFactorySetId, Integer priorityOrder) {
        this.lock.acquireReadLock();
        try {
            if (confFactorySetId != null && this.confFactorySetMap.containsKey(confFactorySetId)) {
                ConfFactory confFactory = this.confFactorySetMap.get(confFactorySetId).get(priorityOrder);
                return confFactory;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    @SMConsole(description="Get ConfFactories for set ID.")
    public List<ConfFactory> getConfFactoryList(Long confFactorySetId) {
        this.lock.acquireReadLock();
        try {
            if (confFactorySetId != null && this.confFactorySetMap.containsKey(confFactorySetId)) {
                ArrayList<ConfFactory> arrayList = new ArrayList<ConfFactory>(this.confFactorySetMap.get(confFactorySetId).values());
                return arrayList;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    @SMConsole(description="Get all provisioned ConfFactories.")
    public Map<Long, ConfFactory> getAllConfFactories() {
        this.lock.acquireReadLock();
        try {
            Map<Long, ConfFactory> map = this.confFactoryMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.confFactoryMap;
    }
}

