/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.DatabaseConfig;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.DAOResult;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.objectapi.GlobalParm;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocalParamDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(LocalParamDAO.class);
    public static final String unknownName = "<Not Named>";
    private ConcurrentMap<String, String> localParamMap = new ConcurrentHashMap<String, String>();
    protected final String getAllKeyValues = "SELECT * FROM asmlocalparm";
    protected final String updateKeyValue = "UPDATE asmlocalparm SET value=? WHERE name=?";
    protected final String insertKeyValue = "INSERT INTO asmlocalparm (name, value) VALUES (?, ?)";

    protected final ResultSetMapper getAllFieldsMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>();
                while (rs.next()) {
                    map.put(rs.getString("name"), rs.getString("value"));
                }
                return map;
            }
        };
    }

    public LocalParamDAO() {
        super(true);
    }

    @Override
    public String getDBURL() {
        return DatabaseConfig.getInstance().getUrl("asmlocal");
    }

    @Override
    public Object getMainCollection() {
        return this.localParamMap;
    }

    @Override
    public void init() {
        try {
            this.localParamMap = new ConcurrentHashMap<String, String>();
            Object[] params = new Object[]{};
            Map map = (Map)this.dataSource.executeQuery("SELECT * FROM asmlocalparm", params, this.getAllFieldsMapper());
            for (Map.Entry entry : map.entrySet()) {
                this.localParamMap.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (Exception e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
        }
    }

    @Override
    public DataMgr.Status reinit() {
        this.eventQueue.clear();
        String oldValue = (String)this.localParamMap.get("MIN_SM_VERSION");
        if (oldValue == null || oldValue.length() == 0) {
            oldValue = "8000";
        }
        this.init();
        if (this.failed()) {
            return this.getStatus();
        }
        String newValue = (String)this.localParamMap.get("MIN_SM_VERSION");
        if (newValue != null && GroupCommIntf.JGroupsVersion.getVersion(oldValue) != GroupCommIntf.JGroupsVersion.getVersion(newValue)) {
            DataDistLayerFactory.getInstance().changeJgroupVersion(newValue);
        }
        return DataMgr.Status.OKAY;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("asmlocalparm");
        return tables;
    }

    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
    }

    public synchronized void setParameter(String parameterName, String parameterValue) {
        try {
            GlobalParm oldParam = new GlobalParm(parameterName, this.localParamMap.get(parameterName));
            GlobalParm newParam = new GlobalParm(parameterName, parameterValue);
            Object[] params = new Object[]{parameterValue, parameterName};
            DAOResult result = this.dataSource.executeUpdate("UPDATE asmlocalparm SET value=? WHERE name=?", params);
            if (result.empty()) {
                params = new Object[]{parameterName, parameterValue};
                this.dataSource.executeUpdate("INSERT INTO asmlocalparm (name, value) VALUES (?, ?)", params);
            }
            this.localParamMap.put(parameterName, parameterValue);
            this.updateListeners(oldParam, newParam);
            if ("MIN_SM_VERSION".equals(oldParam.getParam())) {
                this.processMinSmVersion(oldParam, newParam);
            }
        }
        catch (DMException e) {
            log.error((Object)"could not update asmlocalparm table", (Throwable)e);
        }
    }

    protected void processMinSmVersion(GlobalParm oldParam, GlobalParm newParam) {
        if (oldParam.getValue() == null && newParam.getValue() != null || !oldParam.getValue().equals(newParam.getValue())) {
            if (log.isFineEnabled()) {
                log.fine((Object)("processMinSmVersion: Old Jar=" + (Object)((Object)GroupCommIntf.JGroupsVersion.getVersion((String)oldParam.getValue())) + ", New Jar=" + (Object)((Object)GroupCommIntf.JGroupsVersion.getVersion((String)newParam.getValue()))));
            }
            if (GroupCommIntf.JGroupsVersion.getVersion((String)oldParam.getValue()) != GroupCommIntf.JGroupsVersion.getVersion((String)newParam.getValue()) && !DataDistLayerFactory.getInstance().notifyMembersForJgroupsVersion((String)newParam.getValue())) {
                log.warn((Object)("setParameter: Unable to send out message to change min_sm_version to " + oldParam.getParam() + ".  Reverting to " + oldParam.getValue()));
                this.localParamMap.put(oldParam.getParam(), (String)oldParam.getValue());
            }
        }
    }

    public void updateLocally(String parameterName, String parameterValue) {
        if (parameterName != null && parameterValue != null) {
            GlobalParm oldParam = new GlobalParm(parameterName, this.localParamMap.get(parameterName));
            GlobalParm newParam = new GlobalParm(parameterName, parameterValue);
            this.localParamMap.put(parameterName, parameterValue);
            this.updateListeners(oldParam, newParam);
        }
    }

    public String getParameter(String parameterName) {
        return (String)this.localParamMap.get(parameterName);
    }
}

