/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.SIPDomain;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SIPDomainDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(SIPDomainDAO.class);
    private Map<Long, SIPDomain> idToDomainMap = new HashMap<Long, SIPDomain>();
    private Map<Long, SIPDomain> idToCanonicalMap = new HashMap<Long, SIPDomain>();
    private Map<String, Long> canonicalToIdMap = new HashMap<String, Long>();
    protected static final String getSIPDomains = "SELECT id, name FROM sipdomain";
    protected static final String getSIPDomain = "SELECT name FROM sipdomain WHERE id = ?";
    private static final ResultSetMapper domainsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList list = new ArrayList();
            HashMap<Long, SIPDomain> idToDomainMap = new HashMap<Long, SIPDomain>();
            HashMap<Long, SIPDomain> idToCanonicalMap = new HashMap<Long, SIPDomain>();
            HashMap<String, Long> canonicalToIdMap = new HashMap<String, Long>();
            while (rs.next()) {
                long id = rs.getLong("id");
                String name = rs.getString("name");
                String lcname = name.toLowerCase();
                idToDomainMap.put(id, new SIPDomain(name));
                idToCanonicalMap.put(id, new SIPDomain(lcname));
                canonicalToIdMap.put(lcname, id);
            }
            list.add(idToDomainMap);
            list.add(idToCanonicalMap);
            list.add(canonicalToIdMap);
            return list;
        }
    };
    private static final ResultSetMapper domainMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return new SIPDomain(rs.getString("name"));
            }
            return null;
        }
    };

    public SIPDomainDAO() {
        super(true);
    }

    public ResultSetMapper getDomainsMapper() {
        return domainsMapper;
    }

    public ResultSetMapper getDomainMapper() {
        return domainMapper;
    }

    @Override
    protected Object getMainCollection() {
        return this.idToCanonicalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap canonicalToIdMapTMP;
        HashMap idToCanonicalMapTMP;
        HashMap idToDomainMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + SIPDomainDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            List list = (List)this.dataSource.executeQuery(getSIPDomains, params, this.getDomainsMapper());
            idToDomainMapTMP = (HashMap)list.get(0);
            idToCanonicalMapTMP = (HashMap)list.get(1);
            canonicalToIdMapTMP = (HashMap)list.get(2);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.idToDomainMap = idToDomainMapTMP;
                this.idToCanonicalMap = idToCanonicalMapTMP;
                this.canonicalToIdMap = canonicalToIdMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("sipdomain");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        SIPDomain newDomain = null;
        SIPDomain oldDomain = null;
        boolean lockHeld = false;
        try {
            Object[] params;
            if (operation != DAOReplicationEvent.OperationType.DELETE && (newDomain = (SIPDomain)this.dataSource.executeQuery(getSIPDomain, params = new Object[]{id}, this.getDomainMapper())) != null && log.isFinerEnabled()) {
                log.finer((Object)("Retrieved new Domain " + newDomain.getDomain()));
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldDomain = this.idToCanonicalMap.remove(id);
            if (oldDomain != null) {
                this.canonicalToIdMap.remove(oldDomain.getDomain());
                this.idToDomainMap.remove(id);
            }
            if (newDomain != null) {
                this.idToDomainMap.put(id, newDomain);
                String lcname = newDomain.getDomain().toLowerCase();
                this.idToCanonicalMap.put(id, new SIPDomain(lcname));
                this.canonicalToIdMap.put(lcname, id);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (oldDomain != null || newDomain != null) {
            this.updateListeners(oldDomain, newDomain);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(SIPDomainDAO.class.getSimpleName() + " update successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCanonicalSIPDomain(Long id) {
        try {
            this.lock.acquireReadLock();
            SIPDomain domain = this.idToCanonicalMap.get(id);
            if (domain != null) {
                String string = domain.getDomain();
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActualSIPDomain(Long id) {
        try {
            this.lock.acquireReadLock();
            SIPDomain domain = this.idToDomainMap.get(id);
            if (domain != null) {
                String string = domain.getDomain();
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    public Long getSIPDomainId(String domain) {
        if (domain != null) {
            try {
                this.lock.acquireReadLock();
                Long l = this.canonicalToIdMap.get(domain.toLowerCase());
                return l;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getListSIPDomains() {
        ArrayList<String> retList = new ArrayList<String>();
        try {
            this.lock.acquireReadLock();
            for (SIPDomain domain : this.idToCanonicalMap.values()) {
                retList.add(domain.getDomain());
            }
            ArrayList<String> arrayList = retList;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned SIP Domains.")
    public Map<Long, SIPDomain> getAllSIPDomains() {
        try {
            this.lock.acquireReadLock();
            Map<Long, SIPDomain> map = Collections.unmodifiableMap(this.idToCanonicalMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

