/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.OldNewDataDiffs;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.helpers.FlexCache;
import com.avaya.asm.datamgr.loadrulekeys.CacheSize;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.SetCommunity;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacheSize.class})
public class SetCommunityDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(SetCommunityDAO.class);
    protected boolean dynFields = false;
    private int capacity = 1;
    protected FlexCache<Long, Long> setCommunityMap = new FlexCache();
    public static final String getSetCommunities = "SELECT set.id, asm.usercommunity_id, dasm.dyn_usercommunity_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN dyn_asmcommprofile dasm ON dasm.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid WHERE set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ")";
    public static final String getLocalSetCommunities = getSetCommunities + " AND dasm.is_local=true";
    public static final String setIdStatement = getSetCommunities + " AND set.id = ?";
    public static final String csIdStatement = getSetCommunities + " AND cs.id = ?";
    public static final String asmIdStatement = getSetCommunities + " AND asm.id = ?";
    public static final String getSetIdByUserId = "SELECT set.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.id = ?";
    public static final String getSetIdByAsmId = "SELECT cscommprofilesetid FROM cscommprofile WHERE id = ?";
    protected final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getLong(SetCommunityDAO.this.dynFields ? "dyn_usercommunity_id" : "usercommunity_id"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper userMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getLong("id");
            }
            return null;
        }
    };
    protected static final ResultSetMapper asmMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getLong("cscommprofilesetid");
            }
            return null;
        }
    };

    public SetCommunityDAO() {
        super(true);
    }

    protected void setCapacity(int capacity) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.capacity = capacity;
    }

    protected int getCapacity() {
        return this.capacity;
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        int bestCacheValue = 1;
        boolean bestDynFieldsValue = false;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cachesize".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    int cap = Integer.parseInt(value);
                    if (cap <= 0) {
                        bestCacheValue = -1;
                        continue block0;
                    }
                    if (bestCacheValue == -1 || cap <= bestCacheValue) continue;
                    bestCacheValue = cap;
                }
                continue;
            }
            if ("dynfields".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    if (!Boolean.parseBoolean(value)) continue;
                    bestDynFieldsValue = true;
                    continue block0;
                }
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.capacity) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting FlexCache capacity to " + bestCacheValue));
            }
            this.capacity = bestCacheValue;
            reinit = true;
        }
        if (bestDynFieldsValue != this.dynFields) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting dynamic fields to " + bestDynFieldsValue));
            }
            this.dynFields = bestDynFieldsValue;
            reinit = true;
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        FlexCache setCommunityMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        try {
            Object[] params = new Object[]{};
            HashMap setCommunityMapQueryResults = (HashMap)this.dataSource.executeQuery(this.getCapacity() >= 0 ? getLocalSetCommunities : getSetCommunities, params, this.mapper);
            setCommunityMapTMP = new FlexCache(this.getCapacity(), setCommunityMapQueryResults, true);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.setCommunityMap = setCommunityMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if ("cshandle".equals(tableName)) {
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        Object[] params = new Object[]{id};
        boolean lockHeld = false;
        SetCommunity oldSetCommunity = null;
        SetCommunity newSetCommunity = null;
        try {
            if ("csuser".equals(tableName)) {
                Long setId = (Long)this.dataSource.executeQuery(getSetIdByUserId, params, userMapper);
                if (setId != null) {
                    if (this.getCapacity() >= 0) {
                        this.lock.acquireWriteLock();
                        lockHeld = true;
                        this.setCommunityMap.remove(setId);
                    } else {
                        params = new Object[]{setId};
                        Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, this.mapper);
                        this.lock.acquireWriteLock();
                        lockHeld = true;
                        if (map.isEmpty()) {
                            Long userCommunityId = this.setCommunityMap.remove(setId);
                            if (userCommunityId != null) {
                                oldSetCommunity = new SetCommunity(setId, userCommunityId);
                            }
                            if (this.log.isFinestEnabled()) {
                                this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + setId + " no longer maps to a Community"));
                            }
                        } else {
                            for (Map.Entry entry : map.entrySet()) {
                                this.setCommunityMap.put((Long)entry.getKey(), (Long)entry.getValue());
                                newSetCommunity = new SetCommunity((Long)entry.getKey(), (Long)entry.getValue());
                                if (!this.log.isFinestEnabled()) continue;
                                this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Community " + entry.getValue()));
                            }
                        }
                    }
                }
            } else if ("cscommprofileset".equals(tableName)) {
                if (operation == DAOReplicationEvent.OperationType.DELETE && this.setCommunityMap.containsKey(id)) {
                    oldSetCommunity = new SetCommunity(id, this.setCommunityMap.get(id));
                }
                if (this.getCapacity() >= 0) {
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    this.setCommunityMap.remove(id);
                } else {
                    Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, this.mapper);
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    if (map.isEmpty()) {
                        this.setCommunityMap.remove(id);
                        if (this.log.isFinestEnabled()) {
                            this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + id + " no longer maps to a Community"));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            this.setCommunityMap.put((Long)entry.getKey(), (Long)entry.getValue());
                            if (!this.log.isFinestEnabled()) continue;
                            this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Community " + entry.getValue()));
                        }
                    }
                }
            } else if ("cscommprofile".equals(tableName)) {
                if (this.getCapacity() < 0) {
                    Map map = (Map)this.dataSource.executeQuery(csIdStatement, params, this.mapper);
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    for (Map.Entry entry : map.entrySet()) {
                        if (this.getCapacity() >= 0 && !this.setCommunityMap.containsKey(entry.getKey())) continue;
                        this.setCommunityMap.put((Long)entry.getKey(), (Long)entry.getValue());
                        if (!this.log.isFinestEnabled()) continue;
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Community " + entry.getValue()));
                    }
                }
            } else if ("dyn_asmcommprofile".equals(tableName) || "asmcommprofile".equals(tableName)) {
                Long userCommId;
                Long setId;
                Map map = (Map)this.dataSource.executeQuery(asmIdStatement, params, this.mapper);
                if (map.isEmpty() && operation == DAOReplicationEvent.OperationType.DELETE && (setId = (Long)this.dataSource.executeQuery(getSetIdByAsmId, params, asmMapper)) != null && (userCommId = this.setCommunityMap.remove(setId)) != null) {
                    oldSetCommunity = new SetCommunity(setId, userCommId);
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + setId + " no longer maps to a Community"));
                    }
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.getCapacity() >= 0 && !this.setCommunityMap.containsKey(entry.getKey())) continue;
                    if (this.setCommunityMap.containsKey(entry.getKey())) {
                        oldSetCommunity = new SetCommunity((Long)entry.getKey(), this.setCommunityMap.get(entry.getKey()));
                    }
                    this.setCommunityMap.put((Long)entry.getKey(), (Long)entry.getValue());
                    newSetCommunity = new SetCommunity((Long)entry.getKey(), (Long)entry.getValue());
                    if (!this.log.isFinestEnabled()) continue;
                    this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Community " + entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (!(oldSetCommunity == null && newSetCommunity == null || oldSetCommunity != null && newSetCommunity != null && newSetCommunity.equals(oldSetCommunity))) {
            this.updateListeners(oldSetCommunity, newSetCommunity);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    protected List<OldNewDataDiffs> compareOldNewData(Object oldData, Object newData) {
        ArrayList<OldNewDataDiffs> diffList = new ArrayList<OldNewDataDiffs>();
        if (oldData == null) {
            return diffList;
        }
        long preProcess = System.currentTimeMillis();
        Map oldMap = (Map)oldData;
        Map newMap = (Map)newData;
        for (Map.Entry e : oldMap.entrySet()) {
            Long newValue = (Long)newMap.get(e.getKey());
            if (newValue == null) {
                diffList.add(new OldNewDataDiffs(new SetCommunity((Long)e.getKey(), (Long)e.getValue()), null));
                continue;
            }
            if (newValue.equals(e.getValue())) continue;
            diffList.add(new OldNewDataDiffs(new SetCommunity((Long)e.getKey(), (Long)e.getValue()), new SetCommunity((Long)e.getKey(), newValue)));
        }
        for (Map.Entry e : newMap.entrySet()) {
            Long oldValue = (Long)oldMap.get(e.getKey());
            if (oldValue != null) continue;
            diffList.add(new OldNewDataDiffs(new SetCommunity((Long)e.getKey(), oldValue), new SetCommunity((Long)e.getKey(), (Long)e.getValue())));
        }
        long postProcess = System.currentTimeMillis();
        if (diffList.size() > 0 && this.log.isFinerEnabled()) {
            this.log.finer((Object)(this.getClass().getSimpleName() + ": compareOldNewData: Found " + diffList.size() + " diffs that will implicitly be updated for their listeners; Took " + (postProcess - preProcess) / 1000L + " seconds to generate diff list."));
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)(this.getClass().getSimpleName() + ": compareOldNewData: They are: " + diffList));
            }
        }
        return diffList;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        list.add("cscommprofileset");
        list.add("cscommprofile");
        list.add(this.dynFields ? "dyn_asmcommprofile" : "asmcommprofile");
        list.add("cshandle");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return this.setCommunityMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getUserCommunityId(Long setId) {
        if (setId == null) {
            return null;
        }
        Long userCommId = null;
        try {
            this.lock.acquireReadLock();
            userCommId = this.setCommunityMap.get(setId);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (userCommId != null || this.getCapacity() < 0) {
            return userCommId;
        }
        try {
            Object[] params = new Object[]{setId};
            Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, this.mapper);
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("Read object(s) into FlexCache: " + map));
            }
            if (map != null) {
                userCommId = (Long)map.get(setId);
            }
        }
        catch (DMException e) {
            this.log.error((Object)("Error reading Database for " + setId), (Throwable)e);
        }
        if (userCommId != null) {
            try {
                this.lock.acquireWriteLock();
                this.setCommunityMap.put(setId, userCommId);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return userCommId;
    }

    @SMConsole(description="Print a map of CommProfileSet IDs to UserCommunity IDs.")
    public Map<Long, Long> getSetCommunityMappings() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Long> map = this.setCommunityMap.getCopyOfInternalMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

