/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.datamgr.BSMNoAvayaLspAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.BSMNoAvayaLspAlarmException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.branch.BranchFeatureServerDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.ListenPort;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.SipMonResponseHandling;
import com.avaya.common.logging.client.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BranchSIPEntityDAO
extends SIPEntityDAO {
    private static final Logger log = AsmLogger.getLogger(BranchSIPEntityDAO.class);
    protected static final String getLinkEntities = "SELECT entity2_id FROM entitylink WHERE entity1_id = ? UNION SELECT entity1_id FROM entitylink WHERE entity2_id = ?";
    protected static final String getCoreSMs = "SELECT sipentity_id FROM asminstance WHERE sm_type = 'SM'";
    protected Long trunkGatewayId = null;
    protected static final ResultSetMapper linkEntitiesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashSet<Long> entities = new HashSet<Long>();
            while (rs.next()) {
                entities.add(rs.getLong("entity2_id"));
            }
            return entities;
        }
    };
    protected static final ResultSetMapper coreSMMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashSet<Long> entities = new HashSet<Long>();
            while (rs.next()) {
                entities.add(rs.getLong("sipentity_id"));
            }
            return entities;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + BranchSIPEntityDAO.class.getSimpleName()));
        }
        HashMap<Long, SIPEntity> entityMapTMP = new HashMap<Long, SIPEntity>();
        HashMap<FQDNOrIpAddr, Map<Long, SIPEntity>> entityAddressMapTMP = new HashMap<FQDNOrIpAddr, Map<Long, SIPEntity>>();
        HashMap<Long, ListenPort> portIdMapTMP = new HashMap<Long, ListenPort>();
        HashMap<Long, SipMonResponseHandling> responseHandlingMapTMP = new HashMap<Long, SipMonResponseHandling>();
        Long trunkGatewayIdTMP = null;
        try {
            String lspAddress;
            Long mySIPEntityId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMySIPEntityId();
            if (mySIPEntityId == null) {
                if (log.isFinerEnabled()) {
                    log.fine((Object)"Don't know my SIP entity ID - giving up");
                }
                this.setStatus(DataMgr.Status.OKAY);
                return;
            }
            SIPEntity myEntity = this.makeSIPEntity(mySIPEntityId, entityMapTMP, entityAddressMapTMP, portIdMapTMP, responseHandlingMapTMP);
            if (log.isFineEnabled()) {
                log.fine((Object)("added my entity: " + myEntity));
            }
            if ((lspAddress = this.getLSPAddress()) == null) {
                BSMNoAvayaLspAlarmException e = new BSMNoAvayaLspAlarmException("No address for the LSP found in /etc/hosts");
                GenericAlarmHandler.handleFailureEvent(this, e);
            }
            Long myFeatureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId();
            List<Long> myOtherFeatureServerIds = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getOtherFeatureServerIds();
            if (log.isFineEnabled()) {
                log.fine((Object)("feature server = " + myFeatureServerId + ", other feature servers = " + myOtherFeatureServerIds));
            }
            Long branchAdaptationId = null;
            AsmInstance myInstance = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyAsmInstance();
            if (myInstance != null) {
                branchAdaptationId = myInstance.getBranchAdaptationId();
            }
            Object[] params = new Object[]{mySIPEntityId, mySIPEntityId};
            Set entities = (Set)this.dataSource.executeQuery(getLinkEntities, params, linkEntitiesMapper);
            if (log.isFineEnabled()) {
                log.fine((Object)("links exist to entities: " + entities));
            }
            Set coreSMs = (Set)this.dataSource.executeQuery(getCoreSMs, new Object[0], coreSMMapper);
            if (log.isFineEnabled()) {
                log.fine((Object)("core SM entities: " + coreSMs));
            }
            entities.addAll(coreSMs);
            for (Long entityId : entities) {
                SIPEntity entity;
                if (entityId.equals(myFeatureServerId) || myOtherFeatureServerIds.contains(entityId) || this.ignoreSIPEntity(entity = this.querySIPEntity(entityId))) continue;
                if (trunkGatewayIdTMP == null && entity != null && entity.getIsCM() && lspAddress != null) {
                    entity.setFqdnoripaddr(lspAddress);
                    if (branchAdaptationId != null) {
                        entity.setAdaptation_id(branchAdaptationId);
                    }
                    trunkGatewayIdTMP = entity.getId();
                    if (log.isFineEnabled()) {
                        log.fine((Object)("added LSP GW entity: " + entity));
                    }
                } else if (log.isFineEnabled()) {
                    log.fine((Object)("added entity: " + entity));
                }
                params = new Object[]{entityId};
                Map handlings = (Map)this.dataSource.executeQuery("SELECT id, type, response, sipentity_id FROM sipmonresponsehandling WHERE sipentity_id = ?", params, sipMonResponseHandlingMapper);
                this.addEntityToMaps(entity, null, handlings, entityMapTMP, entityAddressMapTMP, portIdMapTMP, responseHandlingMapTMP);
            }
            if (lspAddress != null && myFeatureServerId != null) {
                SIPEntity fsEntity = this.querySIPEntity(myFeatureServerId);
                Long fsAdaptationId = trunkGatewayIdTMP == null && branchAdaptationId != null ? branchAdaptationId : fsEntity.getAdaptation_id();
                if (trunkGatewayIdTMP == null) {
                    myEntity.setOutboundproxy_id(myFeatureServerId);
                } else {
                    myEntity.setOutboundproxy_id(trunkGatewayIdTMP);
                }
                SIPEntity.IPAddrFamilyType ipAddressFamilyforLsp = this.getLSPAddressFamily();
                SIPEntity entity = new SIPEntity(myFeatureServerId, "CM", ipAddressFamilyforLsp.toString(), lspAddress, null, null, "avaya-lsp-fs", false, fsAdaptationId, null, null, fsEntity.getTimer_bf_secs(), true, 1, 1, 10, SIPEntity.CDRSetting.none, false, null, null, null, null, null, null, fsEntity.getPreferredHandleType(), fsEntity.isSecurable(), false);
                params = new Object[]{myFeatureServerId};
                Map handlings = (Map)this.dataSource.executeQuery("SELECT id, type, response, sipentity_id FROM sipmonresponsehandling WHERE sipentity_id = ?", params, sipMonResponseHandlingMapper);
                this.addEntityToMaps(entity, null, handlings, entityMapTMP, entityAddressMapTMP, portIdMapTMP, responseHandlingMapTMP);
                if (log.isFineEnabled()) {
                    log.fine((Object)("added LSP FS entity: " + entity));
                }
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        finally {
            if (this.uninitialized()) {
                this.setStatus(DataMgr.Status.FAIL);
            }
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.entityMap = entityMapTMP;
                this.entityAddressMap = entityAddressMapTMP;
                this.portIdMap = portIdMapTMP;
                this.responseHandlingMap = responseHandlingMapTMP;
                this.trunkGatewayId = trunkGatewayIdTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        if (log.isFinerEnabled()) {
            log.fine((Object)"updateDAO: reinitialize");
        }
        this.reinit();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinerEnabled()) {
            log.fine((Object)("objectChanged(" + oldObject + ", " + newObject + ")"));
        }
        this.reinit();
    }

    @Override
    public List<String> getDependentTables() {
        List<String> list = super.getDependentTables();
        list.add("entitylink");
        list.add("asminstance");
        return list;
    }

    private SIPEntity querySIPEntity(Long entityId) throws DMException {
        Object[] params = new Object[]{entityId};
        HashMap dbEntityMap = (HashMap)this.dataSource.executeQuery("SELECT id, entitytype, ipaddr_family_type, fqdnoripaddr, fqdnoripaddr2, sip_fqdn, name, userfc3263, adaptation_id, outboundproxy_id, routingorigination_id, timer_bf_secs, do_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, monitor_okresponses, cdrsetting, cac_capable, bandwidth_sharing_sm1_id, bandwidth_sharing_sm2_id, tcp_failover_port, tls_failover_port, tcp_failover_port_v6, tls_failover_port_v6, commprofile_type_for_preferredhandle, securable, ipaddr_tolerant, routing_siploadbalancer_id FROM sipentity WHERE id = ?", params, entityMapper);
        SIPEntity entity = (SIPEntity)dbEntityMap.get(entityId);
        if (entity == null) {
            throw new DMException("Couldn't read SIPEntity with ID " + entityId);
        }
        return entity;
    }

    private SIPEntity makeSIPEntity(Long entityId, Map<Long, SIPEntity> entityMap, Map<FQDNOrIpAddr, Map<Long, SIPEntity>> addressMap, Map<Long, ListenPort> portIdMap, Map<Long, SipMonResponseHandling> responseHandlingMap) throws DMException {
        SIPEntity entity = this.querySIPEntity(entityId);
        Object[] params = new Object[]{entityId};
        Map listenPorts = (Map)this.dataSource.executeQuery("SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport WHERE sipentity_id=?", params, listenPortMapper);
        Map handlings = (Map)this.dataSource.executeQuery("SELECT id, type, response, sipentity_id FROM sipmonresponsehandling WHERE sipentity_id = ?", params, sipMonResponseHandlingMapper);
        this.addEntityToMaps(entity, listenPorts, handlings, entityMap, addressMap, portIdMap, responseHandlingMap);
        return entity;
    }

    private void addEntityToMaps(SIPEntity entity, Map<Long, ListenPort> listenPorts, Map<Long, SipMonResponseHandling> handlings, Map<Long, SIPEntity> entityMap, Map<FQDNOrIpAddr, Map<Long, SIPEntity>> addressMap, Map<Long, ListenPort> portIdMap, Map<Long, SipMonResponseHandling> responseHandlingMap) throws DMException {
        FQDNOrIpAddr sipFqdn;
        long seId = entity.getId();
        entityMap.put(seId, entity);
        FQDNOrIpAddr fqdnOrIpAddr = entity.getFQDNOrIpAddr();
        Map<Long, SIPEntity> map = addressMap.get(fqdnOrIpAddr);
        if (map == null) {
            map = new HashMap<Long, SIPEntity>();
            addressMap.put(fqdnOrIpAddr, map);
        }
        map.put(seId, entity);
        FQDNOrIpAddr fqdnOrIpAddr2 = entity.getFQDNOrIpAddr2();
        if (!fqdnOrIpAddr2.isNull()) {
            map = addressMap.get(fqdnOrIpAddr2);
            if (map == null) {
                map = new HashMap<Long, SIPEntity>();
                addressMap.put(fqdnOrIpAddr2, map);
            }
            map.put(seId, entity);
        }
        if (!(sipFqdn = entity.getSIPFQDN()).isNull()) {
            map = addressMap.get(sipFqdn);
            if (map == null) {
                map = new HashMap<Long, SIPEntity>();
                addressMap.put(sipFqdn, map);
            }
            map.put(seId, entity);
        }
        if (listenPorts != null) {
            for (ListenPort listenPort : listenPorts.values()) {
                entity.addListenPort(listenPort);
                portIdMap.put(listenPort.getId(), listenPort);
            }
        } else {
            Map ports = (Map)this.dataSource.executeQuery("SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport WHERE sipentity_id=?", new Object[]{entity.getId()}, listenPortMapper);
            for (ListenPort port : ports.values()) {
                entity.addListenPort(port);
                portIdMap.put(port.getId(), port);
            }
        }
        if (handlings != null) {
            for (SipMonResponseHandling sipMonResponseHandling : handlings.values()) {
                entity.addResponseHandling(sipMonResponseHandling);
                responseHandlingMap.put(sipMonResponseHandling.getId(), sipMonResponseHandling);
            }
        }
    }

    @Override
    protected boolean isCorrected(GenericAlarm alarm) {
        if (alarm instanceof BSMNoAvayaLspAlarm) {
            if (log.isFinerEnabled()) {
                log.finer((Object)("isCorrected(" + alarm + ")"));
            }
            if (this.getLSPAddress() != null) {
                if (log.isFineEnabled()) {
                    log.fine((Object)"get LSP address from /etc/host alarm cleared, reinitialize the DAO");
                }
                this.reinit();
                return true;
            }
            return false;
        }
        return super.isCorrected(alarm);
    }

    @SMConsole(description="Get entity ID of the trunk gateway.")
    public Long getTrunkGatewayId() {
        return this.trunkGatewayId;
    }

    @SMConsole(description="Get IP address of the LSP.")
    public String getLSPAddress() {
        try {
            return InetAddress.getByName("avaya-lsp").getHostAddress();
        }
        catch (UnknownHostException e) {
            if (log.isFineEnabled()) {
                log.fine((Object)"Don't know the LSP address");
            }
            return null;
        }
    }

    public SIPEntity.IPAddrFamilyType getLSPAddressFamily() {
        String lspIPaddress = this.getLSPAddress();
        if (lspIPaddress != null) {
            return IPAddress.isIPv6Address(lspIPaddress) ? SIPEntity.IPAddrFamilyType.IPv6 : SIPEntity.IPAddrFamilyType.IPv4;
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("getLSPAddress() is :" + lspIPaddress));
        }
        return SIPEntity.IPAddrFamilyType.IPv4;
    }

    @Override
    public List<ListenPort> getListenPorts(Long sipEntityId) {
        String fcn_name = "getListenPorts";
        List<ListenPort> listenPorts = super.getListenPorts(sipEntityId);
        if (listenPorts != null) {
            return listenPorts;
        }
        HashMap ports = null;
        try {
            ports = (HashMap)this.dataSource.executeQuery("SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport WHERE sipentity_id=?", new Object[]{sipEntityId}, listenPortMapper);
        }
        catch (DMException e) {
            log.error((Object)(fcn_name + ": DMException while executing query=" + "SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport WHERE sipentity_id=?"));
        }
        if (ports == null) {
            ports = new HashMap();
        }
        return new ArrayList<ListenPort>(ports.values());
    }
}

