/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CallHistoryPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.datastax.driver.core.PreparedStatement;

public class CallHistoryPreparedStatements
extends PreparedStatements<CallHistoryPreparedStatementType> {
    private static final String CALLLOG_CF = "__KEYSPACE__.calllog";
    private static final String CALLLOGIDS_CF = "__KEYSPACE__.calllogids";
    private static final String ADD_CALLHISTORY_QRY = "INSERT INTO __KEYSPACE__.calllog";
    private static final String UPD_CALLLOGIDS_QRY = "UPDATE __KEYSPACE__.calllogids SET ids=ids";
    private static final String GET_CALLHISTORY_FIELDS = "id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,avext";
    private static final String GET_CALLHISTORY_QRY = "SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,avext FROM __KEYSPACE__.calllog";
    private static final String GET_CALLHISTORY_QRY_WITH_GLOBALMIGRATED = "SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,avext, is_global_migrated FROM __KEYSPACE__.calllog";
    private static final String GET_CALLLOGIDS_QRY = "SELECT ids FROM __KEYSPACE__.calllogids";
    private static final String DELETE_CALLLOG_QRY = "DELETE FROM __KEYSPACE__.calllog";
    private static final String DELETE_CALLLOGIDS_QRY = "DELETE FROM __KEYSPACE__.calllogids";
    private static final String SELECT_COMMPROF_SETIDS = "SELECT DISTINCT set_id from __KEYSPACE__.calllogids";
    private static final String SELECT_COUNT_CALLLOGIDS = "SELECT count(*) FROM calllogids";
    private static final String USING_NO_TTL = "using TTL 0";
    private static final String LIMIT = " LIMIT ";
    private static final int CHUNK_SIZE = 500;

    public CallHistoryPreparedStatements(SessionDAO dao) {
        super(CallHistoryPreparedStatementType.class, dao);
    }

    @Override
    public PreparedStatement prepareStatement(CallHistoryPreparedStatementType queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        StringBuilder query = new StringBuilder();
        switch (queryType) {
            case ADD_CALLLOG: {
                query.append(ADD_CALLHISTORY_QRY);
                query.append(" (set_id,id,duration,bridged,privacy,datetime,dialog_id,local_number,number,name,type,avext)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                break;
            }
            case ADD_CALLLOGIDS: {
                query.append(UPD_CALLLOGIDS_QRY);
                query.append("+? WHERE set_id=?");
                break;
            }
            case DELETE_CALLLOGIDS_SETID: {
                query.append(DELETE_CALLLOGIDS_QRY);
                query.append(" WHERE set_id=?");
                break;
            }
            case DELETE_CALLLOGIDS_SETID_ID: {
                query.append(UPD_CALLLOGIDS_QRY);
                query.append("-? WHERE set_id=?");
                break;
            }
            case DELETE_CALLLOG_SETID_AND_ID_GREATER_THAN: {
                query.append(DELETE_CALLLOG_QRY);
                query.append(" WHERE set_id=? AND id > ?");
                break;
            }
            case DELETE_CALLLOG_SETID_AND_ID_EQUALS: {
                query.append(DELETE_CALLLOG_QRY);
                query.append(" WHERE set_id=? AND id=?");
                break;
            }
            case DELETE_ALL_CALLLOG_SETID: {
                query.append(DELETE_CALLLOG_QRY);
                query.append(" WHERE set_id=?");
                break;
            }
            case GET_CALLLOG: {
                query.append(GET_CALLHISTORY_QRY);
                query.append(" WHERE set_id=?");
                break;
            }
            case GET_CALLLOGIDS: {
                query.append(GET_CALLLOGIDS_QRY);
                query.append(" WHERE set_id=?");
                break;
            }
            case GET_CALLLOG_LIMIT: {
                query.append(GET_CALLHISTORY_QRY);
                query.append(" WHERE set_id=? LIMIT ?");
                break;
            }
            case GET_SETID_CALLLOGIDS: {
                query.append("SELECT DISTINCT set_id from __KEYSPACE__.calllogids LIMIT 500");
                break;
            }
            case GET_SETID_CALLLOGIDS_TOKEN: {
                query.append(SELECT_COMMPROF_SETIDS);
                query.append(" WHERE token(set_id) > token(?) LIMIT 500");
                break;
            }
            case GET_USERID_COUNT_CALLLOGIDS: {
                query.append(SELECT_COUNT_CALLLOGIDS);
                query.append(" WHERE set_id = ? ALLOW FILTERING");
                break;
            }
            case GET_MIGRATION_CALLLOG: {
                query.append(GET_CALLHISTORY_QRY_WITH_GLOBALMIGRATED);
                query.append(" WHERE set_id=? AND id = ?");
                break;
            }
            case SET_MIGRATION_CALLLOG: {
                query.append(ADD_CALLHISTORY_QRY);
                query.append(" (set_id,id,datetime,is_global_migrated)");
                query.append(" VALUES(?, ?, ?, ?)");
                query.append(USING_NO_TTL);
                break;
            }
            case CLEAR_MIGRATION_CALLLOG: {
                query.append(DELETE_CALLLOG_QRY);
                query.append(" WHERE set_id=? AND id=?");
                break;
            }
            case GET_CALLLOG_WITH_GLOBALMIGRATED: {
                query.append(GET_CALLHISTORY_QRY_WITH_GLOBALMIGRATED);
                query.append(" WHERE set_id=?");
                break;
            }
            case GET_CALLLOG_LIMIT_WITH_GLOBALMIGRATED: {
                query.append(GET_CALLHISTORY_QRY_WITH_GLOBALMIGRATED);
                query.append(" WHERE set_id=? LIMIT ?");
            }
        }
        return this.prepareQuery(query.toString(), keyspaceBuilder);
    }
}

