/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.dao.cassandra.DatastaxDriverIntfc;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraSSLOptions;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SSLOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.net.ssl.SSLContext;

public class DatastaxDriverImpl
implements DatastaxDriverIntfc {
    private final Logger log = AsmLogger.getLogger(this.getClass());
    private Method queryLoggerBuilder_Cluster_M = null;
    private Method queryLoggerBuilder_M = null;
    private Constructor<?> sslOptions_C = null;
    private Method rEAJSslOptions_builder_M = null;
    private Method rEAJSslOptionsBuild_build_M = null;
    private Method rEAJSslOptions_builder_withSSLContext_M = null;
    private Method rEAJSslOptions_builder_withCipherSuites_M = null;
    private Method row_getDate_String_M = null;
    private Method row_getDate_int_M = null;
    private Method boundStatement_setDate_String_Date_M = null;
    private Method boundStatement_setDate_int_Date_M = null;
    private Class<?> transportationException_C = null;
    private String driverVersion = Cluster.getDriverVersion();

    public DatastaxDriverImpl() {
        this.init();
    }

    private void init() {
        String fcn_name = "init";
        this.log.info((Object)("init: Datastax driver version is " + this.driverVersion + ", represented internally as " + this.driverVersion));
        this.lookupQueryLoggerBuilderMethods();
        this.lookupSSLOptionsBuilderMethods();
        this.lookupDateMethods();
        this.lookupExceptions();
    }

    private void lookupQueryLoggerBuilderMethods() {
        String fcn_name = "lookupQueryLoggerBuilderMethods";
        boolean isFinest = this.log.isFinerEnabled();
        Class<QueryLogger> queryLoggerCls = QueryLogger.class;
        try {
            this.queryLoggerBuilder_Cluster_M = queryLoggerCls.getMethod("builder", Cluster.class);
        }
        catch (NoSuchMethodException e) {
            if (isFinest) {
                this.log.finest((Object)"lookupQueryLoggerBuilderMethods: method QueryLogger.builder(Cluster) is not defined");
            }
        }
        catch (SecurityException e) {
            this.log.error((Object)("lookupQueryLoggerBuilderMethods: getMethod(builder) threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
        }
        try {
            this.queryLoggerBuilder_M = queryLoggerCls.getMethod("builder", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (isFinest) {
                this.log.finest((Object)"lookupQueryLoggerBuilderMethods: method QueryLogger.builder() is not defined");
            }
        }
        catch (SecurityException e) {
            this.log.error((Object)("lookupQueryLoggerBuilderMethods: getMethod(builder) threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
        }
        if (this.queryLoggerBuilder_Cluster_M == null && this.queryLoggerBuilder_M == null) {
            this.log.error((Object)"lookupQueryLoggerBuilderMethods: Could not find any QueryLogger.build() method");
        }
    }

    private void lookupSSLOptionsBuilderMethods() {
        Class<?> cls;
        String className;
        block23: {
            boolean isFinest;
            block22: {
                isFinest = this.log.isFinestEnabled();
                String fcn_name = "lookupSSLOptionsBuilderMethods";
                className = "com.datastax.driver.core.SSLOptions";
                cls = null;
                try {
                    cls = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    if (!isFinest) break block22;
                    this.log.finest((Object)("lookupSSLOptionsBuilderMethods: getting class forName " + className + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                }
            }
            if (cls != null) {
                try {
                    this.sslOptions_C = cls.getConstructor(SSLContext.class, String[].class);
                }
                catch (NoSuchMethodException e) {
                    if (isFinest) {
                        this.log.finest((Object)"lookupSSLOptionsBuilderMethods: constructor SSLOptions(SSLContext, String[] ciphers) does not exist");
                    }
                }
                catch (SecurityException e) {
                    this.log.error((Object)("lookupSSLOptionsBuilderMethods: getConstructor() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                }
            }
            className = "com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions";
            cls = null;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (!isFinest) break block23;
                this.log.finest((Object)("lookupSSLOptionsBuilderMethods: getting class forName " + className + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
        }
        if (cls != null) {
            try {
                this.rEAJSslOptions_builder_M = cls.getMethod("builder", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                this.log.error((Object)("lookupSSLOptionsBuilderMethods: getting method builder() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
            className = className + "$Builder";
            cls = null;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("lookupSSLOptionsBuilderMethods: getting class forName " + className + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
            if (cls != null) {
                try {
                    this.rEAJSslOptionsBuild_build_M = cls.getMethod("build", new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    this.log.error((Object)("lookupSSLOptionsBuilderMethods: retrieving method RemoteEndpointAwareJdkSSLOptions$Builder.build() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                }
                try {
                    this.rEAJSslOptions_builder_withSSLContext_M = cls.getMethod("withSSLContext", SSLContext.class);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    this.log.error((Object)("lookupSSLOptionsBuilderMethods: retrieving method withSSLContext() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                }
                try {
                    this.rEAJSslOptions_builder_withCipherSuites_M = cls.getMethod("withCipherSuites", String[].class);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    this.log.error((Object)("lookupSSLOptionsBuilderMethods: retrieving method withCipherSuites() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                }
            }
        }
        if (this.sslOptions_C == null && (this.rEAJSslOptions_builder_M == null || this.rEAJSslOptionsBuild_build_M == null || this.rEAJSslOptions_builder_withSSLContext_M == null || this.rEAJSslOptions_builder_withCipherSuites_M == null)) {
            this.log.error((Object)("lookupSSLOptionsBuilderMethods: lookup of of SSLOptions methods failed: sslOptions_C=" + this.sslOptions_C + ", rEAJSslOptions_builder_M=" + this.rEAJSslOptions_builder_M + ", rEAJSslOptions_builder_withSSLContext_M=" + this.rEAJSslOptions_builder_withSSLContext_M + ", rEAJSslOptions_builder_withCipherSuites_M=" + this.rEAJSslOptions_builder_withCipherSuites_M));
        }
    }

    private void lookupDateMethods() {
        String[] setMethodNames;
        String[] getMethodNames;
        String fcn_name = "lookupDateMethods";
        boolean isFinest = this.log.isFinestEnabled();
        String rowClassName = "com.datastax.driver.core.Row";
        Class<?> rowClass = null;
        try {
            rowClass = Class.forName(rowClassName);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("lookupDateMethods: getting class forName " + rowClassName + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            return;
        }
        for (String methodName : getMethodNames = new String[]{"getTimestamp", "getDate"}) {
            try {
                this.row_getDate_String_M = rowClass.getMethod(methodName, String.class);
                this.row_getDate_int_M = rowClass.getMethod(methodName, Integer.TYPE);
                break;
            }
            catch (NoSuchMethodException | SecurityException e) {
                if (!isFinest) continue;
                this.log.finest((Object)("lookupDateMethods: retrieving method " + methodName + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
        }
        if (this.row_getDate_String_M == null) {
            this.log.error((Object)"lookupDateMethods: lookup of Date row.getXXXXX(String) failed");
            return;
        }
        if (this.row_getDate_int_M == null) {
            this.log.error((Object)"lookupDateMethods: lookup of Date row.getXXXXX(int) failed");
            return;
        }
        String boundStatementClassName = "com.datastax.driver.core.BoundStatement";
        Class<?> boundStatementClass = null;
        try {
            boundStatementClass = Class.forName(boundStatementClassName);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("lookupDateMethods: getting class forName " + boundStatementClassName + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            return;
        }
        for (String methodName : setMethodNames = new String[]{"setTimestamp", "setDate"}) {
            try {
                this.boundStatement_setDate_String_Date_M = boundStatementClass.getMethod(methodName, String.class, Date.class);
                this.boundStatement_setDate_int_Date_M = boundStatementClass.getMethod(methodName, Integer.TYPE, Date.class);
                break;
            }
            catch (NoSuchMethodException e) {
                if (!isFinest) continue;
                this.log.finest((Object)("lookupDateMethods: retrieving method BoundStatement." + methodName + " for Date.class threw " + e.getClass().getName() + " for version " + this.driverVersion));
            }
            catch (SecurityException e) {
                this.log.error((Object)("lookupDateMethods: retrieving method BoundStatement." + methodName + " for Date.class threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
        }
        if (this.boundStatement_setDate_String_Date_M == null) {
            this.log.error((Object)"lookupDateMethods: lookup of boundStatement.setXXXXX(String, date) failed");
            return;
        }
        if (this.boundStatement_setDate_int_Date_M == null) {
            this.log.error((Object)"lookupDateMethods: lookup of boundStatement.setXXXXX(int, Date) failed");
            return;
        }
        if (this.boundStatement_setDate_String_Date_M == null || this.boundStatement_setDate_int_Date_M == null || this.row_getDate_String_M == null && this.row_getDate_int_M == null) {
            this.log.error((Object)("lookupDateMethods: lookup of of BoundStatement.setDate methods failed: boundStatement_setDate_String_Date=" + this.boundStatement_setDate_String_Date_M + ": boundStatement_setDate_int_Date=" + this.boundStatement_setDate_int_Date_M + ", row_getDate_String=" + this.row_getDate_String_M + ", row_getDate_int=" + this.row_getDate_int_M));
        }
    }

    private void lookupExceptions() {
        block2: {
            String fcn_name = "lookupExceptions";
            boolean isFinest = this.log.isFinestEnabled();
            String className = "com.datastax.driver.core.exceptions.TransportException";
            try {
                this.transportationException_C = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (!isFinest) break block2;
                this.log.finest((Object)("lookupExceptions: getting class forName " + className + " threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
        }
    }

    @Override
    public QueryLogger.Builder getQueryLoggerBuilder(Cluster cluster) {
        String fcn_name = "getQueryLoggerBuilder";
        QueryLogger.Builder builder = null;
        if (this.queryLoggerBuilder_M != null) {
            try {
                builder = (QueryLogger.Builder)this.queryLoggerBuilder_M.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error((Object)("getQueryLoggerBuilder: invoking builder() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
        } else if (this.queryLoggerBuilder_Cluster_M != null) {
            try {
                builder = (QueryLogger.Builder)this.queryLoggerBuilder_Cluster_M.invoke(null, cluster);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error((Object)("getQueryLoggerBuilder: invoking builder(Cluster) threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
        } else {
            this.log.error((Object)"getQueryLoggerBuilder: no QueryLogger.builder() method found");
        }
        return builder;
    }

    @Override
    public SSLOptions getSSLOptions(CassandraSSLOptions cassSSLOptions) {
        String fcn_name = "getQueryLoggerBuilder";
        SSLOptions sslOptions = null;
        if (this.sslOptions_C != null) {
            try {
                sslOptions = (SSLOptions)this.sslOptions_C.newInstance(cassSSLOptions.getSslContext(), cassSSLOptions.getCipherSuites());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                this.log.error((Object)("getQueryLoggerBuilder: invoking newInstance() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            }
            return sslOptions;
        }
        if (this.rEAJSslOptions_builder_M != null && this.rEAJSslOptions_builder_withSSLContext_M != null && this.rEAJSslOptions_builder_withCipherSuites_M != null) {
            Object remoteEndpointAwareJdkSSLOptionsBuilder = null;
            try {
                remoteEndpointAwareJdkSSLOptionsBuilder = this.rEAJSslOptions_builder_M.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error((Object)("getQueryLoggerBuilder: invoking method builder() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                return null;
            }
            if (cassSSLOptions.getSslContext() != null) {
                try {
                    remoteEndpointAwareJdkSSLOptionsBuilder = this.rEAJSslOptions_builder_withSSLContext_M.invoke(remoteEndpointAwareJdkSSLOptionsBuilder, cassSSLOptions.getSslContext());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.log.error((Object)("getQueryLoggerBuilder: invoking method withSSLContext() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                    return null;
                }
            }
            if (cassSSLOptions.getCipherSuites() != null) {
                try {
                    remoteEndpointAwareJdkSSLOptionsBuilder = this.rEAJSslOptions_builder_withCipherSuites_M.invoke(remoteEndpointAwareJdkSSLOptionsBuilder, new Object[]{cassSSLOptions.getCipherSuites()});
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.log.error((Object)("getQueryLoggerBuilder: invoking method withCipherSuites() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                    return null;
                }
            }
            try {
                sslOptions = (SSLOptions)this.rEAJSslOptionsBuild_build_M.invoke(remoteEndpointAwareJdkSSLOptionsBuilder, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error((Object)("getQueryLoggerBuilder: invoking method RemoteEndpointAwareJdkSSLOptions$Builder.build() threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
                return null;
            }
            return sslOptions;
        }
        this.log.error((Object)("getQueryLoggerBuilder: unable to construct SSLOptions: sslOptions_C=" + this.sslOptions_C + ", sslOptionsBuilder_M=" + this.rEAJSslOptions_builder_M + ", withSSLContext_M=" + this.rEAJSslOptions_builder_withSSLContext_M + ", withCipherSuites_M=" + this.rEAJSslOptions_builder_withCipherSuites_M));
        return null;
    }

    private boolean checkVersion(String version) {
        String[] dComps;
        String[] vComps = version.split("\\.");
        int numComps = vComps.length < (dComps = this.driverVersion.split("\\.")).length ? vComps.length : dComps.length;
        for (int i = 0; i < numComps; ++i) {
            if (vComps[i].equals(dComps[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Date getDate(Row row, String colName) {
        String fcn_name = "getDate(colName)";
        Object retObj = null;
        try {
            retObj = this.row_getDate_String_M.invoke((Object)row, colName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.log.error((Object)("getDate(colName): invoking method Row.getDate(String) threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            return null;
        }
        if (retObj == null) {
            return null;
        }
        if (!(retObj instanceof Date)) {
            this.log.error((Object)("getDate(colName): invoking row_getDate_String_M() did not return a Date, instead " + retObj.getClass().getCanonicalName()));
            return null;
        }
        return (Date)retObj;
    }

    @Override
    public Date getDate(Row row, int colNum) {
        String fcn_name = "getDate(colNum)";
        Object retObj = null;
        try {
            retObj = this.row_getDate_String_M.invoke((Object)row, colNum);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.log.error((Object)("getDate(colNum): invoking method Row.getDate(int) threw " + e.getClass().getName() + " for version " + this.driverVersion), (Throwable)e);
            return null;
        }
        if (retObj == null) {
            return null;
        }
        if (!(retObj instanceof Date)) {
            this.log.error((Object)("getDate(colNum): invoking row_getDate_String_M() did not return a Date, instead " + retObj.getClass().getCanonicalName()));
            return null;
        }
        return (Date)retObj;
    }

    @Override
    public void setDate(BoundStatement stmt, String colName, Date date) {
        String fcn_name = "setDate(String)";
        if (this.boundStatement_setDate_String_Date_M != null) {
            try {
                this.boundStatement_setDate_String_Date_M.invoke((Object)stmt, colName, date);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error((Object)("setDate(String): invoking method BoundStatement.setDate(Date) threw " + e.getClass().getName() + " for version " + this.driverVersion + ", colName=" + colName + ", date=" + date), (Throwable)e);
            }
        }
    }

    @Override
    public void setDate(BoundStatement stmt, int colNum, Date date) {
        String fcn_name = "setDate(int)";
        if (this.boundStatement_setDate_String_Date_M != null) {
            try {
                this.boundStatement_setDate_int_Date_M.invoke((Object)stmt, colNum, date);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.error((Object)("setDate(int): invoking method BoundStatement.setDate(Date) threw " + e.getClass().getName() + " for version " + this.driverVersion + ", colNum=" + colNum + ", date=" + date));
            }
        }
    }

    @Override
    public boolean isTransportationException(Exception exc) {
        boolean fcn_rc;
        String fcn_name = "isTransportationException";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("isTransportationException: enter, exc=" + exc + ", transportationExceptionClass=" + this.transportationException_C));
        }
        boolean bl = fcn_rc = this.transportationException_C != null && this.transportationException_C.isInstance(exc);
        if (isFiner) {
            this.log.finer((Object)("isTransportationException: leave, returning " + fcn_rc));
        }
        return fcn_rc;
    }
}

