/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraBasedDAO;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.asm.trustmgmt.IBMTrustMgmtUtil;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraSSLOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.List;

public class LoadBalancerDAO {
    private final Logger log = AsmLogger.getLogger(LoadBalancerDAO.class);
    private final String LOAD_BALANCER_KEYSPACE = "loadbalancer";
    private final String SELECT_SQL = "SELECT resolved_address FROM resolvedaddress WHERE loadbalancer_id=? AND key=?";
    private final String SELECT_ALL_KEY_SQL = "SELECT key FROM resolvedaddress WHERE loadbalancer_id=? ALLOW FILTERING";
    private final String SELECT_ALL_SQL = "SELECT key, resolved_address FROM resolvedaddress WHERE loadbalancer_id=? ALLOW FILTERING";
    private final String UPDATE_SQL = "UPDATE resolvedaddress SET resolved_address=? WHERE loadbalancer_id=? AND key=?";
    private final String UPDATE_IF_SQL = "UPDATE resolvedaddress SET resolved_address=? WHERE loadbalancer_id=? AND key=? IF resolved_address=?";
    private CassandraBasedDAO cbDAO = null;
    private Session session = null;
    private PreparedStatement selectPs = null;
    private PreparedStatement selectAllKeyPs = null;
    private PreparedStatement selectAllPs = null;
    private PreparedStatement updatePs = null;
    private PreparedStatement updateIfPs = null;

    public LoadBalancerDAO(String host, int port, int jmxPort, String dbUsername, String dbPassword) throws DMException {
        CassandraSSLOptions sslOptions = IBMTrustMgmtUtil.getInstance().getSSLOptions();
        if (sslOptions == null) {
            this.log.error((Object)"LoadBalancerDAO: Unable to get CassandraSSLOptions");
        } else {
            UstoreDAOFactory.setDfltSSLOptions(sslOptions);
            this.log.info((Object)"LoadBalancerDAO: Set up TLS for accessing Cassandra");
        }
        this.cbDAO = UstoreDAOFactory.createCassandraBasedDAO(host, port, jmxPort, dbUsername, dbPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() {
        if (this.cbDAO != null && this.session == null) {
            LoadBalancerDAO loadBalancerDAO = this;
            synchronized (loadBalancerDAO) {
                if (this.session == null) {
                    try {
                        this.session = this.cbDAO.createSession("loadbalancer");
                        this.selectPs = this.session.prepare("SELECT resolved_address FROM resolvedaddress WHERE loadbalancer_id=? AND key=?");
                        this.selectAllKeyPs = this.session.prepare("SELECT key FROM resolvedaddress WHERE loadbalancer_id=? ALLOW FILTERING");
                        this.selectAllPs = this.session.prepare("SELECT key, resolved_address FROM resolvedaddress WHERE loadbalancer_id=? ALLOW FILTERING");
                        this.updatePs = this.session.prepare("UPDATE resolvedaddress SET resolved_address=? WHERE loadbalancer_id=? AND key=?");
                        this.updateIfPs = this.session.prepare("UPDATE resolvedaddress SET resolved_address=? WHERE loadbalancer_id=? AND key=? IF resolved_address=?");
                    }
                    catch (DMException e) {
                        this.log.error((Object)("getSession: DMException=" + e), (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return this.session;
    }

    public void closeCluster() {
        this.log.info((Object)"Calling closeCluster()");
        this.cbDAO.closeCluster();
    }

    public String queryResolvedAddress(Long loadBalancerId, String key) {
        this.log.finer((Object)("queryResolvedAddress: loadBalancerId=" + loadBalancerId + ", key=" + key));
        Session session = this.getSession();
        if (session == null) {
            this.log.error((Object)"queryResolvedAddress: null session!");
            return null;
        }
        try {
            Row row = session.execute((Statement)this.selectPs.bind(new Object[]{loadBalancerId, key})).one();
            if (row == null) {
                this.log.finer((Object)"queryResolvedAddress: null row!");
                return null;
            }
            String resolvedAddress = row.getString("resolved_address");
            this.log.finer((Object)("queryResolvedAddress: returning " + resolvedAddress));
            return resolvedAddress;
        }
        catch (Exception e) {
            this.log.error((Object)("queryResolvedAddress: caught exception e=" + e), (Throwable)e);
            return null;
        }
    }

    public List<String> queryKeys(Long loadBalancerId) {
        this.log.finer((Object)("queryKeys: loadBalancerId=" + loadBalancerId));
        Session session = this.getSession();
        if (session == null) {
            this.log.error((Object)"queryKeys: null session!");
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            ResultSet rs = session.execute((Statement)this.selectAllKeyPs.bind(new Object[]{loadBalancerId}));
            for (Row row : rs) {
                retVal.add(row.getString("key"));
            }
            this.log.finer((Object)("queryKeys: returning " + retVal));
            return retVal;
        }
        catch (Exception e) {
            this.log.error((Object)("queryKeys: caught exception e=" + e), (Throwable)e);
            return retVal;
        }
    }

    public List<String> queryKeys(Long loadBalancerId, String addr) {
        this.log.finer((Object)("queryKeys: loadBalancerId=" + loadBalancerId + ", addr=" + addr));
        Session session = this.getSession();
        if (session == null) {
            this.log.error((Object)"queryKeys: null session!");
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            ResultSet rs = session.execute((Statement)this.selectAllPs.bind(new Object[]{loadBalancerId}));
            for (Row row : rs) {
                if (!addr.equals(row.getString("resolved_address"))) continue;
                retVal.add(row.getString("key"));
            }
            this.log.finer((Object)("queryKeys: returning " + retVal));
            return retVal;
        }
        catch (Exception e) {
            this.log.error((Object)("queryKeys: caught exception e=" + e), (Throwable)e);
            return retVal;
        }
    }

    public String setResolvedAddress(Long loadBalancerId, String key, String addr) {
        this.log.finer((Object)("setResolvedAddress: loadBalancerId=" + loadBalancerId + ", key=" + key + ", addr=" + addr));
        Session session = this.getSession();
        if (session == null) {
            this.log.error((Object)"setResolvedAddress: null session!");
            return null;
        }
        try {
            ResultSet rs = session.execute((Statement)this.updatePs.bind(new Object[]{addr, loadBalancerId, key}));
            this.log.finer((Object)("setResolvedAddress: wasApplied()=" + rs.wasApplied()));
            return rs.wasApplied() ? addr : null;
        }
        catch (Exception e) {
            this.log.error((Object)("setResolvedAddress: caught exception e=" + e), (Throwable)e);
            return null;
        }
    }

    public String compareAndSetResolvedLocation(Long loadBalancerId, String key, String expect, String update) {
        this.log.finer((Object)("compareAndSetResolvedLocation: loadBalancerId=" + loadBalancerId + ", key=" + key + ", expect=" + expect + ", update=" + update));
        Session session = this.getSession();
        if (session == null) {
            this.log.error((Object)"compareAndSetResolvedLocation: null session!");
            return null;
        }
        try {
            ResultSet rs = session.execute((Statement)this.updateIfPs.bind(new Object[]{update, loadBalancerId, key, expect}));
            if (rs.wasApplied()) {
                this.log.finer((Object)("compareAndSetResolvedLocation: wasApplied()=true, returning " + update));
                return update;
            }
            Row row = rs.one();
            if (row == null) {
                this.log.error((Object)"compareAndSetResolvedLocation: null row!");
                return null;
            }
            row = session.execute((Statement)this.selectPs.bind(new Object[]{loadBalancerId, key})).one();
            if (row == null) {
                this.log.finer((Object)"compareAndSetResolvedLocation for select query: null row!");
                return null;
            }
            String addr = row.getString("resolved_address");
            this.log.finer((Object)("compareAndSetResolvedLocation: wasApplied()=false, returning " + addr));
            return addr;
        }
        catch (Exception e) {
            this.log.error((Object)("queryResolvedAddress: caught exception e=" + e), (Throwable)e);
            return null;
        }
    }
}

