/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.datamgr.objectapi.AsmInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserStoreKeyspace {
    public static final String KEYSPACE_PREFIX = "community";
    public static final String KEYSPACE_SEPARATOR = "_";
    private final String name;
    private final List<AsmInstance> instances;
    private static final String ksNameRegex = "community(_\\d+)+";
    private static final Pattern ksNamePattern = Pattern.compile("community(_\\d+)+");
    private static final int MAX_ASM_IDS = 2;

    public UserStoreKeyspace(String name) {
        this.name = name;
        this.instances = null;
    }

    public UserStoreKeyspace(List<AsmInstance> instances) {
        this.instances = new ArrayList<AsmInstance>(instances);
        ArrayList<Long> instanceIds = new ArrayList<Long>();
        for (AsmInstance instance : instances) {
            instanceIds.add(instance.getId());
        }
        this.name = UserStoreKeyspace.buildName(instanceIds);
    }

    public static String buildName(List<Long> instanceIds) {
        instanceIds = UserStoreKeyspace.removeDupsList(instanceIds);
        StringBuilder builder = new StringBuilder(KEYSPACE_PREFIX);
        for (Long id : instanceIds) {
            builder.append(KEYSPACE_SEPARATOR);
            builder.append(id);
        }
        return builder.toString();
    }

    private static List<Long> removeDupsList(List<Long> values) {
        Collections.sort(values);
        for (int i = 0; i < values.size(); ++i) {
            long curVal = values.get(i);
            int j = i + 1;
            while (j < values.size() && curVal == values.get(j)) {
                values.remove(j);
            }
        }
        if (values.size() > 2) {
            values = values.subList(0, 2);
        }
        return values;
    }

    public static boolean isUserStoreKeyspace(String ksName) {
        Matcher matcher = ksNamePattern.matcher(ksName);
        return matcher.matches();
    }

    public String getName() {
        return this.name;
    }

    public List<AsmInstance> getAsmInstances() {
        return this.instances;
    }

    public List<Long> getInstanceIds() {
        String[] fields = this.name.split(KEYSPACE_SEPARATOR);
        ArrayList<Long> instanceIds = new ArrayList<Long>();
        for (int i = 0; i < fields.length; ++i) {
            if (i == 0) continue;
            Long instanceId = Integer.parseInt(fields[i]);
            instanceIds.add(instanceId);
        }
        return instanceIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserStoreKeyspace other = (UserStoreKeyspace)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

