/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.ppm.SipDeviceDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.ppm.AsmSipDevice;
import com.avaya.asm.datamgr.objectapi.ppm.AsmSipDeviceData;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SipDeviceDataDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(SipDeviceDataDAO.class);
    protected final String ASM_SIP_DEVICE_NAME = "asmsipdevice";
    protected Map<Long, AsmSipDeviceData> sipDeviceDataMap = new HashMap<Long, AsmSipDeviceData>();
    protected Map<Long, List<AsmSipDeviceData>> sipDeviceDataMapByDeviceId = new HashMap<Long, List<AsmSipDeviceData>>();
    protected static final String joinStmt = DMUtilities.isBranch() ? " JOIN asmsipdevice dev ON dev.id = devd.device_id JOIN asmcommprofile asm ON asm.id = dev.asmcommprofile_id WHERE asm.survivability_server_id = ?" : " JOIN asmsipdevice dev ON dev.id = devd.device_id JOIN asmcommprofile asm ON asm.id = dev.asmcommprofile_id JOIN asmusercommunityassign uca ON uca.asmusercommunity_id = asm.usercommunity_id WHERE uca.asminstance_id = ?";
    protected static final String selectSipDevicesData = "SELECT devd.id, devd.device_id, devd.datacategory, devd.dataname, devd.updatedatetime, CASE WHEN devd.datacategory= 'Config' THEN '' ELSE CASE WHEN devd.datavalue_64k IS NULL THEN devd.datavalue ELSE devd.datavalue_64k END END AS datavalue FROM asmsipdevicedata devd";
    protected static final String getSipDevicesData = "SELECT devd.id, devd.device_id, devd.datacategory, devd.dataname, devd.updatedatetime, CASE WHEN devd.datacategory= 'Config' THEN '' ELSE CASE WHEN devd.datavalue_64k IS NULL THEN devd.datavalue ELSE devd.datavalue_64k END END AS datavalue FROM asmsipdevicedata devd" + joinStmt;
    protected static final String getSipDeviceData = getSipDevicesData + " AND devd.id = ?";
    protected static final String getSipDevicesDataByDeviceId = "SELECT devd.id, devd.device_id, devd.datacategory, devd.dataname, devd.updatedatetime, CASE WHEN devd.datacategory= 'Config' THEN '' ELSE CASE WHEN devd.datavalue_64k IS NULL THEN devd.datavalue ELSE devd.datavalue_64k END END AS datavalue FROM asmsipdevicedata devd WHERE devd.device_id = ?";
    private static final ResultSetMapper sipDevicesDataMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmSipDeviceData> map = new HashMap<Long, AsmSipDeviceData>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, SipDeviceDataDAO.buildDeviceDataFromResultSet(rs));
            }
            return map;
        }
    };
    private static final ResultSetMapper sipDeviceDataMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return SipDeviceDataDAO.buildDeviceDataFromResultSet(rs);
            }
            return null;
        }
    };

    public int getFetchSize() {
        return 10000;
    }

    public ResultSetMapper getSipDevicesDataMapper() {
        return sipDevicesDataMapper;
    }

    public ResultSetMapper getSipDeviceDataMapper() {
        return sipDeviceDataMapper;
    }

    private static AsmSipDeviceData buildDeviceDataFromResultSet(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String category = rs.getString("datacategory");
        String datavalue = null;
        if (!"Config".equals(category)) {
            datavalue = rs.getString("datavalue");
        }
        return new AsmSipDeviceData(id, rs.getLong("device_id"), category, rs.getString("dataname"), rs.getTimestamp("updatedatetime"), datavalue);
    }

    protected String getInitQueryStr() {
        return getSipDevicesData;
    }

    protected Object[] getInitParams() {
        if (DMUtilities.isBranch()) {
            Long myEntityId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMySIPEntityId();
            return new Object[]{myEntityId == null ? 0L : myEntityId};
        }
        Long myAsmInstanceId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        return new Object[]{myAsmInstanceId == null ? 0L : myAsmInstanceId};
    }

    protected String getUpdateQueryStr() {
        return getSipDeviceData;
    }

    protected Object[] getUpdateParams(Object id) {
        if (DMUtilities.isBranch()) {
            Long myEntityId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMySIPEntityId();
            return new Object[]{myEntityId == null ? 0L : myEntityId, id};
        }
        Long myAsmInstanceId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        return new Object[]{myAsmInstanceId == null ? 0L : myAsmInstanceId, id};
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        this.getDataMgr(SipDeviceDAO.class);
        HashMap sipDeviceDataMapTMP = new HashMap();
        HashMap<Long, List<AsmSipDeviceData>> sipDeviceDataMapByDeviceIdTMP = new HashMap<Long, List<AsmSipDeviceData>>();
        Object[] params = this.getInitParams();
        try {
            if (params[0] != null) {
                sipDeviceDataMapTMP = (HashMap)this.dataSource.executeChunkedQuery(this.getInitQueryStr(), params, this.getSipDevicesDataMapper(), 10000, 30000L);
            }
            this.initializeByDeviceIdMap(sipDeviceDataMapByDeviceIdTMP, sipDeviceDataMapTMP);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.sipDeviceDataMap = sipDeviceDataMapTMP;
                this.sipDeviceDataMapByDeviceId = sipDeviceDataMapByDeviceIdTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                log.fine((Object)(this.getClass().getSimpleName() + ": completing init"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = SipDeviceDataDAO.class.getSimpleName() + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        if (!this.getDependentTables().contains(tableName) && !"asmsipdevice".equals(tableName) || operation == null) {
            return;
        }
        Long id = tableEvent.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean lockHeld = false;
        try {
            if ("asmsipdevicedata".equals(tableName)) {
                Long sipDeviceId;
                AsmSipDeviceData newSipDevice = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    newSipDevice = (AsmSipDeviceData)this.dataSource.executeQuery(this.getUpdateQueryStr(), this.getUpdateParams(id), this.getSipDeviceDataMapper());
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                AsmSipDeviceData oldSipDeviceData = this.sipDeviceDataMap.remove(id);
                if (oldSipDeviceData == null) {
                    if (operation == DAOReplicationEvent.OperationType.DELETE && isFiner) {
                        log.finer((Object)(fcn_name + "Sip device data was null for " + (Object)((Object)operation) + " operation; non-local user or we may be out of sync"));
                    }
                } else {
                    sipDeviceId = oldSipDeviceData.getDevice_id();
                    if (sipDeviceId != null) {
                        List<AsmSipDeviceData> ddList = this.sipDeviceDataMapByDeviceId.get(sipDeviceId);
                        if (ddList == null) {
                            log.warn((Object)(fcn_name + "ddList was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
                        } else {
                            ddList.remove(oldSipDeviceData);
                            if (ddList.isEmpty()) {
                                this.sipDeviceDataMapByDeviceId.remove(sipDeviceId);
                            }
                        }
                    }
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE && newSipDevice != null) {
                    if (isFiner) {
                        log.finer((Object)(fcn_name + "Retrieved  " + newSipDevice.toString()));
                    }
                    this.sipDeviceDataMap.put(id, newSipDevice);
                    sipDeviceId = newSipDevice.getDevice_id();
                    if (sipDeviceId != null) {
                        if (!this.sipDeviceDataMapByDeviceId.containsKey(sipDeviceId)) {
                            this.sipDeviceDataMapByDeviceId.put(sipDeviceId, new ArrayList());
                        }
                        this.sipDeviceDataMapByDeviceId.get(sipDeviceId).add(newSipDevice);
                    }
                }
            } else if ("asmsipdevice".equals(tableName)) {
                Map devDataMapTMP = null;
                lockHeld = false;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    devDataMapTMP = (Map)this.dataSource.executeQuery(getSipDevicesDataByDeviceId, params, this.getSipDevicesDataMapper());
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                List<AsmSipDeviceData> ddList = this.sipDeviceDataMapByDeviceId.remove(id);
                if (ddList == null) {
                    if (operation == DAOReplicationEvent.OperationType.DELETE && isFiner) {
                        log.finer((Object)(fcn_name + "AsmSipDeviceData list was null for " + (Object)((Object)operation) + " operation; non-local user or we may be out of sync"));
                    }
                } else {
                    for (AsmSipDeviceData dd : ddList) {
                        AsmSipDeviceData oldSipDeviceData = this.sipDeviceDataMap.remove(dd.getId());
                        if (oldSipDeviceData != null || operation != DAOReplicationEvent.OperationType.DELETE) continue;
                        log.warn((Object)(fcn_name + "AsmSipDeviceData was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
                    }
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    for (Long devDataId : devDataMapTMP.keySet()) {
                        AsmSipDeviceData newdevicedata = (AsmSipDeviceData)devDataMapTMP.get(devDataId);
                        this.sipDeviceDataMap.put(devDataId, newdevicedata);
                        if (!this.sipDeviceDataMapByDeviceId.containsKey(id)) {
                            this.sipDeviceDataMapByDeviceId.put(id, new ArrayList());
                        }
                        this.sipDeviceDataMapByDeviceId.get(id).add(newdevicedata);
                    }
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing. e = "), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " update successful"));
            }
        }
    }

    private void initializeByDeviceIdMap(Map<Long, List<AsmSipDeviceData>> sipDeviceDataMapByDeviceIdTMP, Map<Long, AsmSipDeviceData> sipDeviceDataMapTMP) {
        for (AsmSipDeviceData sipDeviceData : sipDeviceDataMapTMP.values()) {
            Long deviceId = sipDeviceData.getDevice_id();
            if (!sipDeviceDataMapByDeviceIdTMP.containsKey(deviceId)) {
                sipDeviceDataMapByDeviceIdTMP.put(deviceId, new ArrayList());
            }
            sipDeviceDataMapByDeviceIdTMP.get(deviceId).add(sipDeviceData);
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmsipdevicedata");
        return list;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinerEnabled()) {
            log.finer((Object)(SipDeviceDataDAO.class.getSimpleName() + ".objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmSipDevice || newObject instanceof AsmSipDevice) {
            DAOTableEvent event;
            AsmSipDevice oldAsmSipDevice = (AsmSipDevice)oldObject;
            AsmSipDevice newAsmSipDevice = (AsmSipDevice)newObject;
            if (oldAsmSipDevice != null && newAsmSipDevice != null && oldAsmSipDevice.getId() == newAsmSipDevice.getId()) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(SipDeviceDataDAO.class.getSimpleName() + ".objectChanged: AsmSipDevice CHANGED with same id - ignored"));
                }
                return;
            }
            if (oldAsmSipDevice != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(SipDeviceDataDAO.class.getSimpleName() + ".objectChanged: AsmSipDevice DELETED"));
                }
                event = new DAOTableEvent("asmsipdevice", DAOReplicationEvent.OperationType.DELETE, oldAsmSipDevice.getId());
                this.updateDAO(event);
            }
            if (newAsmSipDevice != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(SipDeviceDataDAO.class.getSimpleName() + ".objectChanged: AsmSipDevice ADDED"));
                }
                event = new DAOTableEvent("asmsipdevice", DAOReplicationEvent.OperationType.INSERT, newAsmSipDevice.getId());
                this.updateDAO(event);
            }
        } else if (!(oldObject instanceof AsmInstance) && !(newObject instanceof AsmInstance)) {
            log.warn((Object)(SipDeviceDataDAO.class.getSimpleName() + ".objectChanged: Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsmSipDeviceData> getDeviceDataByDeviceId(Long deviceId) {
        if (deviceId != null) {
            try {
                this.lock.acquireReadLock();
                List<AsmSipDeviceData> originalDeviceDataList = this.sipDeviceDataMapByDeviceId.get(deviceId);
                if (originalDeviceDataList != null) {
                    ArrayList<AsmSipDeviceData> arrayList = new ArrayList<AsmSipDeviceData>(originalDeviceDataList);
                    return arrayList;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsmSipDeviceData> getDeviceData(Long deviceId, String category, String name) {
        if (deviceId != null) {
            try {
                this.lock.acquireReadLock();
                List<AsmSipDeviceData> sipDevicesDataList = this.sipDeviceDataMapByDeviceId.get(deviceId);
                if (sipDevicesDataList != null) {
                    Iterator<AsmSipDeviceData> iter = sipDevicesDataList.iterator();
                    ArrayList<AsmSipDeviceData> retSipDevicesDataList = null;
                    while (iter.hasNext()) {
                        AsmSipDeviceData sipDevicedata = iter.next();
                        if (category != null && !category.equals(sipDevicedata.getDatacategory()) || name != null && !name.equals(sipDevicedata.getDataname())) continue;
                        if (retSipDevicesDataList == null) {
                            retSipDevicesDataList = new ArrayList<AsmSipDeviceData>();
                        }
                        retSipDevicesDataList.add(sipDevicedata);
                    }
                    ArrayList<AsmSipDeviceData> arrayList = retSipDevicesDataList;
                    return arrayList;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    public AsmSipDeviceData getDeviceDataById(Long id) {
        if (id != null) {
            try {
                this.lock.acquireReadLock();
                AsmSipDeviceData asmSipDeviceData = this.sipDeviceDataMap.get(id);
                return asmSipDeviceData;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    @SMConsole(description="Get the contents of all internal storage related to AsmSipDeviceDatas. This method exists for debugging the SipDeviceDataDAO.")
    public String getSipDeviceDataData() {
        try {
            this.lock.acquireReadLock();
            String string = this.stringify();
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get Map containing data keyed by asmsipdevicedata.id")
    public Map<Long, AsmSipDeviceData> getSipDeviceDataByDataId() {
        try {
            this.lock.acquireReadLock();
            Map<Long, AsmSipDeviceData> map = Collections.unmodifiableMap(this.sipDeviceDataMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get Map containing data keyed by asmsipdevice.id vs. asmsipdevicedata.id")
    public Map<Long, List<AsmSipDeviceData>> getSipDeviceDataByDeviceId() {
        try {
            this.lock.acquireReadLock();
            Map<Long, List<AsmSipDeviceData>> map = Collections.unmodifiableMap(this.sipDeviceDataMapByDeviceId);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get the number of entries in the main device data Map")
    public int getSipDeviceDataCount() {
        try {
            this.lock.acquireReadLock();
            int n = this.sipDeviceDataMap.size();
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private String stringify() {
        StringBuilder retBuf = new StringBuilder();
        retBuf.append("sipDeviceDataMap (AsmSipDeviceData ID to AsmSipDeviceData objects) - local, ");
        retBuf.append(this.sipDeviceDataMap.size()).append(" entries\n");
        for (Map.Entry<Long, AsmSipDeviceData> entry : this.sipDeviceDataMap.entrySet()) {
            retBuf.append(entry).append("\n");
        }
        retBuf.append("\n");
        retBuf.append("sipDeviceDataMapByDeviceId (AsmSipDevice ID to List of AsmSipDeviceData objects) - local, ");
        retBuf.append(this.sipDeviceDataMapByDeviceId.size()).append(" entries\n");
        for (Map.Entry<Long, Object> entry : this.sipDeviceDataMapByDeviceId.entrySet()) {
            retBuf.append(entry.getKey()).append(":\n");
            for (AsmSipDeviceData dev : (List)entry.getValue()) {
                retBuf.append(dev).append("\n");
            }
        }
        return retBuf.toString();
    }
}

