/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.DDLDataManagerIntf;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DDLMessageSender;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerDataKey;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.datadistributionlayer.TempFileResponseWrapper;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class DDLIntraClusterMember
extends DataDistLayerMember
implements DDLDataManagerIntf {
    private static Logger log = AsmLogger.getLogger(DDLIntraClusterMember.class);
    protected Queue<DataDistLayerMessage> savedIntraMessageQueue = null;
    protected ConcurrentMap<Object, List<DataDistLayerData>> dataMapByKey = new ConcurrentHashMap<Object, List<DataDistLayerData>>();

    public DDLIntraClusterMember(String clusterName, String myType, DataDistLayerFactory ddlFactory) {
        super(clusterName, myType, ddlFactory);
        this.myGroupType = GroupCommIntf.DDLGroupType.INTRA_SM_CLUSTER;
        this.createGroup();
    }

    @Override
    protected void createGroup() {
        if (this.ddlFactory == null) {
            log.info((Object)"Can't create group:  null ddlFactory");
            return;
        }
        this.myClusterGroup = this.ddlFactory.createGroupCommIntf(this.myClusterName, this, DDLUtilities.getManagementIP(), null, this.myGroupType);
        log.info((Object)("Created DataDistLayerMember for cluster name " + this.myClusterName));
    }

    @Override
    public void sendMessage(DataDistLayerMemberAddr member, DataDistLayerMessage message) throws DDLException {
        DDLMessageSender.sendMessage(member, message, false);
    }

    @Override
    public void multicastMessage(DataDistLayerMessage message, boolean isSynchronous) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistLayer leader broadcasting message: " + message.toString()));
        }
        this.myClusterGroup.multicastMessage(message, isSynchronous);
    }

    @Override
    public Object queryHost(DataDistLayerMemberAddr member, DataDistLayerMessage message, int timeout) {
        return DDLMessageSender.queryHost(member, message, timeout, false);
    }

    @Override
    public Object queryLeader(DataDistLayerMessage message, int timeout) {
        Object retVal = super.queryLeader(message, timeout);
        if (retVal instanceof TempFileResponseWrapper) {
            try {
                return ((TempFileResponseWrapper)retVal).fromTempFile();
            }
            catch (Exception e) {
                log.error((Object)"cannot deserialize response", (Throwable)e);
            }
        }
        return retVal;
    }

    @Override
    public void storeData(DataDistLayerData data, boolean messageFromPeer) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 12, data);
        if (this.myClusterLeaderId != null) {
            this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster sent saveData to leader: " + data.toString()));
            log.finest((Object)("Invalidating local cache for: " + data.getKey().toString()));
        }
        this.dataMapByKey.remove(data.getKey());
    }

    @Override
    public void updateData(DataDistLayerData oldData, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef, boolean pushData) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 13, null);
        ArrayList<DataDistLayerData> tempList = new ArrayList<DataDistLayerData>();
        tempList.add(oldData);
        tempList.add(newData);
        message.setPayload(tempList);
        if (this.myClusterLeaderId != null) {
            this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster sent updateData to leader, oldData: " + oldData.toString() + " newData: " + newData.toString()));
            log.finest((Object)("Invalidating local cache for: " + oldData.getKey().toString()));
        }
        this.dataMapByKey.remove(oldData.getKey());
    }

    public void updateDataByKey(DataDistLayerData oldData, DataDistLayerData newData, boolean messageFromPeer, boolean updatedByRef, boolean pushData) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 27, null);
        ArrayList<DataDistLayerData> tempList = new ArrayList<DataDistLayerData>();
        tempList.add(newData);
        message.setPayload(tempList);
        if (this.myClusterLeaderId != null) {
            this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster sent updateData to leader, new data key: " + newData.getKey() + " newData: " + newData.toString()));
            log.finest((Object)("Invalidating local cache for: " + newData.getKey().toString()));
        }
        this.dataMapByKey.remove(newData.getKey());
    }

    @Override
    public void removeData(DataDistLayerData data, boolean messageFromPeer) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 7, data);
        if (this.myClusterLeaderId != null) {
            this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster sent removeData to leader: " + data.toString()));
            log.finest((Object)("Invalidating local cache for: " + data.getKey().toString()));
        }
        this.dataMapByKey.remove(data.getKey());
    }

    public void removeDataByKey(DataDistLayerData data, boolean messageFromPeer) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 9, new DataDistLayerData(data.getKey(), data.getUserCommId()));
        if (this.myClusterLeaderId != null) {
            this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("DataDistCluster sent removeData to leader: " + data.toString()));
            log.finest((Object)("Invalidating local cache for: " + data.getKey().toString()));
        }
        this.dataMapByKey.remove(data.getKey());
    }

    @Override
    public List<DataDistLayerData> retrieveDataByKey(DataDistLayerDataKey key) {
        CopyOnWriteArrayList list = this.retrieveDataFromMap(key);
        if (list == null) {
            DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 2, key);
            list = (CopyOnWriteArrayList)this.queryLeader(message);
            if (log.isFinestEnabled()) {
                log.finest((Object)("leader returned data: " + list));
            }
            if (list != null) {
                this.dataMapByKey.put(key, list);
                list = new CopyOnWriteArrayList(list);
            }
        } else {
            list = new CopyOnWriteArrayList<DataDistLayerData>(list);
            if (log.isFinestEnabled()) {
                log.finest((Object)("returning data from local cache, key: " + key + " data: " + list));
            }
        }
        return list;
    }

    public List<DataDistLayerData> retrieveDataByMatchingKey(DataDistLayerDataKey key) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 14, key);
        List list = (List)this.queryLeader(message);
        if (log.isFinestEnabled()) {
            log.finest((Object)("leader returned matching data: " + list));
        }
        return list;
    }

    @Override
    public List<DataDistLayerData> retrieveDataByHost(DataDistLayerMemberAddr hostId) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 1, hostId);
        List list = (List)this.myClusterGroup.queryTheHost(this.myClusterLeaderId, message);
        if (log.isFinestEnabled()) {
            log.finest((Object)("retrieveDataByHost returning data: " + list));
        }
        return list;
    }

    @Override
    public void membershipChanged(String clusterName, List<Object> newMembers) {
        super.membershipChanged(clusterName, newMembers);
        if (this.myClusterLeaderId != null && !newMembers.contains(this.myClusterLeaderId)) {
            log.info((Object)("Leader " + this.myClusterLeaderId + " left the group"));
            this.myClusterLeaderId = null;
        }
    }

    @Override
    public Object handleQuery(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        DataDistLayerMemberAddr destination = message.getHost();
        if (destination != null && !destination.equals(this.getMyId())) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("forwarding query intended for " + destination));
            }
            return this.queryHost(destination, message);
        }
        if (message.getAppId() == DataDistLayerMessage.TargetAppId.INTERNAL) {
            switch (message.getMessageType()) {
                case 2: {
                    DataDistLayerDataKey key = (DataDistLayerDataKey)message.getPayload();
                    return this.retrieveDataFromMap(key);
                }
                case 14: {
                    DataDistLayerDataKey key = (DataDistLayerDataKey)message.getPayload();
                    return this.retrieveDataByMatchingKey(key);
                }
                case 4: {
                    if (log.isFinestEnabled()) {
                        log.finest((Object)("GET_KEY_MAP returning " + this.dataMapByKey));
                    }
                    return this.dataMapByKey;
                }
                case 1: 
                case 3: 
                case 15: {
                    return this.queryLeader(message);
                }
            }
        }
        return super.handleQuery(message, srcMember);
    }

    @Override
    protected void processInternalMessage(DataDistLayerMessage message, DataDistLayerMemberAddr sender) throws DDLException {
        switch (message.getMessageType()) {
            case 11: {
                this.myClusterLeaderId = message.getPayload();
                log.info((Object)("got a DDL SET_LEADER_ID: " + this.myClusterLeaderId));
                this.serviceSavedIntraMessages();
                break;
            }
            case 5: {
                Serializable payload = message.getPayload();
                DataDistLayerDataKey key = null;
                List pushedList = null;
                DataDistLayerData data = null;
                if (payload instanceof List) {
                    pushedList = (List)((Object)payload);
                    for (DataDistLayerData d : pushedList) {
                        this.dataMapByKey.remove(d.getKey());
                    }
                } else if (payload instanceof DataDistLayerData) {
                    data = (DataDistLayerData)payload;
                    key = data.getKey();
                    ArrayList<DataDistLayerData> newList = new ArrayList<DataDistLayerData>();
                    newList.add(data);
                    this.dataMapByKey.put(key, newList);
                } else {
                    key = (DataDistLayerDataKey)payload;
                    this.dataMapByKey.remove(key);
                }
                if (!log.isFinestEnabled()) break;
                if (key != null) {
                    log.finest((Object)("DataDistCluster leader invalidated cache for: " + key.toString()));
                    break;
                }
                log.finest((Object)"DataDistCluster leader invalidated cache for a bulk list.");
                break;
            }
            case 12: {
                break;
            }
            case 7: {
                break;
            }
            case 13: {
                break;
            }
            case 6: {
                log.warn((Object)"Received a REMOVE_ALL_DATA message");
                this.dataMapByKey.clear();
                break;
            }
            case 9: {
                if (this.myClusterLeaderId == null) break;
                this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
                break;
            }
            case 8: {
                if (this.myClusterLeaderId == null) break;
                this.myClusterGroup.sendMessage(this.myClusterLeaderId, message);
                break;
            }
            default: {
                super.processInternalMessage(message, sender);
            }
        }
    }

    protected synchronized void saveIntraMessage(DataDistLayerMessage msg) throws DDLException {
        if (this.savedIntraMessageQueue == null) {
            this.savedIntraMessageQueue = new LinkedBlockingQueue<DataDistLayerMessage>();
        }
        this.savedIntraMessageQueue.add(msg);
        throw new DDLException("Unable to send message - leaderId == null");
    }

    protected synchronized void serviceSavedIntraMessages() {
        if (this.myClusterLeaderId != null && this.savedIntraMessageQueue != null) {
            log.info((Object)"Servicing queued messages due to leader being down.");
            DataDistLayerMessage msg = null;
            int count = 0;
            while ((msg = this.savedIntraMessageQueue.poll()) != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Processing " + ++count));
                }
                this.myClusterGroup.sendMessage(this.myClusterLeaderId, msg);
            }
        }
    }

    public DataDistLayerMemberAddr getLeaderAddr() {
        return new DataDistLayerMemberAddr(this.myClusterName, this.myClusterLeaderId);
    }

    protected List<DataDistLayerData> retrieveDataFromMap(Object key) {
        List list = (List)this.dataMapByKey.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.dataMapByKey = new ConcurrentHashMap<Object, List<DataDistLayerData>>();
    }
}

