/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dynamic;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.common.logging.client.Logger;

public abstract class DynamicDataMgr
extends DataMgr
implements GenericAlarmRecoveryIntf {
    private static final Logger log = AsmLogger.getLogger(DynamicDataMgr.class);

    public DynamicDataMgr() {
    }

    public DynamicDataMgr(boolean supportsListeners) {
        super(supportsListeners);
    }

    @Override
    public boolean preAlarmAttemptRecovery(GenericAlarm alarm) {
        return this.isCorrected();
    }

    @Override
    public boolean postAlarmAttemptRecovery(GenericAlarm alarm) {
        return this.isCorrected();
    }

    private boolean isCorrected() {
        try {
            if (this.failed()) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Timer firing for " + this.getClass().getSimpleName() + " to re-init()."));
                }
                this.init();
            }
            if (this.okay()) {
                return true;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Caught an exception on re-init attempt for " + this.getClass().getSimpleName()), (Throwable)e);
        }
        return false;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        log.warn((Object)("objectChanged: Not implemented for " + this.getClass().getSimpleName() + ", by default we will take no action on the update which could lead to inconsistencies in data. Old=" + oldObject + ", New=" + newObject));
    }

    @Override
    @SMConsole
    public DataMgr.Status reinit() {
        this.init();
        return this.getStatus();
    }
}

