/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.helpers.ObjectPool;
import com.avaya.common.logging.client.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.SAXException;

public class ObjectPoolUtils {
    private static final Logger log = AsmLogger.getLogger(ObjectPoolUtils.class);
    public static int POOL_SIZE = 25;
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static ObjectPool<SAXParser> saxParserPool = new ObjectPool("SAXParser");
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static ObjectPool<Transformer> transformerPool = new ObjectPool("Transformer");

    public static void init(int maxPoolSize) {
        POOL_SIZE = maxPoolSize;
        saxParserPool.setMaxPoolSize(maxPoolSize);
        transformerPool.setMaxPoolSize(maxPoolSize);
    }

    public static SAXParser getSAXParser() throws SAXException, ParserConfigurationException {
        try {
            return ObjectPoolUtils.getFromPool();
        }
        catch (SAXParserException e) {
            if (e.saxE != null) {
                throw e.saxE;
            }
            if (e.pcE != null) {
                throw e.pcE;
            }
            return null;
        }
    }

    private static SAXParser getFromPool() throws SAXParserException {
        return saxParserPool.get(new ObjectPool.ObjectAllocator<SAXParser, SAXParserException>(){

            @Override
            public SAXParser allocate() throws SAXParserException {
                try {
                    return saxParserFactory.newSAXParser();
                }
                catch (SAXException e) {
                    SAXParserException e1 = new SAXParserException();
                    e1.saxE = e;
                    throw e1;
                }
                catch (ParserConfigurationException e) {
                    SAXParserException e1 = new SAXParserException();
                    e1.pcE = e;
                    throw e1;
                }
            }
        });
    }

    public static void returnSAXParser(SAXParser parser) {
        saxParserPool.release(parser);
    }

    public static Transformer getXMLTransformer() {
        String fcn_name = "getXMLTransformer";
        Transformer transformer = null;
        try {
            transformer = transformerPool.get(new ObjectPool.ObjectAllocator<Transformer, TransformerConfigurationException>(){

                @Override
                public Transformer allocate() throws TransformerConfigurationException {
                    return transformerFactory.newTransformer();
                }
            });
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"getXMLTransformer: TransformerException caught creating a Transformer", (Throwable)e);
        }
        return transformer;
    }

    public static void returnXMLTransformer(Transformer transformer) {
        transformerPool.release(transformer);
    }

    static class SAXParserException
    extends Exception {
        private static final long serialVersionUID = 7550394448610873170L;
        SAXException saxE = null;
        ParserConfigurationException pcE = null;

        SAXParserException() {
        }
    }
}

