/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.listener.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.ConnectionPoolInitializerException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.listener.cassandra.SchemaChangeNotifier;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SchemaUpdateListener
implements SchemaChangeListener {
    private final Logger log = AsmLogger.getLogger(SchemaUpdateListener.class);
    protected Set<SchemaChangeNotifier> notifiers = new HashSet<SchemaChangeNotifier>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    CassandraBasedDAO cbd;

    public SchemaUpdateListener(CassandraBasedDAO cbd) {
        this.cbd = cbd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerNotifier(SchemaChangeNotifier scn) {
        String fcn_name = "registerNotifier";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("registerNotifier: enter, scn=" + scn + ", notifiers.size=" + this.notifiers.size()));
        }
        this.w.lock();
        try {
            boolean isEmpty = this.notifiers.isEmpty();
            boolean rc = this.notifiers.add(scn);
            if (isFinest) {
                this.log.finest((Object)("registerNotifier: added scn to notifiers, rc=" + rc + ", isEmpty=" + isEmpty));
            }
            if (isEmpty && rc) {
                if (isFinest) {
                    this.log.finest((Object)"registerNotifier: registering this HostStateListener");
                }
                try {
                    this.cbd.checkCluster();
                }
                catch (ConnectionPoolInitializerException | DMException e) {
                    this.log.error((Object)("registerNotifier: checkCluster threw exception, notifiers.size=" + this.notifiers.size()), (Throwable)e);
                }
            }
            if (isFiner) {
                this.log.finer((Object)("registerNotifier: leave, notifiers.size=" + this.notifiers.size()));
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterNotifier(SchemaChangeNotifier scn) {
        String fcn_name = "unregisterNotifier";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("unregisterNotifier: enter, ccn=" + scn + ", notifiers.size=" + this.notifiers.size()));
        }
        this.w.lock();
        try {
            boolean rc = this.notifiers.remove(scn);
            if (isFinest) {
                this.log.finest((Object)("unregisterNotifier: removed ccn from notifiers, rc=" + rc));
            }
            if (isFiner) {
                this.log.finer((Object)("unregisterNotifier: leave, notifiers.size=" + this.notifiers.size()));
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyspaceAdded(KeyspaceMetadata ksMd) {
        String fcn_name = "onKeyspaceAdded";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onKeyspaceAdded: enter, ksMd=" + ksMd));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onKeyspaceAdded: leave, no notifiers");
            }
            return;
        }
        KeyspaceMetaData ksMD = new KeyspaceMetaData(ksMd);
        this.r.lock();
        try {
            for (SchemaChangeNotifier scn : this.notifiers) {
                scn.keyspaceCreated(ksMD);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)"onKeyspaceAdded:leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyspaceChanged(KeyspaceMetadata curKsMd, KeyspaceMetadata prevKsMd) {
        String fcn_name = "onKeyspaceChanged";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onKeyspaceChanged: enter, curKsMd=" + curKsMd + ", prevKsMd=" + prevKsMd));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onKeyspaceChanged: leave, no notifiers");
            }
            return;
        }
        KeyspaceMetaData curKsMD = new KeyspaceMetaData(curKsMd);
        KeyspaceMetaData prevKsMD = new KeyspaceMetaData(prevKsMd);
        this.r.lock();
        try {
            for (SchemaChangeNotifier scn : this.notifiers) {
                scn.keyspaceChanged(curKsMD, prevKsMD);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)"onKeyspaceChanged:leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyspaceRemoved(KeyspaceMetadata ksMd) {
        String fcn_name = "onKeyspaceRemoved";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onKeyspaceRemoved: enter, ksMd=" + ksMd));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onKeyspaceRemoved: leave, no notifiers");
            }
            return;
        }
        KeyspaceMetaData ksMD = new KeyspaceMetaData(ksMd);
        this.r.lock();
        try {
            for (SchemaChangeNotifier scn : this.notifiers) {
                scn.keyspaceDeleted(ksMD);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)"onKeyspaceRemoved:leave");
        }
    }

    public void onRegister(Cluster cluster) {
        String fcn_name = "onRegister";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onRegister: enter, cluster=" + cluster));
        }
        if (isFiner) {
            this.log.finer((Object)"onRegister:leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableAdded(TableMetadata tbMd) {
        String fcn_name = "onTableAdded";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onTableAdded: enter, tbMd=" + tbMd));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onTableAdded: leave, no notifiers");
            }
            return;
        }
        ColumnFamilyMetaData cfMD = new ColumnFamilyMetaData(tbMd);
        this.r.lock();
        try {
            for (SchemaChangeNotifier scn : this.notifiers) {
                scn.columnFamilyCreated(cfMD);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)"onTableAdded:leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableChanged(TableMetadata curTbMd, TableMetadata prevTbMd) {
        String fcn_name = "onTableChanged";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onTableChanged: enter, curTbMd=" + curTbMd + ", prevTbMd=" + prevTbMd));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onTableChanged: leave, no notifiers");
            }
            return;
        }
        ColumnFamilyMetaData curCfMD = new ColumnFamilyMetaData(curTbMd);
        ColumnFamilyMetaData prevCfMD = new ColumnFamilyMetaData(prevTbMd);
        this.r.lock();
        try {
            for (SchemaChangeNotifier scn : this.notifiers) {
                scn.columnFamilyChanged(curCfMD, prevCfMD);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)"onTableChanged:leave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableRemoved(TableMetadata tbMd) {
        String fcn_name = "onTableRemoved";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onTableRemoved: enter, tbMd=" + tbMd));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onTableRemoved: leave, no notifiers");
            }
            return;
        }
        ColumnFamilyMetaData cfMD = new ColumnFamilyMetaData(tbMd);
        this.r.lock();
        try {
            for (SchemaChangeNotifier scn : this.notifiers) {
                scn.columnFamilyDeleted(cfMD);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)"onTableRemoved:leave");
        }
    }

    public void onUnregister(Cluster cluster) {
        String fcn_name = "onUnregister";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onUnregister: enter, cluster=" + cluster));
        }
        if (isFiner) {
            this.log.finer((Object)"onUnregister:leave");
        }
    }

    public void onUserTypeAdded(UserType ut) {
        String fcn_name = "onUserTypeAdded";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onUserTypeAdded: enter, ut=" + ut));
        }
        if (isFiner) {
            this.log.finer((Object)"onUserTypeAdded:leave");
        }
    }

    public void onUserTypeChanged(UserType curUt, UserType prevUt) {
        String fcn_name = "onUserTypeAdded";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onUserTypeAdded: enter, curUt=" + curUt + ", prevUt=" + prevUt));
        }
        if (isFiner) {
            this.log.finer((Object)"onUserTypeAdded:leave");
        }
    }

    public void onUserTypeRemoved(UserType ut) {
        String fcn_name = "onUserTypeRemoved";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onUserTypeRemoved: enter, ut" + ut));
        }
        if (isFiner) {
            this.log.finer((Object)"onUserTypeRemoved:leave");
        }
    }

    public void onAggregateAdded(AggregateMetadata arg0) {
    }

    public void onAggregateChanged(AggregateMetadata arg0, AggregateMetadata arg1) {
    }

    public void onAggregateRemoved(AggregateMetadata arg0) {
    }

    public void onFunctionAdded(FunctionMetadata arg0) {
    }

    public void onFunctionChanged(FunctionMetadata arg0, FunctionMetadata arg1) {
    }

    public void onFunctionRemoved(FunctionMetadata arg0) {
    }

    public void onMaterializedViewAdded(MaterializedViewMetadata arg0) {
    }

    public void onMaterializedViewChanged(MaterializedViewMetadata arg0, MaterializedViewMetadata arg1) {
    }

    public void onMaterializedViewRemoved(MaterializedViewMetadata arg0) {
    }
}

