/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.NameableDBObject;
import java.io.Serializable;

public class EntityLink
implements Serializable,
NameableDBObject {
    private static final long serialVersionUID = 5787987697082455856L;
    protected Long id;
    protected long entity1_id;
    protected long entity2_id;
    protected int listenportentity1;
    protected int listenportentity2;
    protected boolean trusted;
    protected String transportProtocol;
    protected Long isExplicitBiDirectionalId;
    protected boolean denyNewService;
    protected IPAddrFamily ipAddrFamily;

    public EntityLink(Long id, long entity1_id, long entity2_id, int listenportentity1, int listenportentity2, boolean trusted, String ipAddrFamilyStr, String transportProtocol, boolean denyNewService) {
        this.id = id;
        this.entity1_id = entity1_id;
        this.entity2_id = entity2_id;
        this.listenportentity1 = listenportentity1;
        this.listenportentity2 = listenportentity2;
        this.trusted = trusted;
        this.setIPAddrFamily(ipAddrFamilyStr);
        this.transportProtocol = transportProtocol == null ? null : transportProtocol.toUpperCase();
        this.denyNewService = denyNewService;
        this.isExplicitBiDirectionalId = null;
    }

    public EntityLink(Long id, long entity1_id, long entity2_id, int listenportentity1, int listenportentity2, boolean trusted, String transportProtocol, boolean denyNewService) {
        this(id, entity1_id, entity2_id, listenportentity1, listenportentity2, trusted, IPAddrFamily.IPv4.toString(), transportProtocol, denyNewService);
    }

    public EntityLink(EntityLink link) {
        this.id = link.id;
        this.entity1_id = link.entity1_id;
        this.entity2_id = link.entity2_id;
        this.listenportentity1 = link.listenportentity1;
        this.listenportentity2 = link.listenportentity2;
        this.trusted = link.trusted;
        this.transportProtocol = link.transportProtocol == null ? null : link.transportProtocol.toUpperCase();
        this.ipAddrFamily = link.ipAddrFamily;
        this.denyNewService = link.denyNewService;
        this.isExplicitBiDirectionalId = null;
    }

    public long getEntity1_id() {
        return this.entity1_id;
    }

    public void setEntity1_id(long entity1_id) {
        this.entity1_id = entity1_id;
    }

    public long getEntity2_id() {
        return this.entity2_id;
    }

    public void setEntity2_id(long entity2_id) {
        this.entity2_id = entity2_id;
    }

    public int getListenportentity1() {
        return this.listenportentity1;
    }

    public void setListenportentity1(int listenportentity1) {
        this.listenportentity1 = listenportentity1;
    }

    public int getListenportentity2() {
        return this.listenportentity2;
    }

    public void setListenportentity2(int listenportentity2) {
        this.listenportentity2 = listenportentity2;
    }

    public Integer getListenPort(long entityId) {
        if (entityId == this.entity1_id) {
            return this.listenportentity1;
        }
        if (entityId == this.entity2_id) {
            return this.listenportentity2;
        }
        return null;
    }

    public Long getOtherEntity(long entityId) {
        if (entityId == this.entity1_id) {
            return this.entity2_id;
        }
        if (entityId == this.entity2_id) {
            return this.entity1_id;
        }
        return null;
    }

    public Integer getMyListenPort(long entityId) {
        if (entityId == this.entity1_id) {
            return this.listenportentity2;
        }
        if (entityId == this.entity2_id) {
            return this.listenportentity1;
        }
        return null;
    }

    public boolean getTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol == null ? null : transportProtocol.toUpperCase();
    }

    public IPAddrFamily getIPAddrFamily() {
        return this.ipAddrFamily;
    }

    public IPAddress.IPAddressFamily getIPAddressFamily() {
        return this.ipAddrFamily == IPAddrFamily.IPv6 ? IPAddress.IPAddressFamily.IPV6 : IPAddress.IPAddressFamily.IPV4;
    }

    private void setIPAddrFamily(String ipAddrFamilyStr) {
        try {
            this.ipAddrFamily = IPAddrFamily.valueOf(ipAddrFamilyStr);
        }
        catch (Exception e) {
            this.ipAddrFamily = IPAddrFamily.IPv4;
        }
    }

    public Long getExplicitBiDirectionalId() {
        return this.isExplicitBiDirectionalId;
    }

    public void setExplicitBiDirectionalId(Long isExplicitBiDirectionalId) {
        this.isExplicitBiDirectionalId = isExplicitBiDirectionalId;
    }

    public boolean denyNewService() {
        return this.denyNewService;
    }

    public void denyNewService(boolean denyNewService) {
        this.denyNewService = denyNewService;
    }

    public int hashCode() {
        return (int)this.entity1_id + (int)this.entity2_id + this.transportProtocol != null ? this.transportProtocol.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            boolean equal = this.trusted == ((EntityLink)obj).trusted && this.transportProtocol.equals(((EntityLink)obj).transportProtocol) && this.ipAddrFamily == ((EntityLink)obj).ipAddrFamily;
            return equal &= this.entity1_id == ((EntityLink)obj).entity1_id && this.entity2_id == ((EntityLink)obj).entity2_id && this.listenportentity1 == ((EntityLink)obj).listenportentity1 && this.listenportentity2 == ((EntityLink)obj).listenportentity2 || this.entity1_id == ((EntityLink)obj).entity2_id && this.entity2_id == ((EntityLink)obj).entity1_id && this.listenportentity1 == ((EntityLink)obj).listenportentity2 && this.listenportentity2 == ((EntityLink)obj).listenportentity1;
        }
        return false;
    }

    public String toDetailedString() {
        return "Link[entityId1=" + this.entity1_id + ", entityId2=" + this.entity2_id + ", portEntity1=" + this.listenportentity1 + ", portEntity2=" + this.listenportentity2 + ", trusted=" + this.trusted + ", transport=" + this.transportProtocol + ", ipAddrFamily=" + (Object)((Object)this.ipAddrFamily) + ", biDirId=" + this.isExplicitBiDirectionalId + ", deny=" + this.denyNewService + "]";
    }

    public String toString() {
        return this.entity1_id + ":" + this.listenportentity1 + "-" + this.entity2_id + ":" + this.listenportentity2 + "/" + (Object)((Object)this.ipAddrFamily) + "/" + this.transportProtocol;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getTableName() {
        return "entitylink";
    }

    @Override
    public String getFieldName() {
        return "name";
    }

    public static enum IPAddrFamily {
        IPv4,
        IPv6;

    }
}

