/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.sql.Time;
import java.util.Calendar;

public class TimeRange {
    private final boolean includesSunday;
    private final boolean includesMonday;
    private final boolean includesTuesday;
    private final boolean includesWednesday;
    private final boolean includesThursday;
    private final boolean includesFriday;
    private final boolean includesSaturday;
    private final Time startTime;
    private final Time stopTime;

    public TimeRange(boolean includesSunday, boolean includesMonday, boolean includesTuesday, boolean includesWednesday, boolean includesThursday, boolean includesFriday, boolean includesSaturday, Time startTime, Time stopTime) {
        this.includesSunday = includesSunday;
        this.includesMonday = includesMonday;
        this.includesTuesday = includesTuesday;
        this.includesWednesday = includesWednesday;
        this.includesThursday = includesThursday;
        this.includesFriday = includesFriday;
        this.includesSaturday = includesSaturday;
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public Boolean getIncludesDayOfWeek(int day) {
        switch (day) {
            case 1: {
                return this.includesSunday;
            }
            case 2: {
                return this.includesMonday;
            }
            case 3: {
                return this.includesTuesday;
            }
            case 4: {
                return this.includesWednesday;
            }
            case 5: {
                return this.includesThursday;
            }
            case 6: {
                return this.includesFriday;
            }
            case 7: {
                return this.includesSaturday;
            }
        }
        return false;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public Time getStopTime() {
        return this.stopTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includesFriday ? 1231 : 1237);
        result = 31 * result + (this.includesMonday ? 1231 : 1237);
        result = 31 * result + (this.includesSaturday ? 1231 : 1237);
        result = 31 * result + (this.includesSunday ? 1231 : 1237);
        result = 31 * result + (this.includesThursday ? 1231 : 1237);
        result = 31 * result + (this.includesTuesday ? 1231 : 1237);
        result = 31 * result + (this.includesWednesday ? 1231 : 1237);
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.stopTime == null ? 0 : this.stopTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        if (this.includesFriday != other.includesFriday) {
            return false;
        }
        if (this.includesMonday != other.includesMonday) {
            return false;
        }
        if (this.includesSaturday != other.includesSaturday) {
            return false;
        }
        if (this.includesSunday != other.includesSunday) {
            return false;
        }
        if (this.includesThursday != other.includesThursday) {
            return false;
        }
        if (this.includesTuesday != other.includesTuesday) {
            return false;
        }
        if (this.includesWednesday != other.includesWednesday) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        return !(this.stopTime == null ? other.stopTime != null : !this.stopTime.equals(other.stopTime));
    }

    public String toString() {
        Calendar utc = Calendar.getInstance();
        Time newStartTime = new Time(this.startTime.getTime() - (long)utc.get(15) - (long)utc.get(16));
        Time newStopTime = new Time(this.stopTime.getTime() - (long)utc.get(15) - (long)utc.get(16));
        return "TimeRange[includesSunday: '" + this.includesSunday + "', includesMonday: '" + this.includesMonday + "', includesTuesday: '" + this.includesTuesday + "', includesWednesday: '" + this.includesWednesday + "', includesThursday: '" + this.includesThursday + "', includesFriday: '" + this.includesFriday + "', includesSaturday: '" + this.includesSaturday + "', startTime: '" + newStartTime + "', stopTime: '" + newStopTime + "']";
    }
}

