/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.helpers.StringArrayBytes;
import java.io.Serializable;
import java.util.Arrays;

public class User
implements Serializable {
    private static final long serialVersionUID = 3388891661598369832L;
    private long id;
    private long defaultContactListId;
    private long defaultCommprofileSetId;
    private byte[] stringData;

    public User(long id) {
        this.id = id;
        String[] strArray = new String[StringIndex.values().length];
        strArray[StringIndex.LOGINNAME.ordinal()] = "";
        strArray[StringIndex.PASSWORD.ordinal()] = "";
        strArray[StringIndex.DISPLAYNAME.ordinal()] = "";
        strArray[StringIndex.DISPLAYNAMEASCII.ordinal()] = "";
        strArray[StringIndex.GIVENNAME.ordinal()] = "";
        strArray[StringIndex.GIVENNAMEASCII.ordinal()] = "";
        strArray[StringIndex.SURNAME.ordinal()] = "";
        strArray[StringIndex.SURNAMEASCII.ordinal()] = "";
        strArray[StringIndex.PREFERREDLANGUAGE.ordinal()] = "";
        this.stringData = StringArrayBytes.encode(strArray);
    }

    public User(User user) {
        this.id = user.id;
        String[] strArray = new String[StringIndex.values().length];
        strArray[StringIndex.LOGINNAME.ordinal()] = user.getLoginName();
        strArray[StringIndex.PASSWORD.ordinal()] = user.getPassword();
        strArray[StringIndex.DISPLAYNAME.ordinal()] = user.getDisplayName();
        strArray[StringIndex.DISPLAYNAMEASCII.ordinal()] = user.getDisplayNameAscii();
        strArray[StringIndex.GIVENNAME.ordinal()] = user.getGivenName();
        strArray[StringIndex.GIVENNAMEASCII.ordinal()] = user.getGivenNameAscii();
        strArray[StringIndex.SURNAME.ordinal()] = user.getSurname();
        strArray[StringIndex.SURNAMEASCII.ordinal()] = user.getSurnameAscii();
        strArray[StringIndex.PREFERREDLANGUAGE.ordinal()] = user.getPreferredLanguage();
        this.stringData = StringArrayBytes.encode(strArray);
    }

    public User(long id, String loginName, String password, String displayName, String displayNameAscii, String givenName, String givenNameAscii, String surname, String surnameAscii, String preferredLanguage, long defaultContactListId, long defaultCommprofileSetId) {
        this.id = id;
        this.defaultContactListId = defaultContactListId;
        this.defaultCommprofileSetId = defaultCommprofileSetId;
        String[] strArray = new String[StringIndex.values().length];
        strArray[StringIndex.LOGINNAME.ordinal()] = loginName;
        strArray[StringIndex.PASSWORD.ordinal()] = password;
        strArray[StringIndex.DISPLAYNAME.ordinal()] = displayName;
        strArray[StringIndex.DISPLAYNAMEASCII.ordinal()] = displayNameAscii;
        strArray[StringIndex.GIVENNAME.ordinal()] = givenName;
        strArray[StringIndex.GIVENNAMEASCII.ordinal()] = givenNameAscii;
        strArray[StringIndex.SURNAME.ordinal()] = surname;
        strArray[StringIndex.SURNAMEASCII.ordinal()] = surnameAscii;
        strArray[StringIndex.PREFERREDLANGUAGE.ordinal()] = preferredLanguage;
        this.stringData = StringArrayBytes.encode(strArray);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLoginName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.LOGINNAME.ordinal());
    }

    public void setLoginName(String loginname) {
        this.stringData = StringArrayBytes.setString(this.stringData, loginname, StringIndex.LOGINNAME.ordinal());
    }

    public String getPassword() {
        return StringArrayBytes.getString(this.stringData, StringIndex.PASSWORD.ordinal());
    }

    public long getDefaultContactListId() {
        return this.defaultContactListId;
    }

    public long getDefaultCommProfileSetId() {
        return this.defaultCommprofileSetId;
    }

    public String getDisplayName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.DISPLAYNAME.ordinal());
    }

    public void setDisplayName(String displayName) {
        this.stringData = StringArrayBytes.setString(this.stringData, displayName, StringIndex.DISPLAYNAME.ordinal());
    }

    public String getDisplayNameAscii() {
        return StringArrayBytes.getString(this.stringData, StringIndex.DISPLAYNAMEASCII.ordinal());
    }

    public void setDisplayNameAscii(String displaynameascii) {
        this.stringData = StringArrayBytes.setString(this.stringData, displaynameascii, StringIndex.DISPLAYNAMEASCII.ordinal());
    }

    public String getGivenName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.GIVENNAME.ordinal());
    }

    public void setGivenName(String givenName) {
        this.stringData = StringArrayBytes.setString(this.stringData, givenName, StringIndex.GIVENNAME.ordinal());
    }

    public String getGivenNameAscii() {
        return StringArrayBytes.getString(this.stringData, StringIndex.GIVENNAMEASCII.ordinal());
    }

    public void setGivenNameAscii(String givenNameAscii) {
        this.stringData = StringArrayBytes.setString(this.stringData, givenNameAscii, StringIndex.GIVENNAMEASCII.ordinal());
    }

    public String getSurname() {
        return StringArrayBytes.getString(this.stringData, StringIndex.SURNAME.ordinal());
    }

    public void setSurname(String surname) {
        this.stringData = StringArrayBytes.setString(this.stringData, surname, StringIndex.SURNAME.ordinal());
    }

    public String getSurnameAscii() {
        return StringArrayBytes.getString(this.stringData, StringIndex.SURNAMEASCII.ordinal());
    }

    public void setSurnameAscii(String surnameAscii) {
        this.stringData = StringArrayBytes.setString(this.stringData, surnameAscii, StringIndex.SURNAMEASCII.ordinal());
    }

    public String getPreferredLanguage() {
        return StringArrayBytes.getString(this.stringData, StringIndex.PREFERREDLANGUAGE.ordinal());
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.stringData = StringArrayBytes.setString(this.stringData, preferredLanguage, StringIndex.PREFERREDLANGUAGE.ordinal());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.defaultCommprofileSetId ^ this.defaultCommprofileSetId >>> 32);
        result = 31 * result + (int)(this.defaultContactListId ^ this.defaultContactListId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + Arrays.hashCode(this.stringData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.defaultCommprofileSetId != other.defaultCommprofileSetId) {
            return false;
        }
        if (this.defaultContactListId != other.defaultContactListId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return Arrays.equals(this.stringData, other.stringData);
    }

    public String toString() {
        return "CsUser[id=" + this.id + ", loginName=" + this.getLoginName() + ", password=" + this.getPassword() + ", defaultContactListId=" + this.defaultContactListId + ", defaultCommprofileSetId=" + this.defaultCommprofileSetId + ", displayName=" + this.getDisplayName() + ", displayNameAscii=" + this.getDisplayNameAscii() + ", givenName=" + this.getGivenName() + ", givenNameAscii=" + this.getGivenNameAscii() + ", surname=" + this.getSurname() + ", surnameAscii=" + this.getSurnameAscii() + ", preferredlanguage=" + this.getPreferredLanguage() + "]";
    }

    private static enum StringIndex {
        LOGINNAME,
        PASSWORD,
        DISPLAYNAME,
        DISPLAYNAMEASCII,
        GIVENNAME,
        GIVENNAMEASCII,
        SURNAME,
        SURNAMEASCII,
        PREFERREDLANGUAGE;

    }
}

