/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.ppm.mega.model;

import com.avaya.asm.ppm.mega.common.MegaPPMUtils;
import com.avaya.asm.ppm.mega.model.DeviceDataList;
import com.avaya.asm.ppm.mega.model.VolumeSettings;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceDataByMacAddress
implements Serializable {
    private static final long serialVersionUID = -4581795223144862254L;
    private ArrayList<DeviceDataList> deviceDataList = null;
    private VolumeSettings deviceVolumeSettings = null;
    private String macAddress = null;
    private String timestamp = null;
    @JsonIgnore
    private Long timestampAsEpochMS;

    public DeviceDataByMacAddress() {
    }

    public DeviceDataByMacAddress(ArrayList<DeviceDataList> deviceDataList, VolumeSettings deviceVolumeSettings, String macAddress, String timestamp) {
        this.deviceDataList = deviceDataList;
        this.deviceVolumeSettings = deviceVolumeSettings;
        this.macAddress = macAddress;
        this.timestamp = timestamp;
    }

    public ArrayList<DeviceDataList> getDeviceDataList() {
        return this.deviceDataList;
    }

    public void setDeviceDataList(ArrayList<DeviceDataList> deviceDataList) {
        this.deviceDataList = deviceDataList;
    }

    public VolumeSettings getDeviceVolumeSettings() {
        return this.deviceVolumeSettings;
    }

    public void setDeviceVolumeSettings(VolumeSettings deviceVolumeSettings) {
        this.deviceVolumeSettings = deviceVolumeSettings;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        Long translatedToEpoch = MegaPPMUtils.posixTimeToEpochMS(timestamp);
        this.timestampAsEpochMS = translatedToEpoch == null ? Long.valueOf(0L) : translatedToEpoch;
    }

    public long getTimestampAsEpochMS() {
        return this.timestampAsEpochMS;
    }

    public void setTimestampAsEpochMS(long timestampAsEpochMS) {
        this.timestampAsEpochMS = timestampAsEpochMS;
        this.timestamp = MegaPPMUtils.epochTimestampToPosix(timestampAsEpochMS);
    }

    public String toString() {
        return "DeviceDataByMacAddress [deviceDataList=" + this.deviceDataList + ", deviceVolumeSettings=" + this.deviceVolumeSettings + ", macAddress=" + this.macAddress + ", timestamp=" + this.timestamp + ", timestampAsEpochMS=" + this.timestampAsEpochMS + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deviceDataList == null ? 0 : this.deviceDataList.hashCode());
        result = 31 * result + (this.deviceVolumeSettings == null ? 0 : this.deviceVolumeSettings.hashCode());
        result = 31 * result + (this.macAddress == null ? 0 : this.macAddress.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (int)(this.timestampAsEpochMS ^ this.timestampAsEpochMS >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceDataByMacAddress other = (DeviceDataByMacAddress)obj;
        if (this.deviceDataList == null ? other.deviceDataList != null : !this.deviceDataList.equals(other.deviceDataList)) {
            return false;
        }
        if (this.deviceVolumeSettings == null ? other.deviceVolumeSettings != null : !this.deviceVolumeSettings.equals(other.deviceVolumeSettings)) {
            return false;
        }
        if (this.macAddress == null ? other.macAddress != null : !this.macAddress.equals(other.macAddress)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return this.timestampAsEpochMS == other.timestampAsEpochMS;
    }
}

