/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.ReadWriteLockHandler;
import com.avaya.common.logging.client.Logger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CassandraClientProperties {
    private static final String CIPHER_SUITE_PROPNAME = "cipher_suite";
    private static final String SSL_ENABLED_PROPNAME = "ssl_enabled";
    private final Logger log = AsmLogger.getLogger(this.getClass());
    protected static final String sysPropertyFilePath = "avaya.cassandra.client.properties.path";
    private Properties properties = new Properties();
    private static volatile CassandraClientProperties instance = null;
    private static volatile Object mutex = new Object();
    ReadWriteLockHandler rwLockHdlr = new ReadWriteLockHandler(this.getClass().getSimpleName());

    private CassandraClientProperties() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CassandraClientProperties getInstance() {
        CassandraClientProperties tmp = instance;
        if (tmp == null) {
            Object object = mutex;
            synchronized (object) {
                tmp = instance;
                if (tmp == null) {
                    instance = tmp = new CassandraClientProperties();
                }
            }
        }
        return tmp;
    }

    public void init() {
        String filePath = System.getProperty(sysPropertyFilePath);
        if (filePath != null) {
            this.loadPropertiesFromFile(filePath);
        }
    }

    private void loadPropertiesFromFile(String filePath) {
        this.rwLockHdlr.acquireWriteLock();
        try {
            this.loadPropertiesFromFileLocked(filePath);
        }
        finally {
            this.rwLockHdlr.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFromFileLocked(String filePath) {
        String fcn_name = "loadPropertiesFromFile";
        this.properties.clear();
        FileInputStream input = null;
        try {
            input = new FileInputStream(filePath);
            this.properties.load(input);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("loadPropertiesFromFile: exception " + e.getCause().getClass() + " caught, filePath=" + filePath), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)("loadPropertiesFromFile: exception " + e.getCause().getClass() + " caught, filePath=" + filePath), (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    this.log.error((Object)("loadPropertiesFromFile: exception " + e.getCause().getClass() + " caught, closing file " + filePath), (Throwable)e);
                }
            }
        }
    }

    public String[] getCipherSuite() {
        String value = this.getPropertyValue(CIPHER_SUITE_PROPNAME);
        if (value == null) {
            return null;
        }
        String[] ciphers = value.split("[,\\s]+");
        return ciphers;
    }

    public Boolean isSslEnabled() {
        String value = this.getPropertyValue(SSL_ENABLED_PROPNAME);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private String getPropertyValue(String propName) {
        String value = null;
        this.rwLockHdlr.acquireReadLock();
        try {
            value = this.properties.getProperty(propName);
        }
        finally {
            this.rwLockHdlr.releaseReadLock();
        }
        return value;
    }

    public static String getSysPropertyFilePath() {
        return sysPropertyFilePath;
    }
}

