/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmSettings;

public abstract class PollingAlarm
extends GenericAlarm {
    public abstract long getPreAlarm_RetryInterval();

    public abstract long getPostAlarm_RetryInterval();

    public abstract int getPreAlarm_MaxRetryCount();

    @Override
    public long getTimerInterval() {
        if (AsmSettings.getAlarmImmediately()) {
            return 1000L;
        }
        if (this.isAtWarningThreshold()) {
            return this.getPreAlarm_RetryInterval();
        }
        return this.getPostAlarm_RetryInterval();
    }

    @Override
    public boolean isAtWarningThreshold() {
        int maxRetries;
        int n = maxRetries = junitAlarmCount == -1 ? this.getPreAlarm_MaxRetryCount() : junitAlarmCount;
        if (AsmSettings.getAlarmImmediately()) {
            maxRetries = 1;
        }
        return this.timerFireCount < maxRetries;
    }

    @Override
    public boolean isAtAlarmThreshold() {
        int maxRetries;
        int n = maxRetries = junitAlarmCount == -1 ? this.getPreAlarm_MaxRetryCount() : junitAlarmCount;
        if (AsmSettings.getAlarmImmediately()) {
            maxRetries = 1;
        }
        return this.timerFireCount == maxRetries;
    }

    @Override
    public boolean canClearAlarm() {
        int maxRetries;
        int n = maxRetries = junitAlarmCount == -1 ? this.getPreAlarm_MaxRetryCount() : junitAlarmCount;
        if (AsmSettings.getAlarmImmediately()) {
            maxRetries = 1;
        }
        GenericAlarmRecoveryIntf obj = this.getFailedObj();
        if (log.isFinestEnabled()) {
            log.finest((Object)("canClearAlarm: Checking if we can clear the alarm: " + obj + " " + this.getClass().getSimpleName()));
        }
        if (obj == null) {
            return true;
        }
        if (this.timerFireCount < maxRetries) {
            return obj.preAlarmAttemptRecovery(this);
        }
        return obj.postAlarmAttemptRecovery(this);
    }

    @Override
    public void timerFired() {
    }

    @Override
    public int getMaxFailuresAllowed() {
        return -1;
    }
}

