/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class AsmCommon {
    private static final Logger log = AsmLogger.getLogger(AsmCommon.class);
    public static final boolean jUnitEnvironment = !new File("/opt/Avaya/install.properties").exists();

    @Deprecated
    public static boolean isDottedIpAddress(String fqdnoripaddr) {
        return AsmCommon.isDottedIpAddress(fqdnoripaddr, false);
    }

    @Deprecated
    public static boolean isDottedIpAddress(String fqdnoripaddr, boolean ignoreTrailingCharacters) {
        char[] chars = fqdnoripaddr.toCharArray();
        int digs = 0;
        int octet = 0;
        int dots = 0;
        for (char c : chars) {
            if (c >= '0' && c <= '9') {
                ++digs;
                octet = octet * 10 + (c - 48);
                continue;
            }
            if (c == '.') {
                if (digs == 0 || octet > 255) {
                    return false;
                }
                digs = 0;
                octet = 0;
                if (++dots <= 3) continue;
                return false;
            }
            return ignoreTrailingCharacters && digs != 0 && octet < 255 && dots == 3;
        }
        return digs != 0 && octet <= 255 && dots == 3;
    }

    public static List<String> realDNSResolve(String fqdn) throws UnknownHostException {
        InetAddress[] addresses;
        ArrayList<String> results = new ArrayList<String>();
        for (InetAddress iNetAddress : addresses = InetAddress.getAllByName(fqdn)) {
            results.add(iNetAddress.getHostAddress());
        }
        return results;
    }

    public static String charToEscaped(String src) {
        String dest = "";
        int n = src.length();
        block12: for (int i = 0; i < n; ++i) {
            char c = src.charAt(i);
            switch (c) {
                case ';': {
                    dest = dest + "%3B";
                    continue block12;
                }
                case '/': {
                    dest = dest + "%2F";
                    continue block12;
                }
                case ':': {
                    dest = dest + "%3A";
                    continue block12;
                }
                case '@': {
                    dest = dest + "%40";
                    continue block12;
                }
                case '&': {
                    dest = dest + "%26";
                    continue block12;
                }
                case '=': {
                    dest = dest + "%3D";
                    continue block12;
                }
                case '+': {
                    dest = dest + "%2B";
                    continue block12;
                }
                case '$': {
                    dest = dest + "%24";
                    continue block12;
                }
                case '#': {
                    dest = dest + "%23";
                    continue block12;
                }
                case ',': {
                    dest = dest + "%2C";
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        char ac = c;
                        String temp = String.format("%02x", ac);
                        dest = dest + "%" + temp;
                        continue block12;
                    }
                    dest = dest + c;
                }
            }
        }
        return dest;
    }

    public static String versionToString(Double version) {
        StringBuffer v = new StringBuffer("unspecified");
        if (version == null || version <= 0.0) {
            return v.toString();
        }
        try {
            v = new StringBuffer(version.toString());
            for (int i = 0; i < 3; ++i) {
                v.insert(v.lastIndexOf(".") + 3, ".");
            }
            String[] subStrs = v.toString().split("\\.");
            v.setLength(0);
            for (int i = 0; i < subStrs.length - 1; ++i) {
                v.append(Long.parseLong(subStrs[i]) + ".");
            }
            String buildNum = subStrs[subStrs.length - 1];
            if (!buildNum.startsWith("0")) {
                v.append(buildNum);
            } else if (version <= 6.02) {
                Double ver = Double.parseDouble("0." + buildNum) * 100000.0;
                v.append(ver.intValue());
            } else {
                Double ver = Double.parseDouble("0." + buildNum) * 1000000.0;
                v.append(ver.intValue());
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to parse ASM version number to string", (Throwable)e);
            return "unspecified";
        }
        return v.toString();
    }

    public static long getUsedMemory() {
        Runtime.getRuntime().gc();
        Long total = Runtime.getRuntime().totalMemory();
        Long free = Runtime.getRuntime().freeMemory();
        return total - free;
    }
}

