/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.sip.Address;

public class FeatureTags {
    protected Map<String, String> featTagMap = new HashMap<String, String>();

    public FeatureTags(Address contact, List<String> excludeList) {
        Set params = contact.getParameters();
        for (Map.Entry param : params) {
            String tag = (String)param.getKey();
            if (this.containsIgnoreCase(excludeList, tag)) continue;
            this.featTagMap.put(tag, (String)param.getValue());
        }
    }

    public FeatureTags(String featTagString) {
        if (featTagString != null && !featTagString.isEmpty()) {
            String[] tags;
            for (String tag : tags = featTagString.split("\n")) {
                String value;
                String name;
                int index = tag.indexOf(61);
                if (index >= 0) {
                    name = tag.substring(0, index);
                    value = tag.substring(index + 1);
                } else {
                    name = tag;
                    value = "";
                }
                this.featTagMap.put(name, value);
            }
        }
    }

    protected boolean containsIgnoreCase(List<String> list, String value) {
        if (list != null) {
            for (String s : list) {
                if (!s.equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    public String getTag(String tag) {
        return this.featTagMap.get(tag);
    }

    public Map<String, String> getFeatureTagsMap() {
        return this.featTagMap;
    }

    public String toFeatureTagsString() {
        if (this.featTagMap == null || this.featTagMap.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : this.featTagMap.entrySet()) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(entry.getKey());
            String value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            buf.append("=");
            buf.append(value);
        }
        return buf.toString();
    }

    public boolean containsFeatTagValue(String tag, String value) {
        String tagVal = this.featTagMap.get(tag);
        return tagVal != null && (tagVal.equals(value) || tagVal.startsWith(value + ",") || tagVal.contains("," + value + ",") || tagVal.endsWith("," + value));
    }

    public void addFeatureTags(Address contact) {
        for (Map.Entry<String, String> entry : this.featTagMap.entrySet()) {
            contact.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeatureTags) {
            FeatureTags otherFeatureTags = (FeatureTags)obj;
            return this.featTagMap.equals(otherFeatureTags.featTagMap);
        }
        return false;
    }

    public int hashCode() {
        return this.featTagMap.hashCode();
    }

    public String toString() {
        return this.featTagMap.toString();
    }
}

