/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core.exceptions;

import com.avaya.asm.core.exceptions.ExceptionParameters;
import com.avaya.asm.datamgr.objectapi.SIPEntity;

public class MissingEntityLinkException
extends Exception
implements ExceptionParameters {
    private static final long serialVersionUID = -7055218909205729825L;
    private Long fromId = null;
    private String fromName = null;
    private Long toId = null;
    private String toName = null;

    public MissingEntityLinkException(String msg, SIPEntity fromSE, SIPEntity toSE) {
        super(msg);
        if (fromSE != null) {
            this.fromId = fromSE.getId();
            this.fromName = fromSE.getName();
        }
        if (toSE != null) {
            this.toId = toSE.getId();
            this.toName = toSE.getName();
        }
    }

    public Long getFromId() {
        return this.fromId;
    }

    public String getFromName() {
        return this.fromName;
    }

    public Long getToId() {
        return this.toId;
    }

    public String getToName() {
        return this.toName;
    }

    @Override
    public String getExtraEventKeyParams() {
        return this.fromId + "_" + this.toId;
    }
}

