/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.PushNotificationAPI;
import com.avaya.asm.datamgr.dao.cassandra.BucketRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.PushNotificationDAO;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.objectapi.PushNotificationClientInstance;
import com.avaya.common.logging.client.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushNotificationDM
implements PushNotificationAPI {
    private final Logger log = AsmLogger.getLogger(PushNotificationDM.class);
    private CassandraDAOFactory<PushNotificationDAO> pushNotificationDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;

    public PushNotificationDM() {
        CassandraConnectionInfo cConnInfo;
        this.cConnInfo = cConnInfo = new CassandraConnectionInfo(UstoreDAOFactory.DFLT_HOST, UstoreDAOFactory.DFLT_CQL_PORT, UstoreDAOFactory.DFLT_JMX_PORT, null, CassandraConnectionInfo.ConnectionManagementPolicy.LOCAL_HOST_DC_ROUND_ROBIN);
    }

    public PushNotificationDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    public BucketRangeIterator newBucketRangeIterator(List<InetAddress> downNodes) {
        String fcn_name = "newBucketRangeIterator";
        PushNotificationDAO pushNotificationDAO = null;
        BucketRangeIterator bucketRangeIterator = null;
        try {
            pushNotificationDAO = this.getPushNotificationDAO();
            bucketRangeIterator = pushNotificationDAO.newBucketRangeIterator(downNodes);
        }
        catch (DMException | UnknownHostException e) {
            e.printStackTrace();
            this.log.error((Object)"newBucketRangeIterator Error while creating BucketRangeIterator!");
        }
        return bucketRangeIterator;
    }

    protected PushNotificationDAO getPushNotificationDAO() throws DMException {
        String fcn_name = "getPushNotificationDAO";
        PushNotificationDAO dao = this.pushNotificationDAOFactory.getDAOInstance(this.cConnInfo, PushNotificationDAO.class);
        if (dao == null) {
            String msg = "getPushNotificationDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }

    @Override
    public PushNotificationClientInstance getPushNotification(long commProfileSetId, String sipInstanceId) throws DMException {
        String fcn_name = "getPushNotification";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        PushNotificationClientInstance pushNotificationClientInstance = null;
        if (isFiner) {
            this.log.finer((Object)("getPushNotification: enter with commProfileSetId=" + commProfileSetId + ", sipInstanceId=" + sipInstanceId));
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (commProfileSetId < 0L || sipInstanceId == null) {
            this.log.error((Object)("getPushNotification Illegal argument passed commProfileSetId=" + commProfileSetId + " and sipInstanceId=" + sipInstanceId));
            throw new IllegalArgumentException("getPushNotification commProfileSetId: " + commProfileSetId + " and sipInstanceId: " + sipInstanceId);
        }
        pushNotificationClientInstance = pushNotificationDAO.getPushNotification(commProfileSetId, sipInstanceId);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getPushNotification" + (endTime - startTime)));
        }
        return pushNotificationClientInstance;
    }

    @Override
    public List<PushNotificationClientInstance> getAllPushNotification(long commProfileSetId) throws DMException {
        String fcn_name = "getAllPushNotification";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        List<PushNotificationClientInstance> pushNotificationClientInstance = null;
        if (isFiner) {
            this.log.finer((Object)("getAllPushNotification: enter with commProfileSetId=" + commProfileSetId));
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (commProfileSetId < 0L) {
            this.log.error((Object)("getAllPushNotification: Illegal argument passed commProfileSetId=" + commProfileSetId));
            throw new IllegalArgumentException("getAllPushNotification: commProfileSetId: " + commProfileSetId);
        }
        pushNotificationClientInstance = pushNotificationDAO.getAllPushNotification(commProfileSetId);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getAllPushNotification" + (endTime - startTime)));
        }
        return pushNotificationClientInstance;
    }

    @Override
    public void setPushNotification(PushNotificationClientInstance pushNotificationInstance) throws DMException {
        String fcn_name = "setPushNotification";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("setPushNotification: enter with pushNotificationInstance=" + pushNotificationInstance));
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (pushNotificationInstance == null) {
            this.log.error((Object)("setPushNotification: Illegal argument passed pushNotificationInstance=" + pushNotificationInstance));
            throw new IllegalArgumentException("setPushNotification: pushNotificationInstance:" + pushNotificationInstance);
        }
        pushNotificationDAO.setPushNotification(pushNotificationInstance);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("setPushNotification" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("setPushNotification: Leave after inserting/updating pushNotificationInstance=" + pushNotificationInstance));
        }
    }

    @Override
    public void deletePushNotification(long commProfileSetId, String sipInstanceId) throws DMException {
        String fcn_name = "deletePushNotification";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("deletePushNotification: enter with commProfileSetId=" + commProfileSetId + ", sipInstanceId=" + sipInstanceId));
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (commProfileSetId < 0L || sipInstanceId == null) {
            this.log.error((Object)("deletePushNotification: Illegal argument passed commProfileSetId=" + commProfileSetId + " and sipInstanceId=" + sipInstanceId));
            throw new IllegalArgumentException("deletePushNotification: commProfileSetId: " + commProfileSetId + " and sipInstanceId: " + sipInstanceId);
        }
        pushNotificationDAO.deletePushNotification(commProfileSetId, sipInstanceId);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("deletePushNotification" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("deletePushNotification: leave after deleting pushnotification with commProfileSetId=" + commProfileSetId + ", sipInstanceId=" + sipInstanceId));
        }
    }

    @Override
    public void deleteAllPushNotification(long commProfileSetId) throws DMException {
        String fcn_name = "deleteAllPushNotification";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("deleteAllPushNotification: enter with commProfileSetId=" + commProfileSetId));
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (commProfileSetId < 0L) {
            this.log.error((Object)("deleteAllPushNotification: Illegal argument passed commProfileSetId=" + commProfileSetId));
            throw new IllegalArgumentException("deleteAllPushNotification: commProfileSetId: " + commProfileSetId);
        }
        pushNotificationDAO.deleteAllPushNotification(commProfileSetId);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("deleteAllPushNotification" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("deleteAllPushNotification: Leave after deleting all push notification with commProfileSetId=" + commProfileSetId));
        }
    }

    @Override
    public List<PushNotificationClientInstance> getAllLocalPushNotification(List localCommProfileSetIds) throws DMException {
        String fcn_name = "getAllLocalPushNotification";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        List<PushNotificationClientInstance> pushNotificationClientInstanceList = null;
        if (isFiner) {
            this.log.finer((Object)"getAllLocalPushNotification: enter ");
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (localCommProfileSetIds == null) {
            this.log.error((Object)("getAllLocalPushNotification: Illegal argument passed localCommProfileSetIds=" + localCommProfileSetIds));
            throw new IllegalArgumentException("getAllLocalPushNotification: localCommProfileSetIds: " + localCommProfileSetIds);
        }
        pushNotificationClientInstanceList = pushNotificationDAO.getAllLocalPushNotification(localCommProfileSetIds);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getAllLocalPushNotification" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("getAllLocalPushNotification Leave with List pushNotificationClientInstance=" + pushNotificationClientInstanceList));
        }
        return pushNotificationClientInstanceList;
    }

    @Override
    public List<PushNotificationClientInstance> getAllLocalPushNotificationByBucket(List<Long> localCommprofileSetIds) throws DMException {
        String fcn_name = "getAllLocalPushNotificationByBucket";
        HashMap<Integer, ArrayList<Long>> mapByBucketId = new HashMap<Integer, ArrayList<Long>>();
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        ArrayList<PushNotificationClientInstance> pushNotificationList = new ArrayList<PushNotificationClientInstance>();
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFiner) {
            this.log.finer((Object)("getAllLocalPushNotificationByBucket: enter with localCommprofileSetIds=" + localCommprofileSetIds));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (localCommprofileSetIds == null) {
            return null;
        }
        for (Long l : localCommprofileSetIds) {
            int bucketId = PushNotificationDAO.findBucketByCommProfileSetId(l);
            ArrayList<Long> commProfileSetIdList = (ArrayList<Long>)mapByBucketId.get(bucketId);
            if (commProfileSetIdList == null) {
                commProfileSetIdList = new ArrayList<Long>();
                commProfileSetIdList.add(l);
                mapByBucketId.put(bucketId, commProfileSetIdList);
            } else {
                commProfileSetIdList.add(l);
            }
            mapByBucketId.put(bucketId, commProfileSetIdList);
        }
        for (Map.Entry entry : mapByBucketId.entrySet()) {
            List<PushNotificationClientInstance> pushnotifications = pushNotificationDAO.getAllPushNotificationByBucket(entry.getKey(), (List)entry.getValue());
            pushNotificationList.addAll(pushnotifications);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getAllLocalPushNotificationByBucket: getAllLocalPushNotification took " + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("getAllLocalPushNotificationByBucket: Leave: with pushNotificationList of size=" + pushNotificationList.size()));
        }
        return pushNotificationList;
    }

    @Override
    public void getCommProfileSetIdsByLocalBucket(List<InetAddress> downNodes, Collection<Long> commProfileSetIds) throws DMException {
        BucketRangeIterator bucketRangeIterator;
        String fcn_name = "getCommProfileSetIdsByLocalBucket";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        Integer next = null;
        if (isFiner) {
            this.log.finer((Object)"getCommProfileSetIdsByLocalBucket: enter ");
        }
        PushNotificationDAO pushNotificationDAO = this.getPushNotificationDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if ((bucketRangeIterator = this.newBucketRangeIterator(downNodes)) != null) {
            next = bucketRangeIterator.getNext();
        }
        while (next != null) {
            pushNotificationDAO.getCommProfileSetIdByLocalBucket(next, commProfileSetIds);
            next = bucketRangeIterator.getNext();
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getCommProfileSetIdsByLocalBucket" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("getCommProfileSetIdsByLocalBucket Leave with List commProfileSetids=" + commProfileSetIds.size()));
        }
    }
}

