/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.SMInfoDM;
import com.avaya.asm.datamgr.dynamic.DynamicDataMgr;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.TimeEvictionCache;
import com.avaya.ustore.objectapi.SMInfo;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class SMSMInfoDM
extends DynamicDataMgr {
    private static TimeEvictionCache<ArrayList<SMInfo>> timeEvictionCache = new TimeEvictionCache(TimeUnit.MINUTES.toMillis(5L));
    private final Logger log = AsmLogger.getLogger(SMSMInfoDM.class);
    SMInfoDM smInfoDM = new SMInfoDM();

    public void setSMInfo(SMInfo smInfo) throws DMException {
        this.smInfoDM.setSMInfo(smInfo);
    }

    public SMInfo getSMInfo(long asmInstId) throws DMException {
        return this.smInfoDM.getSMInfo(asmInstId);
    }

    public ArrayList<SMInfo> getCachedSMInfos() throws DMException {
        String fcn_name = "getCachedSMInfos";
        boolean isFinest = this.log.isFinestEnabled();
        ArrayList<SMInfo> smInfos = new ArrayList<SMInfo>();
        boolean stale = timeEvictionCache.isStale();
        if (!stale) {
            if (isFinest) {
                this.log.finest((Object)"getCachedSMInfos: Leave with previous collection of smInfos, as it is not stale");
            }
            return timeEvictionCache.getCachedData();
        }
        this.getAllSMInfo(smInfos);
        return smInfos;
    }

    public void getAllSMInfo(ArrayList<SMInfo> smInfos) throws DMException {
        this.smInfoDM.getAllSMInfo(smInfos);
        timeEvictionCache.setCachedData(smInfos);
    }

    public void deleteSMInfo(long asmInstId) throws DMException {
        this.smInfoDM.deleteSMInfo(asmInstId);
    }

    @Override
    public void init() {
        this.setStatus(DataMgr.Status.OKAY);
    }
}

