/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AppSetPattern;
import com.avaya.asm.datamgr.objectapi.DigitTree;
import com.avaya.asm.datamgr.objectapi.DigitTreeNodeMatcher;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppSetPatternDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(AppSetPatternDAO.class);
    private Map<Long, AppSetPattern> appSetPatternMap = new HashMap<Long, AppSetPattern>();
    private Map<Long, DigitTree<AppSetPattern>> treeMap = new HashMap<Long, DigitTree<AppSetPattern>>();
    public static final String getAppSetPatterns = "SELECT id, digitpattern, mindigits, maxdigits, csdomain_id, origappset_id, termappset_id, zr_template_id, emer_origappset_id, emer_termappset_id FROM asmpatterntoappset";
    public static final String getAppSetPatternById = "SELECT id, digitpattern, mindigits, maxdigits, csdomain_id, origappset_id, termappset_id, zr_template_id, emer_origappset_id, emer_termappset_id FROM asmpatterntoappset WHERE id = ?";
    private static final ResultSetMapper appSetPatternMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AppSetPattern> map = new HashMap<Long, AppSetPattern>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                Long domainId = rs.getLong("csdomain_id");
                if (domainId == 0L) {
                    domainId = null;
                }
                map.put(id, new AppSetPattern(id, rs.getString("digitpattern"), rs.getInt("mindigits"), rs.getInt("maxdigits"), domainId, rs.getLong("origappset_id"), rs.getLong("termappset_id"), (Long)rs.getObject("zr_template_id"), rs.getLong("emer_origappset_id"), rs.getLong("emer_termappset_id")));
            }
            return map;
        }
    };

    public AppSetPatternDAO() {
        super(true);
    }

    public ResultSetMapper getAppSetPatternMapper() {
        return appSetPatternMapper;
    }

    @Override
    public Object getMainCollection() {
        return this.appSetPatternMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap appSetPatternMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + AppSetPatternDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        HashMap<Long, DigitTree<AppSetPattern>> treeMapTMP = new HashMap<Long, DigitTree<AppSetPattern>>();
        try {
            appSetPatternMapTMP = (HashMap)this.dataSource.executeQuery(getAppSetPatterns, params, this.getAppSetPatternMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        try {
            for (AppSetPattern pattern : appSetPatternMapTMP.values()) {
                this.insertPattern(treeMapTMP, pattern);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (Exception e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
        }
        try {
            this.lock.acquireWriteLock();
            this.appSetPatternMap = appSetPatternMapTMP;
            this.treeMap = treeMapTMP;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        boolean locked = false;
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)(AppSetPatternDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        AppSetPattern oldAppSetPattern = null;
        AppSetPattern newAppSetPattern = null;
        this.lock.acquireWriteLock();
        locked = true;
        try {
            if (tableName.equals("asmpatterntoappset")) {
                oldAppSetPattern = this.appSetPatternMap.remove(id);
                if (oldAppSetPattern != null) {
                    this.deletePattern(oldAppSetPattern);
                } else if (operation == DAOReplicationEvent.OperationType.DELETE) {
                    log.warn((Object)("AppSetPattern was null for " + (Object)((Object)event.getOperation()) + " " + id + "; we are probably out of sync"));
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getAppSetPatternById, params, this.getAppSetPatternMapper());
                    if (map.size() != 1) {
                        throw new DMException(AppSetPatternDAO.class.getSimpleName() + ".updateDAO: read " + map.size() + " AppSetPatterns(" + id + ") from database");
                    }
                    newAppSetPattern = (AppSetPattern)map.get(id);
                    if (newAppSetPattern == null) {
                        throw new DMException(AppSetPatternDAO.class.getSimpleName() + ".updateDAO: failed to read AppSetPattern(" + id + ") from database");
                    }
                    this.appSetPatternMap.put(id, newAppSetPattern);
                    this.insertPattern(this.treeMap, newAppSetPattern);
                }
            } else {
                log.warn((Object)("Got an event not registered to this DAO: " + event));
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.warn((Object)("Failed updating " + AppSetPatternDAO.class.getSimpleName() + " for " + tableName + " " + (Object)((Object)operation) + " " + id + "; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
            }
            return;
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        this.updateListeners(oldAppSetPattern, newAppSetPattern);
        if (log.isFineEnabled()) {
            log.fine((Object)(AppSetPatternDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmpatterntoappset");
        return list;
    }

    public void insertPattern(Map<Long, DigitTree<AppSetPattern>> treeMap, AppSetPattern pattern) {
        Long csdomain_id = pattern.getCsdomain_id();
        DigitTree<AppSetPattern> domainTree = treeMap.get(csdomain_id);
        if (domainTree == null) {
            domainTree = new DigitTree();
            treeMap.put(csdomain_id, domainTree);
        }
        domainTree.insert(pattern.getDigitpattern(), (short)pattern.getMindigits(), (short)pattern.getMaxdigits(), pattern, new DigitTreeNodeMatcher());
    }

    public void deletePattern(AppSetPattern pattern) {
        Long csdomain_id = pattern.getCsdomain_id();
        DigitTree<AppSetPattern> domainTree = this.treeMap.get(csdomain_id);
        if (domainTree != null) {
            domainTree.delete(pattern.getDigitpattern(), (short)pattern.getMindigits(), (short)pattern.getMaxdigits(), new DigitTreeNodeMatcher());
        } else {
            log.warn((Object)("Tried to delete AppSetPattern " + pattern.getId() + ", but domain " + csdomain_id + " did not exist"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppSetPattern getAppSetPattern(Long domainId, String digits) {
        try {
            this.lock.acquireReadLock();
            DigitTree<AppSetPattern> domainTree = this.treeMap.get(domainId);
            if (domainTree == null) {
                if (log.isFinerEnabled()) {
                    log.finer((Object)("getAppSetPattern(" + domainId + ", " + digits + ") returns null"));
                }
                AppSetPattern appSetPattern = null;
                return appSetPattern;
            }
            AppSetPattern pattern = domainTree.findBestMatch(digits, new DigitTreeNodeMatcher());
            if (log.isFinerEnabled()) {
                log.finer((Object)("getAppSetPattern(" + domainId + ", " + digits + ") returns " + pattern));
            }
            AppSetPattern appSetPattern = pattern;
            return appSetPattern;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned AppSetPatterns.")
    public Map<Long, AppSetPattern> getAllAppSetPatterns() {
        try {
            this.lock.acquireReadLock();
            Map<Long, AppSetPattern> map = this.appSetPatternMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

