/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstanceStorageCluster;
import com.avaya.asm.datamgr.objectapi.AsmStorageCluster;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmStorageClusterDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AsmStorageClusterDAO.class);
    protected Map<Long, AsmStorageCluster> storageClusterMap = new HashMap<Long, AsmStorageCluster>();
    protected Map<Long, AsmInstanceStorageCluster> instanceStorageClusterMap = new HashMap<Long, AsmInstanceStorageCluster>();
    protected Map<String, Map<Long, List<AsmInstanceStorageCluster>>> storageClusterListMap = new HashMap<String, Map<Long, List<AsmInstanceStorageCluster>>>();
    protected Map<String, Map<Long, AsmInstanceStorageCluster>> instanceMap = new HashMap<String, Map<Long, AsmInstanceStorageCluster>>();
    protected static final String getStorageClustersQuery = "SELECT id, name, cluster_type FROM asm_storage_cluster";
    protected static final String getStorageClusterByIdQuery = "SELECT id, name, cluster_type FROM asm_storage_cluster WHERE id=?";
    protected static final String getAsmInstanceStorageClustersQuery = "SELECT id, asminstance_id, asm_storage_cluster_id FROM asminstance_to_asm_storage_cluster";
    protected static final String getAsmInstanceStorageByIdQuery = "SELECT id, asminstance_id, asm_storage_cluster_id FROM asminstance_to_asm_storage_cluster WHERE id=?";
    private static final List<String> dependentTables = new ArrayList<String>();
    private static final ResultSetMapper storageClusterMapper;
    private static final ResultSetMapper storageClusterByIdMapper;
    private static final ResultSetMapper asmInstanceStorageClusterMapper;
    private static final ResultSetMapper asmInstanceStorageClusterByIdMapper;

    public AsmStorageClusterDAO() {
        super(true);
    }

    protected static ResultSetMapper getStorageClusterMapper() {
        return storageClusterMapper;
    }

    protected static ResultSetMapper getStorageClusterIdMapper() {
        return storageClusterByIdMapper;
    }

    private static AsmStorageCluster createStorageCluster(ResultSet rs) throws SQLException {
        long id = rs.getLong("id");
        String name = rs.getString("name");
        String clusterType = rs.getString("cluster_type");
        return new AsmStorageCluster(id, name, clusterType);
    }

    protected static ResultSetMapper getAsmInstanceStorageClusterMapper() {
        return asmInstanceStorageClusterMapper;
    }

    protected static ResultSetMapper getAsmInstanceStorageClusterIdMapper() {
        return asmInstanceStorageClusterByIdMapper;
    }

    private static AsmInstanceStorageCluster createAsmInstanceStorageCluster(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        Long asmInstanceId = rs.getLong("asminstance_id");
        Long storageClusterId = rs.getLong("asm_storage_cluster_id");
        return new AsmInstanceStorageCluster(id, asmInstanceId, storageClusterId);
    }

    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + AsmStorageClusterDAO.class.getSimpleName()));
        }
        this._init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _init() {
        Map<String, Map<Long, AsmInstanceStorageCluster>> instanceMapTMP;
        Map<String, Map<Long, List<AsmInstanceStorageCluster>>> storageClusterListMapTMP;
        Map instanceStorageClusterMapTMP;
        Map storageClusterMapTMP;
        try {
            storageClusterMapTMP = (Map)this.dataSource.executeQuery(getStorageClustersQuery, new Object[0], AsmStorageClusterDAO.getStorageClusterMapper());
            instanceStorageClusterMapTMP = (Map)this.dataSource.executeQuery(getAsmInstanceStorageClustersQuery, new Object[0], AsmStorageClusterDAO.getAsmInstanceStorageClusterMapper());
            storageClusterListMapTMP = this.buildStorageClusterListMap(storageClusterMapTMP, instanceStorageClusterMapTMP);
            instanceMapTMP = this.buildInstanceMap(storageClusterMapTMP, instanceStorageClusterMapTMP);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.storageClusterMap = storageClusterMapTMP;
                this.instanceStorageClusterMap = instanceStorageClusterMapTMP;
                this.storageClusterListMap = storageClusterListMapTMP;
                this.instanceMap = instanceMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    private Map<String, Map<Long, List<AsmInstanceStorageCluster>>> buildStorageClusterListMap(Map<Long, AsmStorageCluster> storageClusterMap, Map<Long, AsmInstanceStorageCluster> instanceStorageClusterMap) {
        HashMap<String, Map<Long, List<AsmInstanceStorageCluster>>> storageClusterListMap = new HashMap<String, Map<Long, List<AsmInstanceStorageCluster>>>();
        for (AsmInstanceStorageCluster asmInstStorageCluster : instanceStorageClusterMap.values()) {
            ArrayList<AsmInstanceStorageCluster> clusterList;
            AsmStorageCluster storageCluster = storageClusterMap.get(asmInstStorageCluster.getStorageClusterId());
            if (storageCluster == null) continue;
            String clusterType = storageCluster.getClusterType();
            HashMap<Long, ArrayList<AsmInstanceStorageCluster>> clusterListMap = (HashMap<Long, ArrayList<AsmInstanceStorageCluster>>)storageClusterListMap.get(clusterType);
            if (clusterListMap == null) {
                clusterListMap = new HashMap<Long, ArrayList<AsmInstanceStorageCluster>>();
                storageClusterListMap.put(clusterType, clusterListMap);
            }
            if ((clusterList = (ArrayList<AsmInstanceStorageCluster>)clusterListMap.get(asmInstStorageCluster.getStorageClusterId())) == null) {
                clusterList = new ArrayList<AsmInstanceStorageCluster>();
                clusterListMap.put(asmInstStorageCluster.getStorageClusterId(), clusterList);
            }
            clusterList.add(asmInstStorageCluster);
        }
        return storageClusterListMap;
    }

    private Map<String, Map<Long, AsmInstanceStorageCluster>> buildInstanceMap(Map<Long, AsmStorageCluster> storageClusterMap, Map<Long, AsmInstanceStorageCluster> instanceStorageClusterMap) {
        HashMap<String, Map<Long, AsmInstanceStorageCluster>> instanceMap = new HashMap<String, Map<Long, AsmInstanceStorageCluster>>();
        for (AsmInstanceStorageCluster asmInstStorageCluster : instanceStorageClusterMap.values()) {
            AsmStorageCluster storageCluster = storageClusterMap.get(asmInstStorageCluster.getStorageClusterId());
            if (storageCluster == null) continue;
            String clusterType = storageCluster.getClusterType();
            HashMap<Long, AsmInstanceStorageCluster> asmIdMap = (HashMap<Long, AsmInstanceStorageCluster>)instanceMap.get(clusterType);
            if (asmIdMap == null) {
                asmIdMap = new HashMap<Long, AsmInstanceStorageCluster>();
                instanceMap.put(clusterType, asmIdMap);
            }
            asmIdMap.put(asmInstStorageCluster.getAsmInstanceId(), asmInstStorageCluster);
        }
        return instanceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        AsmStorageCluster newCluster;
        AsmStorageCluster oldCluster;
        boolean isFiner;
        block39: {
            DAOReplicationEvent.OperationType operation = event.getOperation();
            String fcn_name = "updateDAO";
            isFiner = this.log.isFinerEnabled();
            boolean isFinest = this.log.isFinestEnabled();
            String tableName = event.getTableName();
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            Long id = event.getKey();
            if (isFiner) {
                this.log.finer((Object)("updateDAO: enter, operation=" + (Object)((Object)operation) + ", tableName=" + tableName + ", id=" + id));
            }
            oldCluster = null;
            newCluster = null;
            AsmInstanceStorageCluster oldAsmInstanceCluster = null;
            AsmInstanceStorageCluster newAsmInstanceCluster = null;
            boolean lockHeld = false;
            try {
                if ("asm_storage_cluster".equals(tableName)) {
                    if (operation != DAOReplicationEvent.OperationType.DELETE) {
                        Object[] params = new Object[]{id};
                        try {
                            newCluster = (AsmStorageCluster)this.dataSource.executeQuery(getStorageClusterByIdQuery, params, AsmStorageClusterDAO.getStorageClusterIdMapper());
                        }
                        catch (DMException e) {
                            this.log.error((Object)("updateDAO: DMException reading asm_storage_cluster id=" + id + ", re-initializing DAO"), (Throwable)e);
                            this.reinit();
                            if (!this.okay()) {
                                this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                            }
                            if (lockHeld) {
                                this.lock.releaseWriteLock();
                                lockHeld = false;
                            }
                            return;
                        }
                        if (newCluster != null && isFinest) {
                            this.log.finest((Object)("updateDAO: retrieved new cluster " + newCluster));
                        }
                    }
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    oldCluster = this.storageClusterMap.get(id);
                    if (oldCluster != null) {
                        if (newCluster != null) {
                            this.storageClusterMap.put(id, newCluster);
                            if (isFinest) {
                                this.log.finest((Object)("updateDAO: replaced oldCluster=" + oldCluster + " with newCLuster=" + newCluster));
                            }
                        } else {
                            this.storageClusterMap.remove(id);
                            if (isFinest) {
                                this.log.finest((Object)("updateDAO: removed oldCluster=" + oldCluster));
                            }
                        }
                    } else if (newCluster != null) {
                        this.storageClusterMap.put(id, newCluster);
                        if (isFinest) {
                            this.log.finest((Object)("updateDAO: added newCluster=" + newCluster));
                        }
                    }
                    break block39;
                }
                if (!"asminstance_to_asm_storage_cluster".equals(tableName)) break block39;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    try {
                        newAsmInstanceCluster = (AsmInstanceStorageCluster)this.dataSource.executeQuery(getAsmInstanceStorageByIdQuery, params, AsmStorageClusterDAO.getAsmInstanceStorageClusterIdMapper());
                    }
                    catch (DMException e) {
                        this.log.error((Object)("updateDAO: DMException reading asminstance_to_asm_storage_cluster id=" + id + ", re-initializing DAO"), (Throwable)e);
                        this.reinit();
                        if (!this.okay()) {
                            this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                        }
                        if (lockHeld) {
                            this.lock.releaseWriteLock();
                            lockHeld = false;
                        }
                        return;
                    }
                    if (newAsmInstanceCluster != null && isFinest) {
                        this.log.finest((Object)("updateDAO: retrieved new cluster " + newCluster));
                    }
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                oldAsmInstanceCluster = this.instanceStorageClusterMap.get(id);
                if (oldAsmInstanceCluster != null) {
                    if (newAsmInstanceCluster != null) {
                        this.instanceStorageClusterMap.put(id, newAsmInstanceCluster);
                        if (isFinest) {
                            this.log.finest((Object)("updateDAO: replaced oldAsmInstanceCluster=" + oldAsmInstanceCluster + " with newAsmInstanceCluster=" + newAsmInstanceCluster));
                        }
                    } else {
                        this.instanceStorageClusterMap.remove(id);
                        if (isFinest) {
                            this.log.finest((Object)("updateDAO: removed oldAsmInstanceCluster=" + oldAsmInstanceCluster));
                        }
                    }
                } else if (newAsmInstanceCluster != null) {
                    this.instanceStorageClusterMap.put(id, newAsmInstanceCluster);
                    if (isFinest) {
                        this.log.finest((Object)("updateDAO: added newAsmInstanceCluster=" + newAsmInstanceCluster));
                    }
                }
                this.storageClusterListMap = this.buildStorageClusterListMap(this.storageClusterMap, this.instanceStorageClusterMap);
                this.instanceMap = this.buildInstanceMap(this.storageClusterMap, this.instanceStorageClusterMap);
            }
            finally {
                if (lockHeld) {
                    this.lock.releaseWriteLock();
                    lockHeld = false;
                }
            }
        }
        if (oldCluster != null || newCluster != null) {
            this.updateListeners(oldCluster, newCluster);
        }
        if (isFiner) {
            this.log.finer((Object)"updateDAO leave, update successful");
        }
    }

    @Override
    public List<String> getDependentTables() {
        return dependentTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmStorageCluster getStorageClusterById(long id) {
        this.lock.acquireReadLock();
        try {
            AsmStorageCluster asmStorageCluster = this.storageClusterMap.get(id);
            return asmStorageCluster;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getAsmInstanceIdsByClusterIdAndType(long storageClusterId, String clusterType) {
        ArrayList<Long> asmIds = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            List<AsmInstanceStorageCluster> clusterList;
            Map<Long, List<AsmInstanceStorageCluster>> clusterListMap = this.storageClusterListMap.get(clusterType);
            if (clusterListMap != null && (clusterList = clusterListMap.get(storageClusterId)) != null) {
                for (AsmInstanceStorageCluster asmInstStorageCluster : clusterList) {
                    asmIds.add(asmInstStorageCluster.getAsmInstanceId());
                }
            }
            ArrayList<Long> arrayList = asmIds;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getStorageClusterIdByAsmInstanceIdAndType(long asmInstanceId, String clusterType) {
        this.lock.acquireReadLock();
        try {
            AsmInstanceStorageCluster asmInstStorageCluster;
            Map<Long, AsmInstanceStorageCluster> asmIdMap = this.instanceMap.get(clusterType);
            if (asmIdMap != null && (asmInstStorageCluster = asmIdMap.get(asmInstanceId)) != null) {
                Long l = asmInstStorageCluster.getStorageClusterId();
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all SM Storage Clusters.")
    public Map<Long, AsmStorageCluster> getStorageClusters() {
        this.lock.acquireReadLock();
        try {
            Map<Long, AsmStorageCluster> map = Collections.unmodifiableMap(this.storageClusterMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get mapping of storage clusters to ASM instances by cluster type.")
    public Map<String, Map<Long, List<AsmInstanceStorageCluster>>> getStorageClusterListMap() {
        this.lock.acquireReadLock();
        try {
            Map<String, Map<Long, List<AsmInstanceStorageCluster>>> map = Collections.unmodifiableMap(this.storageClusterListMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.storageClusterMap;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }

    static {
        dependentTables.add("asm_storage_cluster");
        dependentTables.add("asminstance_to_asm_storage_cluster");
        storageClusterMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashMap<Long, AsmStorageCluster> map = new HashMap<Long, AsmStorageCluster>();
                while (rs.next()) {
                    AsmStorageCluster sc = AsmStorageClusterDAO.createStorageCluster(rs);
                    map.put(sc.getId(), sc);
                }
                return map;
            }
        };
        storageClusterByIdMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                AsmStorageCluster sc = null;
                if (rs.next()) {
                    sc = AsmStorageClusterDAO.createStorageCluster(rs);
                }
                return sc;
            }
        };
        asmInstanceStorageClusterMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashMap<Long, AsmInstanceStorageCluster> map = new HashMap<Long, AsmInstanceStorageCluster>();
                while (rs.next()) {
                    AsmInstanceStorageCluster sc = AsmStorageClusterDAO.createAsmInstanceStorageCluster(rs);
                    map.put(sc.getId(), sc);
                }
                return map;
            }
        };
        asmInstanceStorageClusterByIdMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                AsmInstanceStorageCluster sc = null;
                if (rs.next()) {
                    sc = AsmStorageClusterDAO.createAsmInstanceStorageCluster(rs);
                }
                return sc;
            }
        };
    }
}

