/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.dao.CommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.AusCommProfile;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AusCommProfileDAO
extends CommProfileDAO {
    private static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, AusCommProfile> profileMap = new ConcurrentHashMap<Long, AusCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new AusCommProfile((Long)id, (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("template_id")));
            }
            return profileMap;
        }
    };

    public AusCommProfileDAO() {
        this.localOnly = false;
    }

    @Override
    public String getMainTable() {
        return "zr_commprofile";
    }

    @Override
    protected String getSelectFields() {
        return "SELECT cs.id, cs.cscommprofilesetid, cs.preferredhandleid, aus.template_id FROM cscommprofile cs JOIN zr_commprofile aus ON cs.id=aus.id";
    }

    @Override
    protected String getCommProfileType() {
        return "AUS";
    }

    @Override
    protected ResultSetMapper getMapper() {
        return mapper;
    }

    public AusCommProfile getAusCommProfile(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null) {
                AusCommProfile ausCommProfile = (AusCommProfile)this.csCommProfileMap.get(id);
                return ausCommProfile;
            }
            AusCommProfile ausCommProfile = null;
            return ausCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AusCommProfile getAusCommProfileBySetId(Long setId) {
        try {
            this.lock.acquireReadLock();
            Long id = (Long)this.setIdMap.get(setId);
            if (id != null) {
                AusCommProfile ausCommProfile = (AusCommProfile)this.csCommProfileMap.get(id);
                return ausCommProfile;
            }
            AusCommProfile ausCommProfile = null;
            return ausCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all AusCommProfiles cached in memory.")
    public Map<Long, CsCommProfile> getAusCommProfiles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsCommProfile> map = Collections.unmodifiableMap(this.csCommProfileMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

