/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraUtils;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CallHistoryDAO_70 {
    private final Logger log = AsmLogger.getLogger(CallHistoryDAO_70.class);
    public static final String CALLHISTORY_KEYSPACE = "callhistory70";
    static final String KEYSPACE_PATTERN = "__keyspace__";
    static final String CALLLOG_CF = "__keyspace__.calllog";
    static final String CALLLOGIDS_CF = "__keyspace__.calllogids";
    static final String GET_CALLHISTORY_QRY = "SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy, avext FROM __keyspace__.calllog";
    static final String GET_CALLLOGIDS_QRY = "SELECT ids FROM __keyspace__.calllogids";
    static final String ADD_CALLHISTORY_QRY = "INSERT INTO __keyspace__.calllog";
    static final String UPD_CALLLOGIDS_QRY = "UPDATE __keyspace__.calllogids SET user_id=?, ids=ids";
    static final String DELETE_CALLLOG_QRY = "DELETE FROM __keyspace__.calllog";
    static final String DELETE_CALLLOGIDS_QRY = "DELETE FROM __keyspace__.calllogids";
    static final String SELECT_CALLLOGIDS_QRY = "SELECT count(*) FROM __keyspace__.calllogids LIMIT 1000000";
    static final String SELECT_COMMPROF_SETIDS = "SELECT set_id from __keyspace__.calllogids";
    static final String SELECT_USERIDS = "SELECT user_id from __keyspace__.calllogids";
    static final String SELECT_COUNT_CALLLOGIDS = "SELECT count(*) FROM calllogids";
    static volatile CallHistoryDAO_70 instance = null;
    static Object mutex = new Object();
    private final SessionDAO sessionDAO;
    static final int MAX_UUIDS_PER_SET = 5000;
    private Map<PreparedStatementKey, QueryRecord> preparedStatements = new HashMap<PreparedStatementKey, QueryRecord>();
    public static final int MAX_REPLICATION_FACTOR = 2;
    public static String[] keyspaces = new String[2];
    private static String dfltHost;
    private static int dfltPort;
    private static String dfltUsername;
    private static String dfltPassword;

    public static int getMaxReplicationFactor() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallHistoryDAO_70 getInstance() throws DMException {
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                if (instance == null) {
                    CallHistoryDAO_70 tmpInstance;
                    instance = tmpInstance = new CallHistoryDAO_70(new String[0]);
                }
            }
        }
        return instance;
    }

    public static void setInstance(CallHistoryDAO_70 instance) {
        CallHistoryDAO_70.instance = instance;
    }

    public static void setConnInfo(String host, int port, String username, String password) {
        dfltHost = host;
        dfltPort = port;
        dfltUsername = username;
        dfltPassword = password;
    }

    public CallHistoryDAO_70(String ... hosts) throws DMException {
        this.sessionDAO = UstoreDAOFactory.createSessionDAO(hosts.length == 0 ? dfltHost : hosts[0], dfltPort, 8085, dfltUsername, dfltPassword, null);
        for (int i = 0; i < 2; ++i) {
            int rf = i + 1;
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.ADD_CALLLOG, rf), new QueryRecord("INSERT INTO __keyspace__.calllog (asm_id,ucom_id,bsm_id,user_id,set_id,id,duration,bridged,privacy,datetime,dialog_id,local_number,number,name,type,avext) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.ADD_CALLLOGIDS, rf), new QueryRecord("UPDATE __keyspace__.calllogids SET user_id=?, ids=ids+? WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.DELETE_CALLLOG_SETID, rf), new QueryRecord("DELETE FROM __keyspace__.calllog WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.DELETE_CALLLOGIDS_SETID, rf), new QueryRecord("DELETE FROM __keyspace__.calllogids WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.DELETE_CALLLOG_SETID_ID, rf), new QueryRecord("DELETE FROM __keyspace__.calllog WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=? AND id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.DELETE_CALLLOGIDS_SETID_ID, rf), new QueryRecord("UPDATE __keyspace__.calllogids SET user_id=?, ids=ids-? WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.GET_CALLLOG, rf), new QueryRecord("SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy, avext FROM __keyspace__.calllog WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.GET_CALLLOGIDS, rf), new QueryRecord("SELECT ids FROM __keyspace__.calllogids WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.GET_CALLLOG_LIMIT, rf), new QueryRecord("SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy, avext FROM __keyspace__.calllog WHERE asm_id=? AND ucom_id=? AND bsm_id=? AND set_id=? LIMIT ?;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.GET_SETID_CALLLOGIDS, rf), new QueryRecord("SELECT set_id from __keyspace__.calllogids;", rf, null));
            this.preparedStatements.put(new PreparedStatementKey(CallHistoryPSType.GET_USERID_COUNT_CALLLOGIDS, rf), new QueryRecord("SELECT count(*) FROM calllogids where user_id=? AND set_id = ? ALLOW FILTERING;", rf, null));
        }
    }

    public List<UUID> getCallLogIds(final long asmId, final long ucomId, final long bsmId, final long cscommprofilesetId, final int replicationFactor) throws DMException {
        ArrayList<UUID> callLogIds = new ArrayList<UUID>();
        ResultSet rs = this.sessionDAO.executeStatement(new CallHistory70StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_70.this.getPreparedStatement(CallHistoryPSType.GET_CALLLOGIDS, replicationFactor);
                return ps.bind(new Object[]{asmId, ucomId, bsmId, cscommprofilesetId});
            }
        });
        for (Row row : rs) {
            Set uuids = row.getSet("ids", UUID.class);
            callLogIds.addAll(uuids);
        }
        return callLogIds;
    }

    public List<CallLog> getCallHistory(final long asmId, final long ucomId, final long bsmId, final long cscommprofilesetId, final Integer limit, final int replicationFactor) throws DMException {
        ArrayList<CallLog> callLogs = new ArrayList<CallLog>();
        CallHistory70StatementBuilder statementBuilder = new CallHistory70StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                if (limit != null) {
                    PreparedStatement ps = CallHistoryDAO_70.this.getPreparedStatement(CallHistoryPSType.GET_CALLLOG_LIMIT, replicationFactor);
                    return ps.bind(new Object[]{asmId, ucomId, bsmId, cscommprofilesetId, limit});
                }
                PreparedStatement ps = CallHistoryDAO_70.this.getPreparedStatement(CallHistoryPSType.GET_CALLLOG, replicationFactor);
                return ps.bind(new Object[]{asmId, ucomId, bsmId, cscommprofilesetId});
            }
        };
        ResultSet rs = this.sessionDAO.executeStatement(statementBuilder);
        for (Row row : rs) {
            CallLog callLog = this.createCallLog(row);
            callLogs.add(callLog);
        }
        return callLogs;
    }

    public void updateCallLogs(final long asmId, final long ucomId, final long bsmId, final long csuserId, final long cscommprofilesetId, final List<UUID> deleteList, final List<CallLog> addList, final int replicationFactor) throws DMException {
        this.sessionDAO.executeStatement(new CallHistory70StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                BatchStatement batch = CallHistoryDAO_70.this.createUpdateBatchStatement(asmId, ucomId, bsmId, csuserId, cscommprofilesetId, deleteList, addList, replicationFactor);
                return batch;
            }
        });
    }

    private BatchStatement createUpdateBatchStatement(long asmId, long ucomId, long bsmId, long csuserId, long cscommprofilesetId, List<UUID> deleteList, List<CallLog> addList, int replicationFactor) throws DMException {
        BatchStatement batch = new BatchStatement();
        if (deleteList != null) {
            this.deleteCallLogs(batch, asmId, ucomId, bsmId, csuserId, cscommprofilesetId, deleteList, replicationFactor);
        }
        if (addList != null) {
            ArrayList<UUID> addUuidList = new ArrayList<UUID>(addList.size());
            PreparedStatement ps = this.getPreparedStatement(CallHistoryPSType.ADD_CALLLOG, replicationFactor);
            for (CallLog callLog : addList) {
                this.bindAndBatchInsertCallLog(batch, ps, asmId, ucomId, bsmId, csuserId, cscommprofilesetId, callLog, addUuidList);
            }
            this.bindAndBatchCallLogIds(batch, addUuidList, asmId, ucomId, bsmId, csuserId, cscommprofilesetId, false, replicationFactor);
        }
        return batch;
    }

    private void bindAndBatchInsertCallLog(BatchStatement batch, PreparedStatement ps, long asmId, long ucomId, long bsmId, long csuserId, long cscommprofilesetId, CallLog callLog, List<UUID> addUuidList) {
        UUID timeUuid = null;
        timeUuid = callLog.getUUID() == null ? CassandraUtils.genTimeUUID() : callLog.getUUID();
        addUuidList.add(timeUuid);
        batch.add((Statement)ps.bind(new Object[]{asmId, ucomId, bsmId, csuserId, cscommprofilesetId, timeUuid, callLog.getDuration(), callLog.isBridged(), callLog.isPrivacy(), new Date(callLog.getTimestamp()), callLog.getDialogId(), callLog.getLocalPartyId(), callLog.getRemotePartyId(), callLog.getRemotePartyName(), callLog.getType() != null ? callLog.getType().toString() : null, callLog.getRemotePartyAvExt()}));
    }

    protected int bindAndBatchCallLogIdsByBatchSize(BatchStatement batch, PreparedStatement ps, int startIdx, List<UUID> uuidList, long asmId, long ucomId, long bsmId, long csuserId, long cscommprofilesetId) {
        int batchSize = uuidList.size() - startIdx;
        if (batchSize > 5000) {
            batchSize = 5000;
        }
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        for (int i = startIdx; i < startIdx + batchSize; ++i) {
            uuidSet.add(uuidList.get(i));
        }
        batch.add((Statement)ps.bind(new Object[]{csuserId, uuidSet, asmId, ucomId, bsmId, cscommprofilesetId}));
        return batchSize;
    }

    public void deleteAllCallLogs(long asmId, long ucomId, long bsmId, long cscommprofilesetId, int replicationFactor) throws DMException {
        this.doDeleteAllCallLogs(asmId, ucomId, bsmId, cscommprofilesetId, replicationFactor);
    }

    public void deleteCallLogs(final long asmId, final long ucomId, final long bsmId, final long csuserId, final long cscommprofilesetId, final List<UUID> callLogIds, final int replicationFactor) throws DMException {
        this.sessionDAO.executeStatement(new CallHistory70StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                BatchStatement batch = new BatchStatement();
                CallHistoryDAO_70.this.deleteCallLogs(batch, asmId, ucomId, bsmId, csuserId, cscommprofilesetId, callLogIds, replicationFactor);
                return batch;
            }
        });
    }

    private void deleteCallLogs(BatchStatement batch, long asmId, long ucomId, long bsmId, long csuserId, long cscommprofilesetId, List<UUID> uuidList, int replicationFactor) throws DMException {
        PreparedStatement ps = this.getPreparedStatement(CallHistoryPSType.DELETE_CALLLOG_SETID_ID, replicationFactor);
        for (UUID id : uuidList) {
            batch.add((Statement)ps.bind(new Object[]{asmId, ucomId, bsmId, cscommprofilesetId, id}));
        }
        this.bindAndBatchCallLogIds(batch, uuidList, asmId, ucomId, bsmId, csuserId, cscommprofilesetId, true, replicationFactor);
    }

    private void bindAndBatchCallLogIds(BatchStatement batch, List<UUID> uuidList, long asmId, long ucomId, long bsmId, long csuserId, long cscommprofilesetId, boolean deleteFlag, int replicationFactor) throws DMException {
        PreparedStatement ps = this.getPreparedStatement(deleteFlag ? CallHistoryPSType.DELETE_CALLLOGIDS_SETID_ID : CallHistoryPSType.ADD_CALLLOGIDS, replicationFactor);
        int numUuids = uuidList.size();
        for (int startIdx = 0; startIdx < numUuids; startIdx += this.bindAndBatchCallLogIdsByBatchSize(batch, ps, startIdx, uuidList, asmId, ucomId, bsmId, csuserId, cscommprofilesetId)) {
        }
    }

    private void doDeleteAllCallLogs(final long asmId, final long ucomId, final long bsmId, final long cscommprofilesetId, final int replicationFactor) throws DMException {
        this.sessionDAO.executeStatement(new CallHistory70StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                BatchStatement batch = CallHistoryDAO_70.this.createDeleteAllStatementBuilder(asmId, ucomId, bsmId, cscommprofilesetId, replicationFactor);
                return batch;
            }
        });
    }

    private BatchStatement createDeleteAllStatementBuilder(long asmId, long ucomId, long bsmId, long cscommprofilesetId, int replicationFactor) throws DMException {
        String fcn_name = "createDeleteAllStatementBuilder";
        boolean isFinest = this.log.isFinestEnabled();
        BatchStatement batch = new BatchStatement();
        PreparedStatement ps = this.getPreparedStatement(CallHistoryPSType.DELETE_CALLLOG_SETID, replicationFactor);
        batch.add((Statement)ps.bind(new Object[]{asmId, ucomId, bsmId, cscommprofilesetId}));
        if (isFinest) {
            this.log.finest((Object)"createDeleteAllStatementBuilder:  added the CallLog ps to the batch");
        }
        ps = this.getPreparedStatement(CallHistoryPSType.DELETE_CALLLOGIDS_SETID, replicationFactor);
        batch.add((Statement)ps.bind(new Object[]{asmId, ucomId, bsmId, cscommprofilesetId}));
        return batch;
    }

    private CallLog createCallLog(Row row) {
        Date dateTime = row.getTimestamp("datetime");
        long timestamp = dateTime != null ? dateTime.getTime() : 0L;
        String typeStr = row.getString("type");
        CallLog.CallLogType type = typeStr == null ? CallLog.CallLogType.unknown : CallLog.CallLogType.valueOf(typeStr);
        CallLog callLog = new CallLog(row.getUUID("id"), timestamp, row.getInt("duration"), row.getString("local_number"), row.getString("number"), row.getString("avext"), row.getString("name"), row.getString("dialog_id"), type, row.getBool("bridged"), row.getBool("privacy"));
        return callLog;
    }

    public List<Long> getCommProfSetIds() throws DMException {
        ArrayList<Long> setIdsList = new ArrayList<Long>();
        for (int i = 1; i <= 2; ++i) {
            final int rf = i;
            ResultSet resultSet = this.sessionDAO.executeStatement(new CallHistory70StatementBuilder(){

                @Override
                public Statement getStatement() throws DMException {
                    PreparedStatement ps = CallHistoryDAO_70.this.getPreparedStatement(CallHistoryPSType.GET_SETID_CALLLOGIDS, rf);
                    return new BoundStatement(ps);
                }
            });
            for (Row row : resultSet) {
                setIdsList.add(row.getLong("set_id"));
            }
        }
        return setIdsList;
    }

    public Long getCountCallLogIds(final long csuserId, final long cscommprofilesetId, final int replicationFactor) throws DMException {
        Long recordCount = 0L;
        ResultSet resultSet = this.sessionDAO.executeStatement(new CallHistory70StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_70.this.getPreparedStatement(CallHistoryPSType.GET_USERID_COUNT_CALLLOGIDS, replicationFactor);
                return ps.bind(new Object[]{csuserId, cscommprofilesetId});
            }
        });
        for (Row row : resultSet) {
            recordCount = row.getLong(0);
        }
        return recordCount;
    }

    private PreparedStatement getPreparedStatement(CallHistoryPSType type, int replicationFactor) throws DMException {
        String fcn_name = "getPreparedStatement";
        PreparedStatementKey key = new PreparedStatementKey(type, replicationFactor);
        QueryRecord queryRecord = this.preparedStatements.get(key);
        if (queryRecord == null) {
            this.log.error((Object)("getPreparedStatement: no query record available for type: " + (Object)((Object)type)));
            return null;
        }
        if (queryRecord.getStatement() == null) {
            this.log.error((Object)("getPreparedStatement:  no prepared statement available for type: " + (Object)((Object)type)));
            return null;
        }
        return queryRecord.getStatement();
    }

    public static String getKeyspace(int replicationFactor) {
        if (replicationFactor > 2 || replicationFactor < 1) {
            throw new IllegalArgumentException("Invalid replication factor: " + replicationFactor);
        }
        return keyspaces[replicationFactor - 1];
    }

    static {
        for (int i = 0; i < 2; ++i) {
            int rf = i + 1;
            CallHistoryDAO_70.keyspaces[i] = new String("callhistory70x" + rf);
        }
        dfltHost = null;
        dfltPort = -1;
        dfltUsername = null;
        dfltPassword = null;
    }

    private class PreparedStatementKey {
        CallHistoryPSType type;
        int replicationFactor;

        public PreparedStatementKey(CallHistoryPSType type, int replicationFactor) {
            this.type = type;
            this.replicationFactor = replicationFactor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.replicationFactor;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PreparedStatementKey other = (PreparedStatementKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            return this.type == other.type;
        }

        private CallHistoryDAO_70 getOuterType() {
            return CallHistoryDAO_70.this;
        }
    }

    public static enum CallHistoryPSType {
        ADD_CALLLOG,
        ADD_CALLLOGIDS,
        DELETE_CALLLOG_SETID,
        DELETE_CALLLOGIDS_SETID,
        DELETE_CALLLOG_SETID_ID,
        DELETE_CALLLOGIDS_SETID_ID,
        GET_CALLLOG,
        GET_CALLLOGIDS,
        GET_CALLLOG_LIMIT,
        GET_SETID_CALLLOGIDS,
        GET_USERID_COUNT_CALLLOGIDS;

    }

    class QueryRecord {
        final String query;
        PreparedStatement preparedStatement;

        public QueryRecord(String query, Integer replicationFactor, PreparedStatement ps) {
            this.query = replicationFactor != null ? query.replace(CallHistoryDAO_70.KEYSPACE_PATTERN, CallHistoryDAO_70.getKeyspace(replicationFactor)) : query;
            this.preparedStatement = ps;
        }

        public synchronized PreparedStatement getStatement() throws DMException {
            if (this.preparedStatement == null) {
                this.preparedStatement = CallHistoryDAO_70.this.sessionDAO.prepareQuery(this.query);
            }
            return this.preparedStatement;
        }
    }

    public abstract class CallHistory70StatementBuilder
    implements UserStoreStatementBuilder {
        @Override
        public abstract Statement getStatement() throws DMException;

        @Override
        public void newSession() {
        }
    }
}

