/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.datamgr.JGroupsKeystoreAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.core.exceptions.JGroupsKeystoreException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterHelper;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.loadrulekeys.WriteJbossKs;
import com.avaya.asm.datamgr.loadrulekeys.WriteKs;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.GlobalParm;
import com.avaya.common.logging.client.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

@ConsumesLoadRules(key={WriteKs.class, WriteJbossKs.class})
public class GlobalDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(GlobalDAO.class);
    protected Map<String, Map<String, Object>> globalMap = new HashMap<String, Map<String, Object>>();
    protected Long myInstanceId = null;
    protected static final String getGlobalParms = "SELECT allow_nonauth_emergency, failback_policy, elin_sipEntity_id, prefer_location_all_patterns, cac_ignore_sdp, cac_disable_threshold_alarms, dpt_routing_string, jgrppw, jgrpkeyfile, enable_inter_tenant_control, sip_user_implicit_sequencing  FROM AsmGlobalParm";
    protected static final String getProvParms = "SELECT instance, name, value , value_large FROM AsmProvParm";
    public static final String ALLOW_NONAUTH_EMERGENCY = "allow_nonauth_emergency";
    public static final String CAC_IGNORE_SDP = "cac_ignore_sdp";
    public static final String PREFER_LOCATION_ALL_PATTERNS = "prefer_location_all_patterns";
    public static final String FAILBACK_POLICY = "failback_policy";
    public static final String ELIN_SIPENTITY_ID = "elin_sipEntity_id";
    public static final String DISABLE_CAC_ALARMS = "cac_disable_threshold_alarms";
    public static final String DPT_ROUTING_STRING = "dpt_routing_string";
    public static final String JGROUPS_PW = "jgrppw";
    public static final String JGROUPS_KEY_FILE = "jgrpkeyfile";
    public static final String JGROUPS_PW_JBOSS = "jgrppw.ppmcluster";
    public static final String JGROUPS_KEY_FILE_JBOSS = "jgrpkeyfile.ppmcluster";
    public static final String ENABLE_INTER_TENANT_CONTROL = "enable_inter_tenant_control";
    public static final String SIP_USER_IMPLICIT_SEQUENCING = "sip_user_implicit_sequencing";
    public static final String END_TO_END_SECURE_INDICATOR = "endToEndSecureIndication";
    public static final String CLIENT_MUTUAL_AUTHENTICATION = "clientMutualAuthentication";
    public static final String ENABLE_STORAGE_CLUSTER = "ustore.enableStorageCluster";
    public static final String USTORE_CLIENT_USER = "ustore.client.user";
    public static final String USTORE_CLIENT_PASSWORD = "ustore.client.password";
    public static final String USTORE_SUPER_USER = "ustore.super.user";
    public static final String USTORE_SUPER_PASSWORD = "ustore.super.password";
    public static final String SIPENTITY_TLS_VERSION = "tls_version.sipentity";
    public static final String ENDPT_TLS_VERSION = "tls_version.endpoint";
    public static final String ENABLE_REGEXPBASED_ADAPTATION = "regexp.adaptation.enabled";
    public static final String IPV6_ENABLED = "ipv6.enabled";
    public static final String DOD_ENABLED = "dod.enabled";
    public static final String EMER_APPSEQ_ENABLED = "emer.appseq.enabled";
    public static final String CALL_RESILIENCY_ENABLED = "call.resiliency.enabled";
    public static final String FLEXIBLE_ROUTING_ENABLED = "flexible.routing.enabled";
    public static final String FLEXIBLE_ROUTING_RULES_PRECEDENCE = "flexible.routing.rules.precedence";
    public static final String FLEXIBLE_ROUTING_MATCH_PRECEDENCE = "flexible.routing.match.precedence";
    public static final String COMMON_DEVICE_DATA_PARAMETERS = "ppm.commondevicedataparameters";
    public static final String LOG_RETENTION_DAYS = "log.rotation.days";
    public static final String VISITING_BSM_ENABLED = "visitingbsm.enabled";
    public static final String PUSH_NOTIFICATION_ENABLED = "pushnotification.enabled";
    public static final String PUSH_NOTIFICATION_EC500_DELAY = "pushnotification.ec500delay";
    public static final String DYNAMIC_SM_POLICY_ENABLED = "dynamicsm.policy.enabled";
    public static final String LOAD_FACTOR_ALARM_THRESHOLD = "loadfactor.alarmthreshold";
    public static final String HTTPS_FORWARD_PROXY_HOST = "apnp_proxy_host";
    public static final String HTTPS_FORWARD_PROXY_PORT = "apnp_proxy_port";
    protected static final String JG_KEYSTORE_FILE = "/opt/IBM/WebSphere/AppServer/lib/ext" + File.separator + "jgroupsKeystore.gen.jceks";
    protected static final String JG_KEYSTORE_FILE_JBOSS = "/opt/Avaya/wildfly-24.0.0.Final/modules/system/layers/base/com/avaya/asm/conf/main" + File.separator + "jgroupsKeystore.gen.jceks";
    private static Object mutex = new Object();
    protected boolean createKeyStore = false;
    protected boolean createJbossKeyStore = false;
    protected static final ResultSetMapper globalsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            if (rs.next()) {
                valueMap.put(GlobalDAO.ALLOW_NONAUTH_EMERGENCY, rs.getBoolean(GlobalDAO.ALLOW_NONAUTH_EMERGENCY));
                valueMap.put(GlobalDAO.FAILBACK_POLICY, rs.getString(GlobalDAO.FAILBACK_POLICY));
                long elinSipEntityId = rs.getLong(GlobalDAO.ELIN_SIPENTITY_ID);
                valueMap.put(GlobalDAO.ELIN_SIPENTITY_ID, rs.wasNull() ? null : new Long(elinSipEntityId));
                valueMap.put(GlobalDAO.PREFER_LOCATION_ALL_PATTERNS, rs.getBoolean(GlobalDAO.PREFER_LOCATION_ALL_PATTERNS));
                valueMap.put(GlobalDAO.CAC_IGNORE_SDP, rs.getBoolean(GlobalDAO.CAC_IGNORE_SDP));
                valueMap.put(GlobalDAO.DISABLE_CAC_ALARMS, rs.getBoolean(GlobalDAO.DISABLE_CAC_ALARMS));
                valueMap.put(GlobalDAO.DPT_ROUTING_STRING, rs.getString(GlobalDAO.DPT_ROUTING_STRING));
                valueMap.put(GlobalDAO.JGROUPS_PW, rs.getString(GlobalDAO.JGROUPS_PW));
                valueMap.put(GlobalDAO.JGROUPS_KEY_FILE, rs.getBytes(GlobalDAO.JGROUPS_KEY_FILE));
                valueMap.put(GlobalDAO.ENABLE_INTER_TENANT_CONTROL, rs.getBoolean(GlobalDAO.ENABLE_INTER_TENANT_CONTROL));
                valueMap.put(GlobalDAO.SIP_USER_IMPLICIT_SEQUENCING, rs.getBoolean(GlobalDAO.SIP_USER_IMPLICIT_SEQUENCING));
            }
            return valueMap;
        }
    };
    protected static final ResultSetMapper provsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap valueMap = new HashMap();
            while (rs.next()) {
                String instance = rs.getString("instance");
                if (!valueMap.containsKey(instance)) {
                    valueMap.put(instance, new HashMap());
                }
                ((Map)valueMap.get(instance)).put(rs.getString("name"), rs.getString("value"));
                if (!rs.getString("name").equalsIgnoreCase(GlobalDAO.JGROUPS_KEY_FILE_JBOSS) && !rs.getString("name").equalsIgnoreCase(GlobalDAO.COMMON_DEVICE_DATA_PARAMETERS)) continue;
                ((Map)valueMap.get(instance)).put(rs.getString("name"), rs.getString("value_large"));
            }
            return valueMap;
        }
    };

    public GlobalDAO() {
        super(true);
    }

    protected static DataDistLayerFactory getDDLFactory() {
        return DataDistLayerFactory.getInstance();
    }

    @Override
    public Object getMainCollection() {
        return this.globalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object = mutex;
        synchronized (object) {
            if (log.isFineEnabled()) {
                log.fine((Object)("Initializing " + GlobalDAO.class.getSimpleName()));
            }
            Map<Object, Map> globalMapTMP = new HashMap();
            Object[] params = new Object[]{};
            try {
                this.myInstanceId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
                globalMapTMP = (Map)this.dataSource.executeQuery(getProvParms, params, provsMapper);
                Map valueMap = (Map)this.dataSource.executeQuery(getGlobalParms, params, globalsMapper);
                if (!globalMapTMP.containsKey(null)) {
                    globalMapTMP.put(null, valueMap);
                } else {
                    ((Map)globalMapTMP.get(null)).putAll(valueMap);
                }
                this.setStatus(DataMgr.Status.OKAY);
            }
            catch (DMException e) {
                this.setStatus(DataMgr.Status.FAIL);
                log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
                GenericAlarmHandler.handleFailureEvent(this, e);
                return;
            }
            if (this.okay()) {
                try {
                    this.lock.acquireWriteLock();
                    this.globalMap = globalMapTMP;
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextInt(1000, 3000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.setupJgroupsSecurity(this.createKeyStore)) {
                log.info((Object)"Performing an Inter-Cluster rejoin because we wrote out a new Keystore.");
                this.rejoinInter();
            }
            if (this.setupJbossJgroupsSecurity(this.createJbossKeyStore)) {
                log.info((Object)"Performing an Jboss Inter-Cluster rejoin because we wrote out a new Jboss Keystore.");
                this.rejoinInter();
            }
        }
    }

    protected void rejoinInter() {
        DataDistLayerFactory ddlFactory = GlobalDAO.getDDLFactory();
        DDLInterClusterMember member = ddlFactory.getInterClusterMember();
        if (member != null) {
            ddlFactory.asynchRejoinMember(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataMgr.Status reinit() {
        Map<String, Map<String, Object>> oldGlobalMap;
        try {
            this.lock.acquireReadLock();
            oldGlobalMap = this.globalMap;
        }
        finally {
            this.lock.releaseReadLock();
        }
        this.eventQueue.clear();
        this.init();
        try {
            this.lock.acquireReadLock();
            Map<String, Map<String, Object>> newGlobalMap = this.globalMap;
            String myInstanceString = this.myInstanceId == null ? null : this.myInstanceId.toString();
            ArrayList<String> names = new ArrayList<String>();
            if (oldGlobalMap.containsKey(myInstanceString)) {
                for (String name : oldGlobalMap.get(myInstanceString).keySet()) {
                    names.add(name);
                }
            }
            if (newGlobalMap.containsKey(myInstanceString)) {
                for (String name : newGlobalMap.get(myInstanceString).keySet()) {
                    if (names.contains(name)) continue;
                    names.add(name);
                }
            }
            if (oldGlobalMap.containsKey(null)) {
                for (String name : oldGlobalMap.get(null).keySet()) {
                    if (names.contains(name)) continue;
                    names.add(name);
                }
            }
            if (newGlobalMap.containsKey(null)) {
                for (String name : newGlobalMap.get(null).keySet()) {
                    if (names.contains(name)) continue;
                    names.add(name);
                }
            }
            for (String name : names) {
                GlobalParm oldObject = null;
                GlobalParm newObject = null;
                if (oldGlobalMap.containsKey(myInstanceString) && oldGlobalMap.get(myInstanceString).containsKey(name)) {
                    oldObject = new GlobalParm(name, oldGlobalMap.get(myInstanceString).get(name));
                }
                if (oldObject == null && oldGlobalMap.containsKey(null) && oldGlobalMap.get(null).containsKey(name)) {
                    oldObject = new GlobalParm(name, oldGlobalMap.get(null).get(name));
                }
                if (newGlobalMap.containsKey(myInstanceString) && newGlobalMap.get(myInstanceString).containsKey(name)) {
                    newObject = new GlobalParm(name, newGlobalMap.get(myInstanceString).get(name));
                }
                if (newObject == null && newGlobalMap.containsKey(null) && newGlobalMap.get(null).containsKey(name)) {
                    newObject = new GlobalParm(name, newGlobalMap.get(null).get(name));
                }
                if ((oldObject != null || newObject == null) && (oldObject == null || oldObject.equals(newObject))) continue;
                this.updateListeners(oldObject, newObject);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return this.getStatus();
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        this.reinit();
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmglobalparm");
        list.add("asmprovparm");
        return list;
    }

    public boolean allowNonAuthEmergencyCalls() {
        Boolean retval = (Boolean)this.getGlobal(ALLOW_NONAUTH_EMERGENCY);
        return retval == null ? false : retval;
    }

    public boolean cacIgnoreSDP() {
        Boolean retval = (Boolean)this.getGlobal(CAC_IGNORE_SDP);
        return retval == null ? false : retval;
    }

    public String getFailbackPolicy() {
        return (String)this.getGlobal(FAILBACK_POLICY);
    }

    public String getDPTRoutingString() {
        return (String)this.getGlobal(DPT_ROUTING_STRING);
    }

    public List<Long> getELINServers() {
        ArrayList<Long> elinServers = new ArrayList<Long>();
        Long elinId = (Long)this.getGlobal(ELIN_SIPENTITY_ID);
        if (elinId != null) {
            elinServers.add(elinId);
        }
        return elinServers;
    }

    public boolean preferLocationAllPatterns() {
        Boolean retval = (Boolean)this.getGlobal(PREFER_LOCATION_ALL_PATTERNS);
        return retval == null ? false : retval;
    }

    public Boolean isCacAlarmingDisabled() {
        return (Boolean)this.getGlobal(DISABLE_CAC_ALARMS);
    }

    @Deprecated
    public boolean isInterTenantControlEnabled() {
        Boolean retval = (Boolean)this.getGlobal(ENABLE_INTER_TENANT_CONTROL);
        return retval == null ? false : retval;
    }

    public boolean isSipUserImplicitSequencingEnabled() {
        Boolean retval = (Boolean)this.getGlobal(SIP_USER_IMPLICIT_SEQUENCING);
        return retval == null ? false : retval;
    }

    public boolean isEndToEndSecureIndicatorEnabled() {
        String retval = (String)this.getGlobal(END_TO_END_SECURE_INDICATOR);
        return "true".equals(retval);
    }

    public boolean isCACEnabled() {
        Boolean retval = null;
        Boolean enableCAC = (Boolean)this.getGlobal("enable_cac");
        if (enableCAC instanceof String) {
            retval = Boolean.valueOf((String)((Object)enableCAC));
        } else if (enableCAC instanceof Boolean) {
            retval = enableCAC;
        } else {
            return true;
        }
        return retval == null ? true : retval;
    }

    public boolean isIPv6Enabled() {
        Boolean retval = null;
        Object enableIPv6 = this.getGlobal(IPV6_ENABLED);
        if (enableIPv6 instanceof String) {
            retval = Boolean.valueOf((String)enableIPv6);
        } else if (enableIPv6 instanceof Boolean) {
            retval = (Boolean)enableIPv6;
        } else {
            return true;
        }
        return retval == null ? true : retval;
    }

    public boolean isDODEnabled() {
        Boolean retval = null;
        Object enableDOD = this.getGlobal(DOD_ENABLED);
        if (enableDOD instanceof String) {
            retval = Boolean.valueOf((String)enableDOD);
        } else if (enableDOD instanceof Boolean) {
            retval = (Boolean)enableDOD;
        } else {
            return true;
        }
        return retval == null ? true : retval;
    }

    public boolean isEmerAppSeqEnabled() {
        Boolean retval = null;
        Object enableEmerAppSeq = this.getGlobal(EMER_APPSEQ_ENABLED);
        if (enableEmerAppSeq instanceof String) {
            retval = Boolean.valueOf((String)enableEmerAppSeq);
        } else if (enableEmerAppSeq instanceof Boolean) {
            retval = (Boolean)enableEmerAppSeq;
        } else {
            return true;
        }
        return retval == null ? false : retval;
    }

    public boolean isCallResiliencyEnabled() {
        Boolean retval = null;
        Object enableCallResiliency = this.getGlobal(CALL_RESILIENCY_ENABLED);
        if (enableCallResiliency instanceof String) {
            retval = Boolean.valueOf((String)enableCallResiliency);
        } else if (enableCallResiliency instanceof Boolean) {
            retval = (Boolean)enableCallResiliency;
        } else {
            return false;
        }
        return retval == null ? false : retval;
    }

    public boolean isRegExpAdaptationEnabled() {
        Boolean retval = null;
        Object enableRegExpAdaptationEnabled = this.getGlobal(ENABLE_REGEXPBASED_ADAPTATION);
        if (enableRegExpAdaptationEnabled instanceof String) {
            retval = Boolean.valueOf((String)enableRegExpAdaptationEnabled);
        } else if (enableRegExpAdaptationEnabled instanceof Boolean) {
            retval = (Boolean)enableRegExpAdaptationEnabled;
        } else {
            return false;
        }
        return retval == null ? false : retval;
    }

    public boolean isFlexibleRoutingEnabled() {
        Boolean retval = null;
        Object enableFlexibleRouting = this.getGlobal(FLEXIBLE_ROUTING_ENABLED);
        if (enableFlexibleRouting instanceof String) {
            retval = Boolean.valueOf((String)enableFlexibleRouting);
        } else if (enableFlexibleRouting instanceof Boolean) {
            retval = (Boolean)enableFlexibleRouting;
        } else {
            return false;
        }
        return retval == null ? false : retval;
    }

    public String getFlexibleRoutingRulesPrecedence() {
        Object flexibleRoutingRulesPrecedence = this.getGlobal(FLEXIBLE_ROUTING_RULES_PRECEDENCE);
        if (flexibleRoutingRulesPrecedence instanceof String) {
            return (String)flexibleRoutingRulesPrecedence;
        }
        return null;
    }

    public String getFlexibleRoutingMatchPrecedence() {
        Object flexibleRoutingMatchPrecedence = this.getGlobal(FLEXIBLE_ROUTING_MATCH_PRECEDENCE);
        if (flexibleRoutingMatchPrecedence instanceof String) {
            return (String)flexibleRoutingMatchPrecedence;
        }
        return null;
    }

    public byte[] getJGroupsKeystore() {
        byte[] retval = null;
        try {
            this.lock.acquireReadLock();
            if (this.globalMap.containsKey(this.myInstanceId)) {
                retval = (byte[])this.globalMap.get(this.myInstanceId).get(JGROUPS_KEY_FILE);
            }
            if (retval == null && this.globalMap.containsKey(null)) {
                retval = (byte[])this.globalMap.get(null).get(JGROUPS_KEY_FILE);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retval == null) {
            JGroupsKeystoreException ex = new JGroupsKeystoreException("The JGroups keystore is not in the Global DAO.  Initial replication may not be complete.");
            GenericAlarmHandler.handleFailureEvent(this, ex);
            return null;
        }
        return retval;
    }

    public byte[] getJBossJGroupsKeystore(String key) {
        String retval = null;
        try {
            this.lock.acquireReadLock();
            if (this.globalMap.containsKey(this.myInstanceId)) {
                retval = (String)this.globalMap.get(this.myInstanceId).get(key);
            }
            if (retval == null && this.globalMap.containsKey(null)) {
                retval = (String)this.globalMap.get(null).get(key);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retval == null) {
            JGroupsKeystoreException ex = new JGroupsKeystoreException("The JGroups keystore " + key + " is not in the Global DAO.  Initial replication may not be complete.");
            GenericAlarmHandler.handleFailureEvent(this, ex);
            return null;
        }
        return this.decodeJbossJgroupKey(retval);
    }

    private byte[] decodeJbossJgroupKey(String encodedKey) {
        String fcn_name = "decodeJbossJgroupKey";
        byte[] decodedValue = null;
        try {
            decodedValue = Base64.decodeBase64((byte[])Hex.decodeHex((char[])encodedKey.toCharArray()));
        }
        catch (DecoderException e) {
            log.error((Object)"decodeJbossJgroupKeyException while decoding Jboss jgroup key ", (Throwable)e);
        }
        return decodedValue;
    }

    public byte[] getJGroupsKeystore(String key) {
        byte[] retval = null;
        if (key.equals(JGROUPS_KEY_FILE_JBOSS)) {
            return this.getJBossJGroupsKeystore(key);
        }
        try {
            this.lock.acquireReadLock();
            if (this.globalMap.containsKey(this.myInstanceId)) {
                retval = (byte[])this.globalMap.get(this.myInstanceId).get(key);
            }
            if (retval == null && this.globalMap.containsKey(null)) {
                retval = (byte[])this.globalMap.get(null).get(key);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retval == null) {
            JGroupsKeystoreException ex = new JGroupsKeystoreException("The JGroups keystore " + key + " is not in the Global DAO.  Initial replication may not be complete.");
            GenericAlarmHandler.handleFailureEvent(this, ex);
            return null;
        }
        return retval;
    }

    @SMConsole(parameterNames={"name"}, description="Get the value used for a given global parameter name.")
    public Object getGlobal(String name) {
        return this.getGlobalParameter(name, new String[0]);
    }

    @SMConsole(description="Get all data in the AsmGlobalParm and AsmProvParm tables.")
    public Map<String, Map<String, Object>> getAllGlobalParameters() {
        try {
            this.lock.acquireReadLock();
            Map<String, Map<String, Object>> map = this.globalMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGlobalParameter(String name, String ... instances) {
        Object retval = null;
        try {
            this.lock.acquireReadLock();
            ArrayList<String> instanceList = new ArrayList<String>();
            for (String instance : instances) {
                instanceList.add(instance);
            }
            if (instanceList.isEmpty() && this.myInstanceId != null) {
                instanceList.add(this.myInstanceId.toString());
            }
            for (String instance : instanceList) {
                if (!this.globalMap.containsKey(instance) || (retval = this.globalMap.get(instance).get(name)) == null) continue;
                Object object = retval;
                return object;
            }
            if (this.globalMap.containsKey(null)) {
                retval = this.globalMap.get(null).get(name);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retval;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmInstance || newObject instanceof AsmInstance) {
            AsmInstance myInstance = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyAsmInstance();
            this.myInstanceId = myInstance == null ? null : Long.valueOf(myInstance.getId());
            this.updateDAO(new DAOTableEvent("asmglobalparm", DAOReplicationEvent.OperationType.UPDATE, -1L));
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    @Override
    protected boolean isCorrected(GenericAlarm alarm) {
        if (JGroupsKeystoreAlarm.class.equals(alarm.getClass())) {
            return this.getJGroupsKeystore() != null;
        }
        return super.isCorrected(alarm);
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("writeks".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    boolean writeKeyStore = Boolean.parseBoolean(value);
                    if (!writeKeyStore) continue;
                    this.createKeyStore = writeKeyStore;
                    reinit = true;
                }
            }
            if (!"writejbossks".equals(((String)entry.getKey()).toLowerCase())) continue;
            for (String value : (Set)entry.getValue()) {
                boolean writeJbossKeyStore = Boolean.parseBoolean(value);
                if (!writeJbossKeyStore) continue;
                this.createJbossKeyStore = writeJbossKeyStore;
                reinit = true;
            }
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected boolean setupJgroupsSecurity(boolean createFile) {
        if (!createFile) {
            log.info((Object)"Application will not update or create keystore.");
            return false;
        }
        boolean resp = this.setupJgroupsSecurity(JGROUPS_KEY_FILE, JG_KEYSTORE_FILE);
        return resp;
    }

    protected boolean setupJbossJgroupsSecurity(boolean createFile) {
        if (!createFile) {
            log.info((Object)"Application will not update or create Jboss keystore.");
            return false;
        }
        boolean resp = this.setupJgroupsSecurity(JGROUPS_KEY_FILE_JBOSS, JG_KEYSTORE_FILE_JBOSS);
        return resp;
    }

    private boolean setupJgroupsSecurity(String dbkey, String filePath) {
        byte[] dbBytes = this.getJGroupsKeystore(dbkey);
        if (dbBytes == null || dbBytes.length <= 0) {
            log.warn((Object)"Asked to write out an empty keystore.");
            return false;
        }
        File ksFile = new File(filePath);
        try {
            if (!ksFile.exists()) {
                if (this.writeKeyStore(ksFile, dbBytes)) {
                    log.info((Object)("Created new jgroups keystore: " + this.getFileMD5(new FileInputStream(ksFile))));
                    return true;
                }
            } else {
                String dbHash;
                String currentHash = this.getFileMD5(new FileInputStream(ksFile));
                if (!currentHash.equals(dbHash = this.getFileMD5(new ByteArrayInputStream(dbBytes)))) {
                    log.info((Object)("Found new keystore: " + dbHash + ", old was: " + currentHash));
                    if (this.writeKeyStore(ksFile, dbBytes)) {
                        log.info((Object)("Updated keystore: " + dbHash));
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to setup Jgroups Security stack. Initial Load may not be complete", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileMD5(InputStream is) {
        if (is == null) {
            return null;
        }
        String output = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            int read = 0;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            output = bigInt.toString(16);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to calculate MD5 Digest.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeKeyStore(File file, byte[] bytes) {
        OutputStream out = null;
        try {
            out = new FileOutputStream(file.getAbsoluteFile(), false);
            out.write(bytes);
        }
        catch (IOException e) {
            log.error((Object)"Exception writing out jgroups keystore", (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMD5HashJGroupsKeyStore() {
        String md5Hash = null;
        if (this.createJbossKeyStore) {
            md5Hash = this.getMD5HashJGroupsKeyStore(DDLInterClusterHelper.KeystoreType.JBOSS);
            return md5Hash;
        }
        File ksFile = new File(JG_KEYSTORE_FILE);
        if (ksFile.exists() && ksFile.length() > 0L) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(ksFile);
                md5Hash = this.getFileMD5(is);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return md5Hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMD5HashJGroupsKeyStore(DDLInterClusterHelper.KeystoreType kstype) {
        String md5Hash = null;
        String ksFilePath = kstype.equals((Object)DDLInterClusterHelper.KeystoreType.WAS) ? JG_KEYSTORE_FILE : JG_KEYSTORE_FILE_JBOSS;
        File ksFile = new File(ksFilePath);
        if (ksFile.exists() && ksFile.length() > 0L) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(ksFile);
                md5Hash = this.getFileMD5(is);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return md5Hash;
    }

    public String getClientMutualAuthentication() {
        return (String)this.getGlobal(CLIENT_MUTUAL_AUTHENTICATION);
    }

    public String getEnableStorageCluster() {
        return (String)this.getGlobal(ENABLE_STORAGE_CLUSTER);
    }

    public String getUStoreClientUser() {
        return (String)this.getGlobal(USTORE_CLIENT_USER);
    }

    public String getUStoreClientPassword() {
        return (String)this.getGlobal(USTORE_CLIENT_PASSWORD);
    }

    public String getUStoreSuperUser() {
        return (String)this.getGlobal(USTORE_SUPER_USER);
    }

    public String getUStoreSuperPassword() {
        return (String)this.getGlobal(USTORE_SUPER_PASSWORD);
    }

    public String getSipEntityTlsVersion() {
        return (String)this.getGlobal(SIPENTITY_TLS_VERSION);
    }

    public String getEndptTlsVersion() {
        return (String)this.getGlobal(ENDPT_TLS_VERSION);
    }

    public String getPPMCommonDeviceDataParameters() {
        return (String)this.getGlobal(COMMON_DEVICE_DATA_PARAMETERS);
    }

    public String getCallLogRetentionSeconds() {
        return (String)this.getGlobal("calllog.retention.seconds");
    }

    public String getLogRetentionDays() {
        return (String)this.getGlobal(LOG_RETENTION_DAYS);
    }

    public boolean isVisitingBsmEnabled() {
        String retval = (String)this.getGlobal(VISITING_BSM_ENABLED);
        return "true".equals(retval);
    }

    public boolean isDynamicSMPolicyEnabled() {
        String retval = (String)this.getGlobal(DYNAMIC_SM_POLICY_ENABLED);
        return "true".equals(retval);
    }

    public boolean isPushNotificationEnabled() {
        String retval = (String)this.getGlobal(PUSH_NOTIFICATION_ENABLED);
        return "true".equals(retval);
    }

    public String getPushNotificationEC500Delay() {
        return (String)this.getGlobal(PUSH_NOTIFICATION_EC500_DELAY);
    }

    public String getLoadFactorAlarmThreshold() {
        return (String)this.getGlobal(LOAD_FACTOR_ALARM_THRESHOLD);
    }

    public String getHttpsForwardProxyHost() {
        return (String)this.getGlobal(HTTPS_FORWARD_PROXY_HOST);
    }

    public Integer getHttpsForwardProxyPort() {
        Integer port;
        String portString = (String)this.getGlobal(HTTPS_FORWARD_PROXY_PORT);
        if (portString == null) {
            return null;
        }
        try {
            port = Integer.valueOf(portString);
        }
        catch (NumberFormatException e) {
            port = null;
        }
        return port;
    }
}

