/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.dao.LocalSipObjectDAO;
import com.avaya.asm.datamgr.objectapi.LocalObject;
import com.avaya.asm.datamgr.objectapi.LocalUser;
import java.util.Collection;
import java.util.Collections;

public class LocalUserDAO
extends LocalSipObjectDAO {
    protected String getLocalIDsQuery = "SELECT u.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, dyn_asmcommprofile dasm WHERE u.id = set.csuserid AND set.id = cs.cscommprofilesetid AND u.isDeleted = false AND cs.id = asm.id AND dasm.id = asm.id AND dasm.is_local = true";
    protected String getDeletedByUserIdQuery = "SELECT u.isdeleted, u.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, dyn_asmcommprofile dasm WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND cs.commprofiletype = 'SIP' AND asm.id = cs.id AND dasm.id = asm.id AND dasm.is_local = true AND u.id = ?";
    protected String isLocalQuery = this.getLocalIDsQuery + " AND asm.id = ?";

    @Override
    protected LocalObject construct(long id) {
        return new LocalUser(id);
    }

    @Override
    protected String getMainTable() {
        return "csuser";
    }

    @SMConsole(description="Print a list of all local CsUser IDs. This list will contain duplicates if CsUsers have multiple CommProfileSets under them.")
    public Collection<Long> getLocalUserIDs() {
        this.lock.acquireReadLock();
        try {
            Collection<Long> collection = Collections.unmodifiableCollection(this.mainCollection.values());
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected String getLocalIDsQuery() {
        return this.getLocalIDsQuery;
    }

    @Override
    protected String isLocalQuery() {
        return this.isLocalQuery;
    }

    @Override
    protected String getDeletedByUserIdQuery() {
        return this.getDeletedByUserIdQuery;
    }

    public static void main(String[] args) {
        LocalUserDAO dao = new LocalUserDAO();
        dao.printQueries();
    }
}

