/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.LoadBalancerPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.datastax.driver.core.PreparedStatement;

public class LoadBalancerPreparedStatements
extends PreparedStatements<LoadBalancerPreparedStatementType> {
    public static final String KEYSPACE = "loadbalancer";
    public static final String TABLE = "loadbalancer.resolvedaddress";
    private static final String PARTITION_KEY_FILTER = " WHERE loadbalancer_id=? AND key=?";
    private static final String GET_RESOLVED_ADDRESS = "SELECT resolved_address FROM loadbalancer.resolvedaddress";
    private static final String UPDATE_RESOLVED_ADDRESS_QRY = "UPDATE loadbalancer.resolvedaddress SET resolved_address= ? WHERE loadbalancer_id=? AND key=?";
    private static final String EXPECTED_ADDRESS_CONDITION = "IF resolved_address=?";
    private static final String EXIST_CONDITION = "IF EXISTS";
    private static final String GET_RESOLVED_ADDRESS_ALL = "SELECT loadbalancer_id,key,resolved_address FROM loadbalancer.resolvedaddress LIMIT ?";
    private static final String RESOLVED_ADDRESS_BY_LOADBALANCERID = "Select loadbalancer_id,key,resolved_address FROM loadbalancer.resolvedaddress WHERE loadbalancer_id=? LIMIT ? ALLOW FILTERING";
    private static final String BULK_RESOLVED_ADDRESS_BY_LOADBALANCERID = "SELECT loadbalancer_id,key,resolved_address FROM loadbalancer.resolvedaddress WHERE loadbalancer_id=? and token(loadbalancer_id,key) > token(?,?) LIMIT ? ALLOW FILTERING";
    public static final String DELETE_RESOLVED_ADDRESSES = "DELETE FROM loadbalancer.resolvedaddress WHERE loadbalancer_id = ? AND key IN ?";
    private static final String GET_KEYS = "SELECT loadbalancer_id,key FROM loadbalancer.resolvedaddress WHERE resolved_address=? AND loadbalancer_id=? LIMIT ? ALLOW FILTERING";
    private static final String GET_KEYS_START_TOKEN = "SELECT loadbalancer_id,key FROM loadbalancer.resolvedaddress WHERE resolved_address=? AND loadbalancer_id=? AND TOKEN(loadbalancer_id,key) > TOKEN(?,?) LIMIT ? ALLOW FILTERING";
    private static final String GET_All_KEYS_BULK_READ = "SELECT loadbalancer_id,key FROM loadbalancer.resolvedaddress WHERE resolved_address=?";
    private static final String GET_ALL_BOUNDED = "SELECT loadbalancer_id,key,resolved_address FROM loadbalancer.resolvedaddress WHERE token(loadbalancer_id, key) < ? LIMIT ?";
    private static final String GET_ALL_START_TOKEN_UNBOUNDED = "SELECT loadbalancer_id, key, resolved_address FROM loadbalancer.resolvedaddress WHERE token(loadbalancer_id, key) >= ? LIMIT ?";
    private static final String GET_ALL_START_KEY_UNBOUNDED = "SELECT loadbalancer_id, key, resolved_address FROM loadbalancer.resolvedaddress WHERE token(loadbalancer_id, key) >= token(?, ?) LIMIT ?";
    private static final String GET_ALL_START_TOKEN_BOUNDED = "SELECT loadbalancer_id, key, resolved_address FROM loadbalancer.resolvedaddress WHERE token(loadbalancer_id, key) >= ? AND token(loadbalancer_id, key) < ? LIMIT ?";
    private static final String GET_ALL_START_KEY_BOUNDED = "SELECT loadbalancer_id, key, resolved_address FROM loadbalancer.resolvedaddress WHERE token(loadbalancer_id, key) >= token(?, ?) AND token(loadbalancer_id, key) < ? LIMIT ?";

    public LoadBalancerPreparedStatements(SessionDAO dao) {
        super(LoadBalancerPreparedStatementType.class, dao);
    }

    @Override
    protected PreparedStatement prepareStatement(LoadBalancerPreparedStatementType queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        StringBuilder query = new StringBuilder();
        switch (queryType) {
            case QUERY_RESOLVED_ADDRESS: {
                query.append(GET_RESOLVED_ADDRESS);
                query.append(PARTITION_KEY_FILTER);
                break;
            }
            case SET_RESOLVED_ADDRESS: {
                query.append(UPDATE_RESOLVED_ADDRESS_QRY);
                break;
            }
            case CONDITIONAL_SET_RESOLVED_ADDRESS: {
                query.append(UPDATE_RESOLVED_ADDRESS_QRY);
                query.append(' ');
                query.append(EXPECTED_ADDRESS_CONDITION);
                break;
            }
            case GET_All_RESOLVED_ADDRESS: {
                query.append(GET_RESOLVED_ADDRESS_ALL);
                break;
            }
            case DELETE_RESOLVED_ADDRESSES: {
                query.append(DELETE_RESOLVED_ADDRESSES);
                break;
            }
            case GET_KEYS: {
                query.append(GET_KEYS);
                break;
            }
            case GET_KEYS_START_TOKEN: {
                query.append(GET_KEYS_START_TOKEN);
                break;
            }
            case RESOLVED_ADDRESS_BY_LOADBALANCERID: {
                query.append(RESOLVED_ADDRESS_BY_LOADBALANCERID);
                break;
            }
            case BULK_RESOLVED_ADDRESS_BY_LOADBALANCERID: {
                query.append(BULK_RESOLVED_ADDRESS_BY_LOADBALANCERID);
                break;
            }
            case GET_All_KEYS_BULK_READ: {
                query.append(GET_All_KEYS_BULK_READ);
                break;
            }
            case GET_ALL_BOUNDED: {
                query.append(GET_ALL_BOUNDED);
                break;
            }
            case GET_ALL_START_TOKEN_UNBOUNDED: {
                query.append(GET_ALL_START_TOKEN_UNBOUNDED);
                break;
            }
            case GET_ALL_START_KEY_UNBOUNDED: {
                query.append(GET_ALL_START_KEY_UNBOUNDED);
                break;
            }
            case GET_ALL_START_TOKEN_BOUNDED: {
                query.append(GET_ALL_START_TOKEN_BOUNDED);
                break;
            }
            case GET_ALL_START_KEY_BOUNDED: {
                query.append(GET_ALL_START_KEY_BOUNDED);
            }
        }
        return this.prepareQuery(query.toString(), keyspaceBuilder);
    }
}

