/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.UstoreUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class UserStoreKeyspaceBuilder {
    private static final Logger log = AsmLogger.getLogger(UserStoreKeyspaceBuilder.class);
    private final UserStoreKeyspace keyspace;

    public UserStoreKeyspaceBuilder(UserStoreKeyspace keyspace) {
        this.keyspace = keyspace;
    }

    public abstract boolean createColumnFamilies(SessionDAO var1) throws DMException;

    public final synchronized void createKeyspace(SessionDAO dao) throws DMException {
        String query;
        String fcn_name = "createKeyspace";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)(fcn_name + ": creating keyspace: " + this.keyspace));
        }
        if ((query = this.buildKeyspaceQuery("CREATE KEYSPACE IF NOT EXISTS")) == null) {
            String msg = fcn_name + ": No query available to build missing keyspace " + this.keyspace;
            log.error((Object)msg);
            throw new DMException(msg);
        }
        if (isFiner) {
            log.finer((Object)(fcn_name + ": The query to be executed: " + query));
        }
        dao.executeQuery(query);
    }

    public final synchronized void alterKeyspace(SessionDAO dao) throws DMException {
        String fcn_name = "createKeyspace";
        if (log.isFinerEnabled()) {
            log.finer((Object)(fcn_name + ": creating keyspace: " + this.keyspace));
        }
        String query = this.buildKeyspaceQuery("ALTER KEYSPACE");
        if (log.isFinerEnabled()) {
            log.finer((Object)(fcn_name + ": The query to be executed: " + query));
        }
        dao.executeQuery(query);
    }

    protected String buildKeyspaceQuery(String operation) throws DMException {
        String fcn_name = "buildKeyspaceQuery";
        if (this.keyspace == null) {
            log.warn((Object)"buildKeyspaceQuery: cannot create keyspace when the keyspace object is null.");
            throw new DMException("buildKeyspaceQuery: cannot create keyspace when the keyspace object is null.");
        }
        StringBuilder query = new StringBuilder(operation);
        query.append(' ');
        query.append(this.keyspace.toString());
        query.append(" WITH ");
        this.buildReplicationStrategyParm(query);
        return query.toString();
    }

    protected void buildReplicationStrategyParm(StringBuilder query) throws DMException {
        String fcn_name = "buildReplicationStrategyParm";
        query.append("REPLICATION = {'class' : 'com.avaya.asm.cassandra.locator.SMNodeSpecificReplicationStrategy', 'endpoints' : '");
        List<AsmInstance> instances = this.keyspace.getAsmInstances();
        if (instances == null) {
            throw new DMException("buildReplicationStrategyParm: cannot create keyspace from null AsmInstances");
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("buildReplicationStrategyParm: the query before adding the Asm Instances: " + query + ": number of asminstances: " + instances.size() + ": " + this.keyspace.getAsmInstances()));
        }
        boolean addComma = false;
        for (AsmInstance instance : this.keyspace.getAsmInstances()) {
            if (addComma) {
                query.append(",");
            }
            addComma = true;
            String ipAddr = UstoreUtils.asmInstanceToIpAddr(instance);
            query.append(ipAddr);
        }
        query.append("'}");
    }

    protected List<String> insertKeyspaceIntoCommand(List<String> allCommands) throws DMException {
        if (allCommands == null) {
            return null;
        }
        ArrayList<String> allUpdatedCommands = new ArrayList<String>();
        for (String command : allCommands) {
            if (command.contains("__KEYSPACE__")) {
                command = command.replaceFirst("__KEYSPACE__", this.keyspace.getName());
            }
            allUpdatedCommands.add(command);
        }
        return allUpdatedCommands;
    }

    public UserStoreKeyspace getKeyspace() {
        return this.keyspace;
    }
}

