/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.jdbc;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.jdbc.DaoConnection;
import com.avaya.common.logging.client.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class DaoConnectionPool {
    private static final Logger log = AsmLogger.getLogger(DaoConnectionPool.class);
    protected String user;
    protected String password;
    protected String url;
    protected String driverClass;
    protected int poolSize = 0;
    protected int currentPoolSize = 0;
    protected int queryTimeout = 0;
    protected int retries = 0;
    protected ArrayList<DaoConnection> connections = new ArrayList();

    public void setPoolSize(int size) {
        if (size < 0) {
            log.error((Object)"Invalid pool size, must be a positive integer");
            this.poolSize = 0;
            return;
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("Setting initial queue size to " + size));
        }
        this.poolSize = size;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setQueryTimeout(int tm) {
        this.queryTimeout = tm;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializePool() {
        log.info((Object)("Initializing connection pool to " + this.url + " with " + this.poolSize + " connections"));
        for (int ix = 0; ix < this.poolSize; ++ix) {
            try {
                DaoConnection conn = this.newConnection();
                ArrayList<DaoConnection> arrayList = this.connections;
                synchronized (arrayList) {
                    this.connections.add(conn);
                }
                ++this.currentPoolSize;
                continue;
            }
            catch (DMException e) {
                log.warn((Object)("Exception while initializing " + this.url + " pool"), (Throwable)e);
            }
        }
        log.info((Object)(this.url + " connection pool initialized. Pool size is " + this.currentPoolSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaoConnection getConnection() throws DMException {
        ArrayList<DaoConnection> arrayList = this.connections;
        synchronized (arrayList) {
            if (this.connections.size() == 0) {
                if (this.currentPoolSize >= this.poolSize) {
                    throw new DMException("Database connection limit exceeded");
                }
                DaoConnection conn = this.newConnection();
                ++this.currentPoolSize;
                if (log.isFinerEnabled()) {
                    log.finer((Object)("Current " + this.url + " connection pool size = " + this.currentPoolSize));
                }
                return conn;
            }
            if (log.isFinestEnabled()) {
                log.finest((Object)"getConnection: returning connection from pool");
            }
            return this.connections.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(DaoConnection conn) {
        ArrayList<DaoConnection> arrayList = this.connections;
        synchronized (arrayList) {
            if (log.isFinestEnabled()) {
                log.finest((Object)"adding connection back to pool");
            }
            this.connections.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        if (log.isFineEnabled()) {
            log.fine((Object)"closing all connections");
        }
        ArrayList<DaoConnection> arrayList = this.connections;
        synchronized (arrayList) {
            Iterator<DaoConnection> iter = this.connections.iterator();
            while (iter.hasNext()) {
                DaoConnection dconn = iter.next();
                Connection jconn = dconn.getJdbcConnection();
                try {
                    if (log.isFineEnabled()) {
                        log.fine((Object)("closing JDBC connection " + jconn));
                    }
                    jconn.close();
                    iter.remove();
                }
                catch (SQLException e) {
                    log.warn((Object)"Exception closing all connections", (Throwable)e);
                }
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)"connections closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (log.isFineEnabled()) {
            log.fine((Object)"resetting all connections");
        }
        ArrayList<DaoConnection> arrayList = this.connections;
        synchronized (arrayList) {
            for (DaoConnection dconn : this.connections) {
                if (dconn.reset()) {
                    if (!log.isFineEnabled()) continue;
                    log.fine((Object)("reset OK for " + dconn));
                    continue;
                }
                if (!log.isFineEnabled()) continue;
                log.fine((Object)("reset FAILED for " + dconn));
            }
        }
    }

    public String toString() {
        return "{DaoConnectionPoolImpl url=" + (this.url == null ? "not set" : this.url) + "}";
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDriverClass(String driverClass) throws DMException {
        try {
            Class.forName(driverClass);
            this.driverClass = driverClass;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("unable to load driver class " + driverClass), (Throwable)e);
            throw new DMException("error loading driver class", e);
        }
    }

    protected DaoConnection newConnection() throws DMException {
        if (this.user == null || this.url == null) {
            throw new DMException("getConnection: missing database url or user parameter");
        }
        if (this.password == null) {
            this.password = "";
        }
        try {
            if (log.isFinerEnabled()) {
                log.finer((Object)"getting new connection from driver manager");
            }
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            DaoConnection dconn = new DaoConnection(conn, this);
            return dconn;
        }
        catch (SQLException ex) {
            throw new DMException("failed to get connection", ex);
        }
    }

    protected Connection getJdbcConnection() throws DMException {
        try {
            if (log.isFinerEnabled()) {
                log.finer((Object)"getting new connection from driver manager");
            }
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            return conn;
        }
        catch (SQLException ex) {
            throw new DMException("failed to get connection", ex);
        }
    }
}

