/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactAddressDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(ContactAddressDAO.class);
    private Map<Long, String> contactCategoryNamesMap = new HashMap<Long, String>();
    private Map<Long, String> contactTypeNamesMap = new HashMap<Long, String>();
    public static final String getAllContactCategoryNames = "SELECT id, name FROM cscontactcategoryenum";
    public static final String getContactCategoryName = "SELECT name FROM cscontactcategoryenum WHERE id = ?";
    public static final String getAllContactTypeNames = "SELECT id, name FROM cscontacttypeenum";
    public static final String getContactTypeName = "SELECT name  FROM cscontacttypeenum WHERE id = ?";
    public static final String getIdsFromContactAddressId = "SELECT cscontactid, csprivatecontactinfoid from cscontactaddress where id=:Id";
    private static final ResultSetMapper namesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, rs.getString("name"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper nameMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getString("name");
            }
            return null;
        }
    };
    private static final ResultSetMapper idsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                Long contactId = rs.getLong("cscontactid");
                Long pciId = rs.getLong("csprivatecontactinfoid");
                list.add(contactId);
                list.add(pciId);
            }
            return list;
        }
    };

    protected ResultSetMapper getNamesMapper() {
        return namesMapper;
    }

    protected ResultSetMapper getNameMapper() {
        return nameMapper;
    }

    protected ResultSetMapper getIdsMapper() {
        return idsMapper;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cscontactcategoryenum");
        list.add("cscontacttypeenum");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = ContactAddressDAO.class.getSimpleName() + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        Long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        boolean lockHeld = false;
        try {
            String name = null;
            Object contactAddress = null;
            Object[] params = new Object[]{id};
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                name = (String)this.dataSource.executeQuery(getContactCategoryName, params, this.getNameMapper());
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            if (tableName.equals("cscontactcategoryenum")) {
                name = this.contactCategoryNamesMap.remove(id);
                if (name == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                    log.warn((Object)(fcn_name + ": name was null for " + (Object)((Object)tableEvent.getOperation()) + " operation with id of: " + id + "; we are probably out of sync"));
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE && name != null) {
                    if (isFiner) {
                        log.finer((Object)("Retrieved new name: " + name + "for id = " + id));
                    }
                    this.contactCategoryNamesMap.put(id, name);
                }
            }
            if (tableName.equals("cscontacttypeenum")) {
                name = null;
                name = this.contactTypeNamesMap.remove(id);
                if (name == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                    log.warn((Object)(fcn_name + ": name was null for " + (Object)((Object)tableEvent.getOperation()) + " operation with id of: " + id + "; we are probably out of sync"));
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE && (name = (String)this.dataSource.executeQuery(getContactTypeName, params, this.getNameMapper())) != null) {
                    if (isFiner) {
                        log.finer((Object)("Retrieved new name: " + name + "for id = " + id));
                    }
                    this.contactTypeNamesMap.put(id, name);
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing. e = "), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " update successful"));
            }
        }
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap contactTypeNamesMapTMP;
        HashMap contactCategoryNamesMapTMP;
        String fcn_name = ContactAddressDAO.class.getSimpleName() + ".init: ";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)fcn_name);
        }
        Object[] params = new Object[]{};
        try {
            contactCategoryNamesMapTMP = (HashMap)this.dataSource.executeChunkedQuery(getAllContactCategoryNames, params, this.getNamesMapper(), 10000, 30000L);
            contactTypeNamesMapTMP = (HashMap)this.dataSource.executeChunkedQuery(getAllContactTypeNames, params, this.getNamesMapper(), 10000, 30000L);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)(fcn_name + "Error "), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.contactCategoryNamesMap = contactCategoryNamesMapTMP;
                this.contactTypeNamesMap = contactTypeNamesMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    public String getContactCategoryName(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null && this.contactCategoryNamesMap.containsKey(id)) {
                String string = this.contactCategoryNamesMap.get(id);
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    public String getContactTypeName(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null && this.contactTypeNamesMap.containsKey(id)) {
                String string = this.contactTypeNamesMap.get(id);
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    public List<Long> getIdsFromCsContactAddressId(Long csContactAddressId) {
        String fcn_name = "getIdsFromCsContactAddressId";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)"getIdsFromCsContactAddressId");
        }
        List contactIdsList = null;
        Object[] params = new Object[]{};
        String query = getIdsFromContactAddressId.replaceAll(":Id", Long.toString(csContactAddressId));
        try {
            contactIdsList = (List)this.dataSource.executeChunkedQuery(query, params, this.getIdsMapper(), 10000, 30000L);
        }
        catch (DMException e) {
            log.error((Object)("getIdsFromCsContactAddressId: Caught DMException " + e), (Throwable)e);
        }
        return contactIdsList;
    }

    @Override
    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }
}

