/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BatchStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.NullUserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SMInfoPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.SMInfoPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.SMInfo;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;

public class SMInfoDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(SMInfoDAO.class);
    protected SMInfoPreparedStatements preparedStatements;
    static final String BOOT_TIME_NAME = "bootTime";
    static final String MGMT_PORT_HOSTNAME_NAME = "mgmtPortHostName";
    static final String NUM_CPUS_NAME = "numCPUs";
    static final String RAM_SIZE_NAME = "ramSize";
    static final String SM_PROFILE_NAME = "smProfile";
    static final String SW_VERSION_NAME = "swVersion";
    static final String CASSANDRA_HOSTID_NAME = "cassandraHostId";
    static final String AADS_VERSION = "aadsVersion";
    private UserStoreKeyspaceBuilder ksBuilder = new NullUserStoreKeyspaceBuilder(new UserStoreKeyspace("global"));

    public SMInfoDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new SMInfoPreparedStatements(sessionDAO);
    }

    public void setSMInfo(SMInfo smInfo) throws DMException {
        String fcn_name = "setSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("setSMInfo: enter, smInfo=" + smInfo));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        SMInfoBatchStatementBuilder batchStmtBldr = this.createSetBatchStatementBuilder(smInfo);
        this.sessionDAO.executeStatement(batchStmtBldr);
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("setSMInfo: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
    }

    private SMInfoBatchStatementBuilder createSetBatchStatementBuilder(SMInfo smInfo) {
        String value;
        String fcn_name = "SMInfoBatchStatementBuilder";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("SMInfoBatchStatementBuilder: enter, smInfo=" + smInfo));
        }
        SMInfoBatchStatementBuilder batchStmtBldr = new SMInfoBatchStatementBuilder();
        long asmInstId = smInfo.getAsmInstId();
        Date bootTime = smInfo.getBootTime();
        if (bootTime != null) {
            value = Long.toUnsignedString(bootTime.getTime() / 1000L);
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, BOOT_TIME_NAME, value);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing bootTime because value is null");
        }
        String mgmtPortHostname = smInfo.getMgmtPortHostname();
        if (mgmtPortHostname != null) {
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, MGMT_PORT_HOSTNAME_NAME, mgmtPortHostname);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing mgmtPortHostName because value is null");
        }
        Integer numCPUs = smInfo.getNumCPUs();
        if (numCPUs != null) {
            value = Integer.toString(numCPUs);
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, NUM_CPUS_NAME, value);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing numCPUs because value is null");
        }
        Long ramSize = smInfo.getRamSize();
        if (ramSize != null) {
            value = Long.toUnsignedString(ramSize);
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, RAM_SIZE_NAME, value);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing ramSize because value is null");
        }
        String smProfile = smInfo.getSmProfile();
        if (smProfile != null) {
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, SM_PROFILE_NAME, smProfile);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing smProfile because value is null");
        }
        String swVersion = smInfo.getSwVersion();
        if (swVersion != null) {
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, SW_VERSION_NAME, swVersion);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing swVersion because value is null");
        }
        UUID cassHostId = smInfo.getCassandraHostId();
        if (cassHostId != null) {
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, CASSANDRA_HOSTID_NAME, cassHostId.toString());
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing cassandraHostId because value is null");
        }
        String aadsVersion = smInfo.getAadsVersion();
        if (aadsVersion != null) {
            batchStmtBldr.addToBatch(SMInfoPreparedStatementType.SET_SMINFO, asmInstId, AADS_VERSION, aadsVersion);
        } else if (isFinest) {
            this.log.finest((Object)"SMInfoBatchStatementBuilder: not storing aadsVersion because value is null");
        }
        if (isFiner) {
            this.log.finer((Object)"SMInfoBatchStatementBuilder: leave");
        }
        return batchStmtBldr;
    }

    public SMInfo getSMInfo(final long asmInstId) throws DMException {
        ResultSet rs;
        String fcn_name = "getSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSMInfo: enter, asmInstId=" + asmInstId));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        if ((rs = this.sessionDAO.executeStatement(new SMInfoStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = SMInfoDAO.this.preparedStatements.getPreparedStatement(SMInfoPreparedStatementType.GET_SMINFO, SMInfoDAO.this.ksBuilder);
                return ps.bind(new Object[]{asmInstId});
            }
        })).isExhausted()) {
            if (isFiner) {
                this.log.finer((Object)("getSMInfo: leave, no record found for asmInstId=" + asmInstId));
            }
            return null;
        }
        SMInfo smInfo = null;
        ArrayList<SMInfo> smInfoList = new ArrayList<SMInfo>(1);
        for (Row r : rs) {
            smInfo = this.getRowSMInfo(smInfoList, smInfo, r);
        }
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("getSMInfo: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        return smInfo;
    }

    public void getAllSMInfo(Collection<SMInfo> smInfoColl) throws DMException {
        ResultSet rs;
        String fcn_name = "getSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)"getSMInfo: enter");
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        if ((rs = this.sessionDAO.executeStatement(new SMInfoStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = SMInfoDAO.this.preparedStatements.getPreparedStatement(SMInfoPreparedStatementType.GET_ALL_SMINFO, SMInfoDAO.this.ksBuilder);
                return ps.bind();
            }
        })).isExhausted()) {
            if (isFiner) {
                this.log.finer((Object)"getSMInfo: leave, no records found");
            }
            return;
        }
        SMInfo curSmInfo = null;
        for (Row row : rs) {
            curSmInfo = this.getRowSMInfo(smInfoColl, curSmInfo, row);
        }
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("getSMInfo: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
    }

    public void deleteSMInfo(final long asmInstId) throws DMException {
        String fcn_name = "deleteSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteSMInfo: enter, asmInstId=" + asmInstId));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        this.sessionDAO.executeStatement(new SMInfoStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = SMInfoDAO.this.preparedStatements.getPreparedStatement(SMInfoPreparedStatementType.DELETE_SMINFO, SMInfoDAO.this.ksBuilder);
                return ps.bind(new Object[]{asmInstId});
            }
        });
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("deleteSMInfo: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
    }

    private SMInfo getRowSMInfo(Collection<SMInfo> smInfoList, SMInfo prevSmInfo, Row row) {
        String fcn_name = "getRowSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getRowSMInfo: enter, row=" + row));
        }
        long asmInstId = row.getLong("asmInstId");
        String name = row.getString("name");
        String value = row.getString("value");
        SMInfo smInfo = null;
        if (prevSmInfo != null && prevSmInfo.getAsmInstId() == asmInstId) {
            smInfo = prevSmInfo;
        } else {
            for (SMInfo itSmInfo : smInfoList) {
                if (itSmInfo.getAsmInstId() != asmInstId) continue;
                smInfo = itSmInfo;
                break;
            }
            if (smInfo == null) {
                smInfo = new SMInfo(asmInstId);
                smInfoList.add(smInfo);
                if (isFinest) {
                    this.log.finest((Object)("getRowSMInfo: adding smInfo=" + smInfo));
                }
            }
        }
        switch (name) {
            case "swVersion": {
                smInfo.setSwVersion(value);
                break;
            }
            case "ramSize": {
                try {
                    long lVal = Long.parseLong(value);
                    smInfo.setRamSize(lVal);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("getRowSMInfo: NumberFormatException thrown for ramSize: " + value), (Throwable)e);
                }
                break;
            }
            case "smProfile": {
                smInfo.setSmProfile(value);
                break;
            }
            case "numCPUs": {
                try {
                    int iVal = Integer.parseInt(value);
                    smInfo.setNumCPUs(iVal);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("getRowSMInfo: NumberFormatException thrown for numCPUs: " + value), (Throwable)e);
                }
                break;
            }
            case "mgmtPortHostName": {
                smInfo.setMgmtPortHostname(value);
                break;
            }
            case "bootTime": {
                try {
                    long lVal = Long.parseLong(value);
                    Date date = new Date(lVal * 1000L);
                    smInfo.setBootTime(date);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("getRowSMInfo: NumberFormatException thrown for boottime: " + value), (Throwable)e);
                }
                break;
            }
            case "cassandraHostId": {
                UUID uuid = null;
                try {
                    uuid = UUID.fromString(value);
                }
                catch (IllegalArgumentException e) {
                    this.log.error((Object)("getRowSMInfo: " + e.getClass().getSimpleName() + " caught when converting to UUID value=" + value));
                }
                smInfo.setCassandraHostId(uuid);
                break;
            }
            case "aadsVersion": {
                smInfo.setAadsVersion(value);
                break;
            }
            default: {
                if (!isFinest) break;
                this.log.finest((Object)("getRowSMInfo: Unexpected name " + name + " from SMInfo table"));
            }
        }
        if (isFiner) {
            this.log.finer((Object)("getRowSMInfo: leave, smInfo=" + smInfo));
        }
        return smInfo;
    }

    public class SMInfoBatchStatementBuilder
    extends BatchStatementBuilder<SMInfoPreparedStatementType> {
        public SMInfoBatchStatementBuilder() {
            super(SMInfoDAO.this.preparedStatements, SMInfoDAO.this.ksBuilder, BatchStatement.Type.UNLOGGED);
        }
    }

    public abstract class SMInfoStatementBuilder
    implements UserStoreStatementBuilder {
        @Override
        public abstract Statement getStatement() throws DMException;

        @Override
        public void newSession() {
            SMInfoDAO.this.preparedStatements.clearMap();
        }
    }
}

