/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.BlockingWaitNotifyQueue;
import com.avaya.asm.datamgr.datadistributionlayer.DDLProcessingIntfc;
import com.avaya.common.logging.client.Logger;
import java.util.Comparator;

public class DDLProcessingThread<E>
extends Thread {
    protected final Logger log = AsmLogger.getLogger(DDLProcessingThread.class);
    private DDLProcessingIntfc<E> callBack;
    private BlockingWaitNotifyQueue<E> messageQueue;
    private boolean canRun = false;

    public DDLProcessingThread(DDLProcessingIntfc<E> callBack) {
        super("DDLProcessingThread");
        this.callBack = callBack;
        this.messageQueue = new BlockingWaitNotifyQueue();
        this.canRun = true;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Created the DDL message processing thread " + this.getName() + "."));
        }
    }

    @Override
    public void run() {
        Object e = null;
        while (this.canRun) {
            try {
                e = this.messageQueue.poll();
                if (e == null) continue;
                this.callBack.execute(e);
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"Interrupted unexpectedly!", (Throwable)ex);
            }
            catch (Exception ex) {
                this.log.error((Object)("run() threw an exception: " + e), (Throwable)ex);
            }
        }
    }

    public int addToQueue(E e) {
        this.messageQueue.add(e);
        return this.messageQueue.size();
    }

    public void setMessageQueue(BlockingWaitNotifyQueue<E> messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void destroy() {
        this.canRun = false;
        this.messageQueue.stop();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Destroyed the DDL message processing thread " + this.getName() + ". Discarded " + this.messageQueue.size() + " messages"));
        }
    }

    public int purgeQueue(E e, Comparator<E> comp) {
        int size = this.messageQueue.size();
        this.messageQueue.purgeQueue(e, comp);
        return size - this.messageQueue.size();
    }

    public BlockingWaitNotifyQueue<E> getQueue() {
        return this.messageQueue;
    }

    public int getQueueSize() {
        return this.messageQueue.size();
    }
}

