/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.CustomClassLoadingUtil;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.UserCommunityDM;
import com.avaya.asm.datamgr.dao.LocalParamDAO;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterHelper;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMemberLeader;
import com.avaya.asm.datamgr.datadistributionlayer.DDLMessageSender;
import com.avaya.asm.datamgr.datadistributionlayer.DDLRedundancyIntfc;
import com.avaya.asm.datamgr.datadistributionlayer.DDLRetention;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUsageType;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommListener;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DataDistLayerFactory {
    private static Logger log = AsmLogger.getLogger(DataDistLayerFactory.class);
    private final ExecutorService exe = Executors.newFixedThreadPool(1);
    private static volatile DataDistLayerFactory myInstance = null;
    protected DDLInterClusterMember interMember = null;
    protected DDLIntraClusterMember intraMember = null;
    protected ClassLoader customClassLoader = null;
    protected GroupCommIntf.JGroupsVersion currentVersion = null;
    private static boolean tryJndi = true;
    private static boolean ppmInterClusterEnabled = false;
    protected ConcurrentMap<DataDistLayerMember, Object> rejoinMap = new ConcurrentHashMap<DataDistLayerMember, Object>();
    private String ddlFactoryHandle;
    private int ddlFactoryHandleVersion = 0;

    protected DataDistLayerFactory() {
        this.updateDMFactoryHandle();
    }

    protected void init() {
        String clusterVersion = DDLUtilities.getClusterVersion();
        this.currentVersion = GroupCommIntf.JGroupsVersion.getVersion(clusterVersion);
        log.info((Object)("Using " + this.currentVersion.name() + " for cluster version=" + clusterVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataDistLayerFactory getInstance() {
        if (myInstance != null) return myInstance;
        Class<DataDistLayerFactory> clazz = DataDistLayerFactory.class;
        synchronized (DataDistLayerFactory.class) {
            if (myInstance != null) return myInstance;
            if (tryJndi) {
                try {
                    InitialContext ctx = new InitialContext();
                    myInstance = (DataDistLayerFactory)ctx.lookup("DataDistLayerFactory");
                    log.info((Object)"Using JNDI instance for DDLFactory");
                }
                catch (NamingException e) {
                    if (log.isFineEnabled()) {
                        log.fine((Object)"Unable to find binding for DataDistLayerFactory - if this is not a bootstrapping application, this is an error");
                    }
                }
                catch (Exception e) {
                    log.error((Object)"getInstance: Unexpected error", (Throwable)e);
                }
            }
            if (myInstance != null) return myInstance;
            myInstance = new DataDistLayerFactory();
            myInstance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    public synchronized void createInterMember(String interClusterName, List<DataDistLayerListener> listeners, DDLInterClusterHelper interHelper, String memberName) {
        if (this.interMember != null) {
            log.warn((Object)"createInterMember: Already created an inter cluster member, use getInterMember().");
            return;
        }
        if (this.intraMember != null && !(this.intraMember instanceof DDLIntraClusterMemberLeader)) {
            log.warn((Object)"createInterMember: Detected that a non-leader Intra cluster member exists.  DDL will not function properly in this configuration.");
        }
        this.interMember = new DDLInterClusterMember(interClusterName, interHelper, memberName, this);
        this.loadListeners(this.interMember, listeners);
        DDLMessageSender.interMember = this.interMember;
        this.interMember.joinTheGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean rejoinMember(DataDistLayerMember member) {
        boolean notPending;
        if (member == null) {
            return false;
        }
        boolean bl = notPending = this.rejoinMap.putIfAbsent(member, new Object()) == null;
        if (notPending) {
            ConcurrentMap<DataDistLayerMember, Object> concurrentMap = this.rejoinMap;
            synchronized (concurrentMap) {
                boolean failure = true;
                try {
                    member.leaveTheGroup(true);
                    String clusterName = member instanceof DDLInterClusterMember ? this.getInterClusterName() : this.getIntraClusterName();
                    member.setMyClusterName(clusterName);
                    if (!AsmCommon.jUnitEnvironment) {
                        Thread.sleep(3000L);
                    }
                    member.joinTheGroup();
                    failure = member.getMembers() == null || member.getMembers().size() == 0;
                    int i = 0;
                    while (++i <= 5 && failure) {
                        if (!AsmCommon.jUnitEnvironment) {
                            Thread.sleep(500L);
                        }
                        failure = member.getMembers() == null || member.getMembers().size() == 0;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not rejoin: ", (Throwable)e);
                }
                finally {
                    this.rejoinMap.remove(member);
                }
                return !failure;
            }
        }
        return null;
    }

    public void asynchRejoinMember(final DataDistLayerMember member) {
        if (this.rejoinMap.get(member) == null) {
            this.exe.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("asynchRejoinMemberThread");
                    DataDistLayerFactory.this.rejoinMember(member);
                }
            });
        }
    }

    public synchronized void createIntraMember(String intraClusterName, List<DataDistLayerListener> listeners, boolean isLeader, String memberName, List<DDLRetention> retentionList, DDLRedundancyIntfc redundancyHandler) {
        if (this.intraMember != null) {
            log.warn((Object)"createInterMember: Already created an intra cluster member, use getInterMember().");
            return;
        }
        if (isLeader) {
            this.intraMember = new DDLIntraClusterMemberLeader(intraClusterName, memberName, retentionList, this, redundancyHandler);
        } else {
            this.intraMember = new DDLIntraClusterMember(intraClusterName, memberName, this);
            if (this.interMember != null) {
                log.warn((Object)"createIntraMember: Detected that an inter cluster member exists.  DDL will not function properly in this configuration.");
            }
        }
        this.loadListeners(this.intraMember, listeners);
        DDLMessageSender.intraMember = this.intraMember;
        this.intraMember.joinTheGroup();
    }

    private void loadListeners(DataDistLayerMember member, List<DataDistLayerListener> listeners) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("loadListeners: " + (member instanceof DDLIntraClusterMember ? "intra" : "inter") + "member: " + listeners));
        }
        if (listeners != null) {
            for (DataDistLayerListener listener : listeners) {
                member.addListener(listener);
            }
        }
    }

    public DDLInterClusterMember getInterClusterMember() {
        return this.interMember;
    }

    public DDLIntraClusterMember getIntraClusterMember() {
        return this.intraMember;
    }

    public String getInterClusterName() {
        String clusterName = this.currentVersion.getInterClusterName();
        return ppmInterClusterEnabled ? clusterName + "_PPM" : clusterName;
    }

    public String getIntraClusterName() {
        return this.currentVersion.getIntraClusterName();
    }

    public void destroy() {
        this.exe.shutdown();
        if (this.interMember != null) {
            this.interMember.destroy();
        }
        if (this.intraMember != null) {
            this.intraMember.destroy();
        }
        this.customClassLoader = null;
        myInstance = null;
    }

    public void destroyListeners(ClassLoader targetClassLoader) {
        this.destroyListener(targetClassLoader, this.intraMember);
        this.destroyListener(targetClassLoader, this.interMember);
    }

    protected void destroyListener(ClassLoader targetClassLoader, DataDistLayerMember member) {
        if (member == null) {
            return;
        }
        for (DataDistLayerListener listener : member.getListenerMap().values()) {
            if (!listener.getClass().getClassLoader().equals(targetClassLoader)) continue;
            log.info((Object)("destroyListener: Destroying application specific listener: " + listener.getClass().getSimpleName()));
            listener.destroy();
            member.removeListener(listener);
        }
    }

    public void updateDDLNodeResolver(DDLInterClusterHelper interHelper) {
        if (this.interMember != null) {
            this.interMember.setInterHelper(interHelper);
        }
    }

    public void setIntraMember(DDLIntraClusterMember member) {
        this.intraMember = member;
    }

    protected synchronized ClassLoader getJGroupsClassLoader() {
        if (this.customClassLoader == null) {
            this.customClassLoader = CustomClassLoadingUtil.createCustomClassLoader(new File[]{this.currentVersion.getJgroupsJar(), this.currentVersion.getWrapperJar()});
        }
        return this.customClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized GroupCommIntf createGroupCommIntf(String groupName, GroupCommListener listener, String myIp, Vector<String> otherHosts, GroupCommIntf.DDLGroupType groupType) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        ClassLoader newCl = this.getJGroupsClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newCl);
            DMFactory factory = this.getDMFactory();
            if (factory != null) {
                factory.registerIgnoredCL(this.getDDLFactoryHandle());
            }
            GroupCommIntf groupCommIntf = (GroupCommIntf)CustomClassLoadingUtil.load(this.currentVersion.getWrapperClass(), new Class[]{String.class, GroupCommListener.class, String.class, Vector.class, GroupCommIntf.DDLGroupType.class, GroupCommIntf.JGroupsVersion.class}, new Object[]{groupName, listener, myIp, otherHosts, groupType, this.currentVersion}, newCl);
            return groupCommIntf;
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to load GroupCommIntf:", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        return null;
    }

    public void changeJgroupVersion(final String newMinSmVersion) {
        ((LocalParamDAO)this.getDMFactory().getDataMgr(LocalParamDAO.class)).updateLocally("MIN_SM_VERSION", newMinSmVersion);
        this.currentVersion = GroupCommIntf.JGroupsVersion.getVersion(newMinSmVersion);
        Runnable rejoiner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setName("changeJGVersionRejoinerThread");
                log.info((Object)("changeJgroupVersion:  Changing jgroups version to be compatible with minimum SM version of " + newMinSmVersion));
                String updatedMinSmVersion = null;
                ConcurrentMap<DataDistLayerMember, Object> concurrentMap = DataDistLayerFactory.this.rejoinMap;
                synchronized (concurrentMap) {
                    try {
                        if (!AsmCommon.jUnitEnvironment) {
                            Thread.sleep(1000L);
                        }
                        DataDistLayerFactory.this.rejoinMap.putIfAbsent(DataDistLayerFactory.this.intraMember, new Object());
                        DataDistLayerFactory.this.intraMember.leaveTheGroup(true);
                        if (DataDistLayerFactory.this.intraMember instanceof DDLIntraClusterMemberLeader) {
                            ((DDLIntraClusterMemberLeader)DataDistLayerFactory.this.intraMember).clearRedundancyCache();
                        }
                        if (DataDistLayerFactory.this.interMember != null) {
                            DataDistLayerFactory.this.rejoinMap.putIfAbsent(DataDistLayerFactory.this.interMember, new Object());
                            DataDistLayerFactory.this.interMember.leaveTheGroup(true);
                        }
                        DataDistLayerFactory.this.customClassLoader = null;
                        DataDistLayerFactory.this.updateDMFactoryHandle();
                        if (!AsmCommon.jUnitEnvironment) {
                            Thread.sleep(3000L);
                        }
                        DataDistLayerFactory.this.intraMember.joinTheGroup();
                        if (DataDistLayerFactory.this.interMember != null) {
                            DataDistLayerFactory.this.interMember.setMyClusterName(DataDistLayerFactory.this.getInterClusterName());
                            DataDistLayerFactory.this.interMember.joinTheGroup();
                        }
                        if (GroupCommIntf.JGroupsVersion.getVersion(newMinSmVersion) != GroupCommIntf.JGroupsVersion.getVersion(DDLUtilities.getClusterVersion())) {
                            updatedMinSmVersion = DDLUtilities.getClusterVersion();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error trying to change jgroup version.", (Throwable)e);
                    }
                    finally {
                        DataDistLayerFactory.this.rejoinMap.remove(DataDistLayerFactory.this.intraMember);
                        if (DataDistLayerFactory.this.interMember != null) {
                            DataDistLayerFactory.this.rejoinMap.remove(DataDistLayerFactory.this.interMember);
                        }
                    }
                }
                log.info((Object)("changeJgroupVersion: Completed changing jgroups version compatible for minimum SM version of " + newMinSmVersion));
                if (updatedMinSmVersion != null) {
                    log.warn((Object)("changeJgroupVersion: Version changed from while we were rejoining.  Executing again for " + updatedMinSmVersion));
                    DataDistLayerFactory.this.changeJgroupVersion(updatedMinSmVersion);
                }
            }
        };
        try {
            this.exe.submit(rejoiner);
        }
        catch (Exception e) {
            log.warn((Object)"changeJgroupVersion: exe.submit() threw exception", (Throwable)e);
            this.exe.shutdownNow();
        }
    }

    public boolean notifyMembersForJgroupsVersion(String minSmVersion) {
        if (this.intraMember != null) {
            log.info((Object)("Notifying all intra cluster members to pick up new jgroups version for SM version: " + minSmVersion));
            this.intraMember.multicastMessage(new DataDistLayerMessage(new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 26, (Serializable)((Object)minSmVersion))), true);
            return true;
        }
        return false;
    }

    protected DMFactory getDMFactory() {
        return DMFactory.getInstance();
    }

    public void setupJGroupClusters(DDLUsageType usageType) {
        this.setupJGroupClusters(usageType, null);
    }

    public void setupJGroupClusters(final DDLUsageType usageType, final DataDistLayerListener listener) {
        ExecutorService jgroupexe = Executors.newFixedThreadPool(1);
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Thread.currentThread().setName("setupJGClusterThread");
                try {
                    DataDistLayerFactory.this.runSetupJGroupClusters(usageType, listener);
                }
                catch (Exception e) {
                    StringBuilder builder = new StringBuilder("runSetupJGroupClusters(" + usageType.getMemberName() + ") caught exception: " + e);
                    for (StackTraceElement element : e.getStackTrace()) {
                        builder.append("\n" + element);
                    }
                    log.error((Object)builder.toString());
                    return false;
                }
                return true;
            }
        };
        jgroupexe.submit(task);
    }

    public void setupJGroupPPMClusters(final DDLUsageType usageType, final DataDistLayerListener listener) {
        ExecutorService jgroupexe = Executors.newFixedThreadPool(1);
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Thread.currentThread().setName("setupJGPPMClusterThread");
                try {
                    DataDistLayerFactory.this.runSetupJGroupPPMClusters(usageType, listener);
                }
                catch (Exception e) {
                    StringBuilder builder = new StringBuilder("runSetupJGroupPPMClusters(" + usageType.getMemberName() + ") caught exception: " + e);
                    for (StackTraceElement element : e.getStackTrace()) {
                        builder.append("\n" + element);
                    }
                    log.error((Object)builder.toString());
                    return false;
                }
                return true;
            }
        };
        jgroupexe.submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runSetupJGroupClusters(DDLUsageType usageType, DataDistLayerListener listener) {
        List<DataDistLayerListener> listeners = usageType.getUsageListeners();
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        ClassLoader ddlCl = DataDistLayerFactory.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ddlCl);
            if (!DMUtilities.getCurrentThreadIdentity(origCl).equals(DMUtilities.getCurrentThreadIdentity(ddlCl))) {
                DMFactory.getInstance().registerIgnoredCL(this.getDDLFactoryHandle());
            }
            boolean isLeaderSetting = usageType.isLeader();
            DDLRedundancyIntfc redundancyHandler = null;
            if (isLeaderSetting) {
                redundancyHandler = (DDLRedundancyIntfc)((Object)this.getDMFactory().getDataMgr(UserCommunityDM.class));
            }
            if (this.intraMember != null) {
                if (log.isFineEnabled()) {
                    log.fine((Object)"setupJGroupClusters: INTRA: Updating listener list for existing member.");
                }
                if (!(this.intraMember instanceof DDLIntraClusterMemberLeader) && isLeaderSetting) {
                    log.info((Object)"Changing implementation of intra member to be a leader.");
                    listeners = listeners == null ? new ArrayList<DataDistLayerListener>() : new ArrayList<DataDistLayerListener>(listeners);
                    listeners.addAll(this.intraMember.getListenerMap().values());
                    this.intraMember.leaveTheGroup(false);
                    this.intraMember = null;
                } else {
                    if (log.isFineEnabled()) {
                        log.fine((Object)"setupJGroupClusters: INTRA: Adding new listeners.");
                    }
                    this.loadListeners(this.intraMember, listeners);
                    if (isLeaderSetting && this.intraMember instanceof DDLIntraClusterMemberLeader) {
                        if (log.isFineEnabled()) {
                            log.fine((Object)"setupJGroupClusters: INTRA: Updating retention rules.");
                        }
                        ((DDLIntraClusterMemberLeader)this.intraMember).setRetentionList(usageType.getRetentionRules());
                    }
                }
            }
            if (this.intraMember == null) {
                this.createIntraMember(this.getIntraClusterName(), listeners, isLeaderSetting, usageType.getMemberName(), usageType.getRetentionRules(), redundancyHandler);
            }
            if (isLeaderSetting) {
                List<DataDistLayerListener> interListeners = usageType.getInterClusterUsageListeners();
                if (this.interMember != null) {
                    if (log.isFineEnabled()) {
                        log.fine((Object)"setupJGroupClusters: INTER: Updating listener list for existing member.");
                    }
                    this.loadListeners(this.interMember, interListeners);
                } else {
                    this.createInterMember(this.getInterClusterName(), interListeners, this.currentVersion.getInterClusterHelper(), usageType.getMemberName());
                }
            }
            if (listener != null) {
                if (this.intraMember != null) {
                    this.intraMember.addListener(listener);
                }
                if (this.interMember != null) {
                    this.interMember.addListener(listener);
                }
            }
            log.info((Object)("setupJGroupClusters: INTRA: " + (this.intraMember == null ? null : this.intraMember.getListenerMap())));
            log.info((Object)("setupJGroupClusters: INTER " + (this.interMember == null ? null : this.interMember.getListenerMap())));
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runSetupJGroupPPMClusters(DDLUsageType usageType, DataDistLayerListener listener) {
        ppmInterClusterEnabled = true;
        List<DataDistLayerListener> listeners = usageType.getUsageListeners();
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        ClassLoader ddlCl = DataDistLayerFactory.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ddlCl);
            boolean isLeaderSetting = usageType.isLeader();
            DDLRedundancyIntfc redundancyHandler = null;
            if (isLeaderSetting) {
                redundancyHandler = (DDLRedundancyIntfc)((Object)this.getDMFactory().getDataMgr(UserCommunityDM.class));
            }
            if (isLeaderSetting) {
                List<DataDistLayerListener> interListeners = usageType.getInterClusterUsageListeners();
                if (interListeners == null) {
                    interListeners = new ArrayList<DataDistLayerListener>();
                }
                interListeners.add(listener);
                if (this.interMember != null) {
                    if (log.isFineEnabled()) {
                        log.fine((Object)"runSetupJGroupPPMClusters: INTER: Updating listener list for existing member.");
                    }
                    this.loadListeners(this.interMember, interListeners);
                } else {
                    this.createInterMember(this.getInterClusterName(), interListeners, this.currentVersion.getInterClusterHelper(), usageType.getMemberName());
                }
            }
            if (listener != null && this.interMember != null) {
                this.interMember.addListener(listener);
            }
            log.info((Object)("runSetupJGroupPPMClusters: INTER " + (this.interMember == null ? null : this.interMember.getListenerMap())));
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    public boolean isLeader() {
        return this.intraMember instanceof DDLIntraClusterMemberLeader;
    }

    protected synchronized void updateDMFactoryHandle() {
        this.ddlFactoryHandle = "DataDistLayerFactory" + ++this.ddlFactoryHandleVersion;
    }

    protected synchronized String getDDLFactoryHandle() {
        return this.ddlFactoryHandle;
    }

    public void setJGroupsVersion(String newMinSmVersion) {
        this.currentVersion = GroupCommIntf.JGroupsVersion.getVersion(newMinSmVersion);
    }

    public GroupCommIntf.JGroupsVersion getCurrentJGroupsVersion() {
        return this.currentVersion;
    }

    public static void setTryJndi(boolean tryJndi) {
        DataDistLayerFactory.tryJndi = tryJndi;
    }
}

