/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.helpers.ObjectPool;
import com.avaya.asm.datamgr.helpers.ObjectPoolUtils;
import com.avaya.asm.datamgr.helpers.Parameter;
import com.avaya.common.logging.client.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

@XmlRootElement(name="ConfigData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class AsmSipDeviceConfigDataTO
implements Serializable {
    private static final long serialVersionUID = -7885557865781995763L;
    private static final Logger log = AsmLogger.getLogger(AsmSipDeviceConfigDataTO.class);
    private String version;
    @XmlElement(name="parameter")
    private List<Parameter> parameters;
    private static final Object MONITOR = new Object();
    private static JAXBContext jaxbContext;
    private static ObjectPool<Marshaller> marshallerPool;
    private static ObjectPool<Unmarshaller> unmarshallerPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsmSipDeviceConfigDataTO fromXMLString(String deviceConfig) throws JAXBException {
        String fcn_name = "fromXMLString";
        AsmSipDeviceConfigDataTO.initJaxbContext();
        if (deviceConfig == null || deviceConfig.isEmpty()) {
            return new AsmSipDeviceConfigDataTO();
        }
        Unmarshaller unmarshaller = AsmSipDeviceConfigDataTO.getUnmarshaller();
        if (unmarshaller == null) {
            log.error((Object)"fromXMLString: new unmarshaller was null");
            return null;
        }
        UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
        SAXParser sp = null;
        AsmSipDeviceConfigDataTO deviceConfigDTO = null;
        try {
            sp = ObjectPoolUtils.getSAXParser();
            if (sp == null) {
                log.error((Object)"fromXMLString: new SAXParser was null");
                return null;
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            log.error((Object)"fromXMLString: newSAXParser threw exception", (Throwable)e);
            return null;
        }
        try {
            XMLReader xr = null;
            try {
                xr = sp.getXMLReader();
            }
            catch (SAXException e) {
                log.error((Object)"fromXMLString: getXMLReader threw exception", (Throwable)e);
                AsmSipDeviceConfigDataTO asmSipDeviceConfigDataTO = null;
                ObjectPoolUtils.returnSAXParser(sp);
                AsmSipDeviceConfigDataTO.returnUnmarshaller(unmarshaller);
                return asmSipDeviceConfigDataTO;
            }
            NamespaceFilter filter = new NamespaceFilter();
            filter.setParent(xr);
            filter.setContentHandler((ContentHandler)unmarshallerHandler);
            StringReader sr = new StringReader(deviceConfig);
            InputSource is = new InputSource(sr);
            try {
                filter.parse(is);
            }
            catch (IOException | SAXException e) {
                log.error((Object)"fromXMLString: filter.parse threw exception", (Throwable)e);
                AsmSipDeviceConfigDataTO asmSipDeviceConfigDataTO = null;
                ObjectPoolUtils.returnSAXParser(sp);
                AsmSipDeviceConfigDataTO.returnUnmarshaller(unmarshaller);
                return asmSipDeviceConfigDataTO;
            }
            deviceConfigDTO = (AsmSipDeviceConfigDataTO)unmarshallerHandler.getResult();
        }
        finally {
            ObjectPoolUtils.returnSAXParser(sp);
            AsmSipDeviceConfigDataTO.returnUnmarshaller(unmarshaller);
        }
        return deviceConfigDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXMLString(Boolean formatOutput) throws JAXBException {
        String fcn_name = "toXMLString";
        AsmSipDeviceConfigDataTO.initJaxbContext();
        Marshaller marshaller = AsmSipDeviceConfigDataTO.getMarshaller(formatOutput);
        if (marshaller == null) {
            log.error((Object)"toXMLString: new marshaller was null");
            return null;
        }
        String xmlStr = null;
        try {
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)this, (Writer)sw);
            xmlStr = sw.toString();
        }
        finally {
            AsmSipDeviceConfigDataTO.returnMarshaller(marshaller);
        }
        return xmlStr;
    }

    public AsmSipDeviceConfigDataTO(String version, List<Parameter> parameters) throws JAXBException {
        this.version = version;
        this.parameters = parameters;
    }

    public AsmSipDeviceConfigDataTO() throws JAXBException {
        this.version = "";
        this.parameters = new ArrayList<Parameter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            Object object = MONITOR;
            synchronized (object) {
                if (jaxbContext == null) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AsmSipDeviceConfigDataTO.class});
                    marshallerPool = new ObjectPool("Marshaller");
                    unmarshallerPool = new ObjectPool("UnMarshaller");
                }
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> paramMap) {
        this.parameters = paramMap;
    }

    public Parameter getParameter(String name) {
        Parameter retParm = new Parameter();
        ListIterator<Parameter> it = this.parameters.listIterator();
        while (it.hasNext()) {
            Parameter currParm = it.next();
            if (!currParm.getName().equals(name)) continue;
            retParm = currParm;
            break;
        }
        return retParm;
    }

    public Map<String, Parameter> getParametersAsMap() {
        HashMap<String, Parameter> retMap = new HashMap<String, Parameter>();
        ListIterator<Parameter> it = this.parameters.listIterator();
        while (it.hasNext()) {
            Parameter currParm = it.next();
            String key = currParm.getName();
            retMap.put(key, currParm);
        }
        return retMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AsmSipDeviceConfigDataTO)) {
            return false;
        }
        AsmSipDeviceConfigDataTO other = (AsmSipDeviceConfigDataTO)obj;
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "AsmSipDeviceConfigDataTO [version=" + this.version + ", parameters=" + this.parameters + "]";
    }

    public static Marshaller getMarshaller(final boolean formatOutput) {
        String fcn_name = "getMarshaller";
        Marshaller marshaller = null;
        try {
            marshaller = marshallerPool.get(new ObjectPool.ObjectAllocator<Marshaller, JAXBException>(){

                @Override
                public Marshaller allocate() throws JAXBException {
                    Marshaller marshaller = jaxbContext.createMarshaller();
                    marshaller.setProperty("jaxb.fragment", (Object)true);
                    marshaller.setProperty("jaxb.formatted.output", (Object)formatOutput);
                    return marshaller;
                }
            });
        }
        catch (JAXBException e) {
            log.error((Object)"getMarshaller: JAXBException caught creating a Marshaller", (Throwable)e);
        }
        return marshaller;
    }

    public static void returnMarshaller(Marshaller marshaller) {
        marshallerPool.release(marshaller);
    }

    public static Unmarshaller getUnmarshaller() {
        String fcn_name = "getUnmarshaller";
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = unmarshallerPool.get(new ObjectPool.ObjectAllocator<Unmarshaller, JAXBException>(){

                @Override
                public Unmarshaller allocate() throws JAXBException {
                    return jaxbContext.createUnmarshaller();
                }
            });
        }
        catch (JAXBException e) {
            log.error((Object)"getUnmarshaller: JAXBException caught creating a Unmarshaller", (Throwable)e);
        }
        return unmarshaller;
    }

    public static void returnUnmarshaller(Unmarshaller unmarshaller) {
        unmarshallerPool.release(unmarshaller);
    }

    private static class NamespaceFilter
    extends XMLFilterImpl {
        private static final String NAMESPACE = "http://xml.avaya.com/endpointAPI";

        private NamespaceFilter() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(NAMESPACE, localName, qName);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(NAMESPACE, localName, qName, atts);
        }
    }
}

