/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.ConnectionPoolInitializerException;
import com.avaya.asm.datamgr.helpers.ConnectionPoolInitializerClient;
import com.avaya.common.logging.client.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConnectionPoolInitializer {
    InitStatus curState = InitStatus.START;
    final Lock lock = new ReentrantLock();
    Long initThreadId = null;
    final Condition pendingRequests = this.lock.newCondition();
    int backoffFailureTimeMS = 0;
    private static RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
    long lastFailTimeMS = 0L;
    private final Logger log = AsmLogger.getLogger(ConnectionPoolInitializer.class);

    public ConnectionPoolInitializer() {
    }

    public ConnectionPoolInitializer(int backoffFailureTimeMS) {
        this.backoffFailureTimeMS = backoffFailureTimeMS;
    }

    public int getBackoffFailureTimeMS() {
        return this.backoffFailureTimeMS;
    }

    public void setBackoffFailureTimeMS(int backoffFailureTimeMS) {
        this.backoffFailureTimeMS = backoffFailureTimeMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void checkInit(ConnectionPoolInitializerClient client) throws ConnectionPoolInitializerException {
        fcn_name = "checkInit";
        doUnlock = true;
        isFiner = this.log.isFinerEnabled();
        isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("checkInit: enter, client=" + client + ", curState=" + (Object)this.curState));
        }
        this.lock.lock();
        try {
            switch (1.$SwitchMap$com$avaya$asm$datamgr$helpers$ConnectionPoolInitializer$InitStatus[this.curState.ordinal()]) {
                case 1: {
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 2: {
                    try {
                        this.initThreadId = Thread.currentThread().getId();
                        this.performInitLocked(client);
                        break;
                    }
                    finally {
                        this.initThreadId = null;
                    }
                }
                case 3: {
                    if (this.initThreadId != null && this.initThreadId.equals(Thread.currentThread().getId())) {
                        if (isFinest) {
                            this.log.finest((Object)("checkInit: this thread has recursively called this method, tid=" + this.initThreadId));
                        }
                        this.performInit(client);
                        if (isFiner) {
                            this.log.finer((Object)("checkInit: leave, state=" + (Object)this.curState));
                        }
                        return;
                    }
                    try {
                        for (count = 0; this.curState == InitStatus.INPROGRESS && count < 1; ++count) {
                            this.pendingRequests.await();
                        }
                    }
                    catch (InterruptedException e) {
                        this.lock.unlock();
                        doUnlock = false;
                        this.log.error((Object)("checkInit: thread got interrupted, client=" + client + ", exc="), (Throwable)e);
                        throw new ConnectionPoolInitializerException("thread was interrupted waiting for completion of init()");
                    }
                    if (this.curState == InitStatus.SUCCEEDED) ** break;
                    this.lock.unlock();
                    doUnlock = false;
                    this.log.info((Object)"checkInit: after waiting, init() has still failed, throwing CPIE");
                    throw new ConnectionPoolInitializerException("connections are down");
                }
                case 4: {
                    curTimeMS = ConnectionPoolInitializer.getUptimeMS();
                    if (this.lastFailTimeMS + (long)this.backoffFailureTimeMS > curTimeMS) {
                        saveLastFailTimeMS = this.lastFailTimeMS;
                        this.lock.unlock();
                        doUnlock = false;
                        this.log.info((Object)("checkInit: we're still in backoff mode for another " + (saveLastFailTimeMS + (long)this.backoffFailureTimeMS - curTimeMS) + " msecs "));
                        throw new ConnectionPoolInitializerException("backoff mode is active");
                    }
                    this.performInitLocked(client);
                    break;
                }
                ** default:
lbl55:
                // 1 sources

                break;
            }
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
        if (isFiner) {
            this.log.finer((Object)("checkInit: leave, state=" + (Object)this.curState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performInitLocked(ConnectionPoolInitializerClient client) throws ConnectionPoolInitializerException {
        String fcn_name = "performInitLocked";
        boolean isFiner = this.log.isFinerEnabled();
        boolean doLock = true;
        this.curState = InitStatus.INPROGRESS;
        this.lock.unlock();
        if (isFiner) {
            this.log.finer((Object)("performInitLocked: enter, client=" + client));
        }
        try {
            this.performInit(client);
            this.lock.lock();
            doLock = false;
            this.curState = InitStatus.SUCCEEDED;
        }
        finally {
            if (doLock) {
                this.lock.lock();
            }
            if (this.curState == InitStatus.INPROGRESS) {
                this.curState = InitStatus.FAILED;
                this.lastFailTimeMS = ConnectionPoolInitializer.getUptimeMS();
            }
            this.pendingRequests.signalAll();
        }
        if (isFiner) {
            this.log.finer((Object)("performInitLocked: leave, curState=" + (Object)((Object)this.curState)));
        }
    }

    void performInit(ConnectionPoolInitializerClient client) throws ConnectionPoolInitializerException {
        ConnectionPoolInitializerException saveCPIE = null;
        String fcn_name = "performInit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("performInit: enter, client=" + client));
        }
        try {
            client.init();
        }
        catch (ConnectionPoolInitializerException cce) {
            saveCPIE = cce;
        }
        catch (Exception e) {
            this.log.warn((Object)"performInit: exception thrown from init(), throwing CPIE with InternalError", (Throwable)e);
            saveCPIE = new ConnectionPoolInitializerException("Exception thrown from init()", e);
        }
        if (saveCPIE != null) {
            throw saveCPIE;
        }
        if (isFiner) {
            this.log.finer((Object)"performInit, leave with SUCCESS");
        }
    }

    public void reportError(ConnectionPoolInitializerClient client) {
        try {
            this.lock.lock();
            if (this.curState == InitStatus.SUCCEEDED) {
                this.curState = InitStatus.START;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static long getUptimeMS() {
        return mxBean.getUptime();
    }

    static enum InitStatus {
        START,
        INPROGRESS,
        SUCCEEDED,
        FAILED;

    }
}

