/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.helpers.ObjectPoolUtils;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayDeque;

public class ObjectPool<T> {
    private static final Logger log = AsmLogger.getLogger(ObjectPool.class);
    private ArrayDeque<T> pool = new ArrayDeque();
    private int maxPoolSize = ObjectPoolUtils.POOL_SIZE;
    private String name;

    public ObjectPool(String name, int maxPoolSize) {
        this.name = name;
        this.maxPoolSize = maxPoolSize;
    }

    public ObjectPool(String name) {
        this.name = name;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> T get(ObjectAllocator<T, E> a) throws E {
        T t = null;
        ArrayDeque<T> arrayDeque = this.pool;
        synchronized (arrayDeque) {
            if (!this.pool.isEmpty()) {
                return this.pool.pop();
            }
            t = a.allocate();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T t) {
        String fcn_name = "release";
        String infoMsg = null;
        boolean alreadyReleased = false;
        if (t == null) {
            throw new IllegalArgumentException("Cannot release a null object");
        }
        ArrayDeque<T> arrayDeque = this.pool;
        synchronized (arrayDeque) {
            for (T p : this.pool) {
                if (p != t) continue;
                infoMsg = ": attempt to release an already released object to pool " + this.name + ", object=" + t;
                alreadyReleased = true;
            }
            if (!alreadyReleased) {
                if (this.pool.size() >= this.maxPoolSize) {
                    infoMsg = ": pool " + this.name + " is full with " + this.pool.size() + ", pool.size=" + this.pool.size();
                } else {
                    this.pool.push(t);
                }
            }
        }
        if (infoMsg != null) {
            log.info((Object)("release" + infoMsg));
        }
    }

    public static interface ObjectAllocator<T, E extends Exception> {
        public T allocate() throws E;
    }
}

